/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.XAttrPermissionFilter;
import org.apache.hadoop.hdfs.server.namenode.XAttrStorage;
import org.apache.hadoop.security.AccessControlException;

class FSDirXAttrOp {
    private static final XAttr KEYID_XATTR = XAttrHelper.buildXAttr((String)"raw.hdfs.crypto.encryption.zone", null);
    private static final XAttr UNREADABLE_BY_SUPERUSER_XATTR = XAttrHelper.buildXAttr((String)"security.hdfs.unreadable.by.superuser", null);

    FSDirXAttrOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileStatus setXAttr(FSDirectory fsd, String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag, boolean logRetryCache) throws IOException {
        INodesInPath iip;
        FSDirXAttrOp.checkXAttrsConfigFlag(fsd);
        FSDirXAttrOp.checkXAttrSize(fsd, xAttr);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        XAttrPermissionFilter.checkPermissionForApi(pc, xAttr, FSDirectory.isReservedRawName(src));
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
        xAttrs.add(xAttr);
        fsd.writeLock();
        try {
            iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE);
            src = iip.getPath();
            FSDirXAttrOp.checkXAttrChangeAccess(fsd, iip, xAttr, pc);
            FSDirXAttrOp.unprotectedSetXAttrs(fsd, iip, xAttrs, flag);
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logSetXAttrs(src, xAttrs, logRetryCache);
        return fsd.getAuditFileInfo(iip);
    }

    static List<XAttr> getXAttrs(FSDirectory fsd, String srcArg, List<XAttr> xAttrs) throws IOException {
        boolean getAll;
        String src = srcArg;
        FSDirXAttrOp.checkXAttrsConfigFlag(fsd);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        boolean isRawPath = FSDirectory.isReservedRawName(src);
        boolean bl = getAll = xAttrs == null || xAttrs.isEmpty();
        if (!getAll) {
            XAttrPermissionFilter.checkPermissionForApi(pc, xAttrs, isRawPath);
        }
        INodesInPath iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.READ);
        if (fsd.isPermissionEnabled()) {
            fsd.checkPathAccess(pc, iip, FsAction.READ);
        }
        List<XAttr> all = FSDirXAttrOp.getXAttrs(fsd, iip);
        List<XAttr> filteredAll = XAttrPermissionFilter.filterXAttrsForApi(pc, all, isRawPath);
        if (getAll) {
            return filteredAll;
        }
        if (filteredAll == null || filteredAll.isEmpty()) {
            throw new IOException("At least one of the attributes provided was not found.");
        }
        ArrayList toGet = Lists.newArrayListWithCapacity((int)xAttrs.size());
        for (XAttr xAttr : xAttrs) {
            boolean foundIt = false;
            for (XAttr a : filteredAll) {
                if (xAttr.getNameSpace() != a.getNameSpace() || !xAttr.getName().equals(a.getName())) continue;
                toGet.add(a);
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            throw new IOException("At least one of the attributes provided was not found.");
        }
        return toGet;
    }

    static List<XAttr> listXAttrs(FSDirectory fsd, String src) throws IOException {
        FSDirXAttrOp.checkXAttrsConfigFlag(fsd);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        boolean isRawPath = FSDirectory.isReservedRawName(src);
        INodesInPath iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.READ);
        if (fsd.isPermissionEnabled()) {
            fsd.checkParentAccess(pc, iip, FsAction.EXECUTE);
        }
        List<XAttr> all = FSDirXAttrOp.getXAttrs(fsd, iip);
        return XAttrPermissionFilter.filterXAttrsForApi(pc, all, isRawPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileStatus removeXAttr(FSDirectory fsd, String src, XAttr xAttr, boolean logRetryCache) throws IOException {
        INodesInPath iip;
        block4: {
            FSDirXAttrOp.checkXAttrsConfigFlag(fsd);
            FSPermissionChecker pc = fsd.getPermissionChecker();
            XAttrPermissionFilter.checkPermissionForApi(pc, xAttr, FSDirectory.isReservedRawName(src));
            ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
            xAttrs.add(xAttr);
            fsd.writeLock();
            try {
                iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE);
                src = iip.getPath();
                FSDirXAttrOp.checkXAttrChangeAccess(fsd, iip, xAttr, pc);
                List<XAttr> removedXAttrs = FSDirXAttrOp.unprotectedRemoveXAttrs(fsd, iip, xAttrs);
                if (removedXAttrs != null && !removedXAttrs.isEmpty()) {
                    fsd.getEditLog().logRemoveXAttrs(src, removedXAttrs, logRetryCache);
                    break block4;
                }
                throw new IOException("No matching attributes found for remove operation");
            }
            finally {
                fsd.writeUnlock();
            }
        }
        return fsd.getAuditFileInfo(iip);
    }

    static List<XAttr> unprotectedRemoveXAttrs(FSDirectory fsd, INodesInPath iip, List<XAttr> toRemove) throws IOException {
        assert (fsd.hasWriteLock());
        INode inode = FSDirectory.resolveLastINode(iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<XAttr> existingXAttrs = XAttrStorage.readINodeXAttrs(inode);
        ArrayList removedXAttrs = Lists.newArrayListWithCapacity((int)toRemove.size());
        List<XAttr> newXAttrs = FSDirXAttrOp.filterINodeXAttrs(existingXAttrs, toRemove, removedXAttrs);
        if (existingXAttrs.size() != newXAttrs.size()) {
            XAttrStorage.updateINodeXAttrs(inode, newXAttrs, snapshotId);
            return removedXAttrs;
        }
        return null;
    }

    @VisibleForTesting
    static List<XAttr> filterINodeXAttrs(List<XAttr> existingXAttrs, List<XAttr> toFilter, List<XAttr> filtered) throws AccessControlException {
        if (existingXAttrs == null || existingXAttrs.isEmpty() || toFilter == null || toFilter.isEmpty()) {
            return existingXAttrs;
        }
        ArrayList newXAttrs = Lists.newArrayListWithCapacity((int)existingXAttrs.size());
        for (XAttr a : existingXAttrs) {
            boolean add = true;
            ListIterator<XAttr> it = toFilter.listIterator();
            while (it.hasNext()) {
                XAttr filter = it.next();
                Preconditions.checkArgument((!KEYID_XATTR.equalsIgnoreValue((Object)filter) ? 1 : 0) != 0, (Object)"The encryption zone xattr should never be deleted.");
                if (UNREADABLE_BY_SUPERUSER_XATTR.equalsIgnoreValue((Object)filter)) {
                    throw new AccessControlException("The xattr 'security.hdfs.unreadable.by.superuser' can not be deleted.");
                }
                if (!a.equalsIgnoreValue((Object)filter)) continue;
                add = false;
                it.remove();
                filtered.add(filter);
                break;
            }
            if (!add) continue;
            newXAttrs.add(a);
        }
        return newXAttrs;
    }

    static INode unprotectedSetXAttrs(FSDirectory fsd, INodesInPath iip, List<XAttr> xAttrs, EnumSet<XAttrSetFlag> flag) throws IOException {
        assert (fsd.hasWriteLock());
        INode inode = FSDirectory.resolveLastINode(iip);
        List<XAttr> existingXAttrs = XAttrStorage.readINodeXAttrs(inode);
        List<XAttr> newXAttrs = FSDirXAttrOp.setINodeXAttrs(fsd, existingXAttrs, xAttrs, flag);
        boolean isFile = inode.isFile();
        for (XAttr xattr : newXAttrs) {
            String xaName = XAttrHelper.getPrefixedName((XAttr)xattr);
            if ("raw.hdfs.crypto.encryption.zone".equals(xaName)) {
                HdfsProtos.ZoneEncryptionInfoProto ezProto = HdfsProtos.ZoneEncryptionInfoProto.parseFrom((byte[])xattr.getValue());
                fsd.ezManager.addEncryptionZone(inode.getId(), PBHelperClient.convert((HdfsProtos.CipherSuiteProto)ezProto.getSuite()), PBHelperClient.convert((HdfsProtos.CryptoProtocolVersionProto)ezProto.getCryptoProtocolVersion()), ezProto.getKeyName());
            }
            if (isFile || !"security.hdfs.unreadable.by.superuser".equals(xaName)) continue;
            throw new IOException("Can only set 'security.hdfs.unreadable.by.superuser' on a file.");
        }
        XAttrStorage.updateINodeXAttrs(inode, newXAttrs, iip.getLatestSnapshotId());
        return inode;
    }

    static List<XAttr> setINodeXAttrs(FSDirectory fsd, List<XAttr> existingXAttrs, List<XAttr> toSet, EnumSet<XAttrSetFlag> flag) throws IOException {
        for (int i = 0; i < toSet.size(); ++i) {
            for (int j = i + 1; j < toSet.size(); ++j) {
                if (!toSet.get(i).equalsIgnoreValue((Object)toSet.get(j))) continue;
                throw new IOException("Cannot specify the same XAttr to be set more than once");
            }
        }
        int userVisibleXAttrsNum = 0;
        int newSize = existingXAttrs != null ? existingXAttrs.size() : 0;
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)(newSize += toSet.size()));
        for (XAttr xAttr : toSet) {
            boolean exist = false;
            if (existingXAttrs != null) {
                for (XAttr a : existingXAttrs) {
                    if (!a.equalsIgnoreValue((Object)xAttr)) continue;
                    exist = true;
                    break;
                }
            }
            XAttrSetFlag.validate((String)xAttr.getName(), (boolean)exist, flag);
            xAttrs.add(xAttr);
            if (!FSDirXAttrOp.isUserVisible(xAttr)) continue;
            ++userVisibleXAttrsNum;
        }
        if (existingXAttrs != null) {
            for (XAttr existing : existingXAttrs) {
                boolean alreadySet = false;
                for (XAttr set : toSet) {
                    if (!set.equalsIgnoreValue((Object)existing)) continue;
                    alreadySet = true;
                    break;
                }
                if (alreadySet) continue;
                xAttrs.add(existing);
                if (!FSDirXAttrOp.isUserVisible(existing)) continue;
                ++userVisibleXAttrsNum;
            }
        }
        if (userVisibleXAttrsNum > fsd.getInodeXAttrsLimit()) {
            throw new IOException("Cannot add additional XAttr to inode, would exceed limit of " + fsd.getInodeXAttrsLimit());
        }
        return xAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XAttr getXAttrByPrefixedName(FSDirectory fsd, INodesInPath iip, String prefixedName) throws IOException {
        fsd.readLock();
        try {
            XAttr xAttr = XAttrStorage.readINodeXAttrByPrefixedName(iip, prefixedName);
            return xAttr;
        }
        finally {
            fsd.readUnlock();
        }
    }

    static XAttr unprotectedGetXAttrByPrefixedName(INodesInPath iip, String prefixedName) throws IOException {
        return XAttrStorage.readINodeXAttrByPrefixedName(iip, prefixedName);
    }

    private static void checkXAttrChangeAccess(FSDirectory fsd, INodesInPath iip, XAttr xAttr, FSPermissionChecker pc) throws AccessControlException, FileNotFoundException {
        if (fsd.isPermissionEnabled() && xAttr.getNameSpace() == XAttr.NameSpace.USER) {
            INode inode = iip.getLastINode();
            if (inode != null && inode.isDirectory() && inode.getFsPermission().getStickyBit()) {
                if (!pc.isSuperUser()) {
                    fsd.checkOwner(pc, iip);
                }
            } else {
                fsd.checkPathAccess(pc, iip, FsAction.WRITE);
            }
        }
    }

    private static void checkXAttrSize(FSDirectory fsd, XAttr xAttr) {
        int size = DFSUtil.string2Bytes(xAttr.getName()).length;
        if (xAttr.getValue() != null) {
            size += xAttr.getValue().length;
        }
        if (size > fsd.getXattrMaxSize()) {
            throw new HadoopIllegalArgumentException("The XAttr is too big. The maximum combined size of the name and value is " + fsd.getXattrMaxSize() + ", but the total size is " + size);
        }
    }

    private static void checkXAttrsConfigFlag(FSDirectory fsd) throws IOException {
        if (!fsd.isXattrsEnabled()) {
            throw new IOException(String.format("The XAttr operation has been rejected.  Support for XAttrs has been disabled by setting %s to false.", "dfs.namenode.xattrs.enabled"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<XAttr> getXAttrs(FSDirectory fsd, INodesInPath iip) throws IOException {
        fsd.readLock();
        try {
            List<XAttr> list = XAttrStorage.readINodeXAttrs(fsd.getAttributes(iip));
            return list;
        }
        finally {
            fsd.readUnlock();
        }
    }

    private static boolean isUserVisible(XAttr xAttr) {
        XAttr.NameSpace ns = xAttr.getNameSpace();
        return ns == XAttr.NameSpace.USER || ns == XAttr.NameSpace.TRUSTED;
    }
}

