/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class SerialNumberMap<T> {
    private final AtomicInteger max = new AtomicInteger(1);
    private final ConcurrentMap<T, Integer> t2i = new ConcurrentHashMap<T, Integer>();
    private final ConcurrentMap<Integer, T> i2t = new ConcurrentHashMap<Integer, T>();

    public int get(T t) {
        if (t == null) {
            return 0;
        }
        Integer sn = (Integer)this.t2i.get(t);
        if (sn == null) {
            sn = this.max.getAndIncrement();
            if (sn < 0) {
                throw new IllegalStateException("Too many elements!");
            }
            Integer old = this.t2i.putIfAbsent(t, sn);
            if (old != null) {
                return old;
            }
            this.i2t.put(sn, t);
        }
        return sn;
    }

    public T get(int i) {
        if (i == 0) {
            return null;
        }
        Object t = this.i2t.get(i);
        if (t == null) {
            throw new IllegalStateException("!i2t.containsKey(" + i + "), this=" + this);
        }
        return (T)t;
    }

    public String toString() {
        return "max=" + this.max + ",\n  t2i=" + this.t2i + ",\n  i2t=" + this.i2t;
    }
}

