/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.launcher;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerLaunchedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.ContainerManager;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerRequest;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerToken;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.util.Records;

public class ContainerLauncherImpl
extends AbstractService
implements ContainerLauncher {
    static final Log LOG = LogFactory.getLog(ContainerLauncherImpl.class);
    int nmTimeOut;
    private ConcurrentHashMap<ContainerId, Container> containers = new ConcurrentHashMap();
    private AppContext context;
    protected ThreadPoolExecutor launcherPool;
    protected static final int INITIAL_POOL_SIZE = 10;
    private int limitOnPoolSize;
    private Thread eventHandlingThread;
    protected BlockingQueue<ContainerLauncherEvent> eventQueue = new LinkedBlockingQueue<ContainerLauncherEvent>();
    final Timer commandTimer = new Timer(true);
    YarnRPC rpc;
    Set<String> allNodes = new HashSet<String>();

    private Container getContainer(ContainerId id) {
        Container old;
        Container c = this.containers.get(id);
        if (c == null && (old = this.containers.putIfAbsent(id, c = new Container())) != null) {
            c = old;
        }
        return c;
    }

    private void removeContainerIfDone(ContainerId id) {
        Container c = this.containers.get(id);
        if (c != null && c.isCompletelyDone()) {
            this.containers.remove(id);
        }
    }

    public ContainerLauncherImpl(AppContext context) {
        super(ContainerLauncherImpl.class.getName());
        this.context = context;
    }

    public synchronized void init(Configuration config) {
        Configuration conf = new Configuration(config);
        conf.setInt("ipc.client.connection.maxidletime", 0);
        this.limitOnPoolSize = conf.getInt("yarn.app.mapreduce.am.containerlauncher.thread-count-limit", 500);
        LOG.info((Object)("Upper limit on the thread pool size is " + this.limitOnPoolSize));
        this.nmTimeOut = conf.getInt("yarn.app.mapreduce.am.nm-command-timeout", 60000);
        this.rpc = this.createYarnRPC(conf);
        super.init(conf);
    }

    protected YarnRPC createYarnRPC(Configuration conf) {
        return YarnRPC.create((Configuration)conf);
    }

    public void start() {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("ContainerLauncher #%d").setDaemon(true).build();
        this.launcherPool = new ThreadPoolExecutor(10, Integer.MAX_VALUE, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf);
        this.eventHandlingThread = new Thread(){

            @Override
            public void run() {
                ContainerLauncherEvent event = null;
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        event = ContainerLauncherImpl.this.eventQueue.take();
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)("Returning, interrupted : " + e));
                        return;
                    }
                    int poolSize = ContainerLauncherImpl.this.launcherPool.getCorePoolSize();
                    if (poolSize != ContainerLauncherImpl.this.limitOnPoolSize) {
                        int numNodes = ContainerLauncherImpl.this.allNodes.size();
                        int idealPoolSize = Math.min(ContainerLauncherImpl.this.limitOnPoolSize, numNodes);
                        if (poolSize < idealPoolSize) {
                            int newPoolSize = Math.min(ContainerLauncherImpl.this.limitOnPoolSize, idealPoolSize + 10);
                            LOG.info((Object)("Setting ContainerLauncher pool size to " + newPoolSize + " as number-of-nodes to talk to is " + numNodes));
                            ContainerLauncherImpl.this.launcherPool.setCorePoolSize(newPoolSize);
                        }
                    }
                    ContainerLauncherImpl.this.launcherPool.execute(ContainerLauncherImpl.this.createEventProcessor(event));
                }
            }
        };
        this.eventHandlingThread.setName("ContainerLauncher Event Handler");
        this.eventHandlingThread.start();
        super.start();
    }

    public void stop() {
        this.eventHandlingThread.interrupt();
        this.launcherPool.shutdownNow();
        super.stop();
    }

    protected EventProcessor createEventProcessor(ContainerLauncherEvent event) {
        return new EventProcessor(event);
    }

    protected ContainerManager getCMProxy(ContainerId containerID, final String containerManagerBindAddr, ContainerToken containerToken) throws IOException {
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        if (UserGroupInformation.isSecurityEnabled()) {
            Token token = new Token(containerToken.getIdentifier().array(), containerToken.getPassword().array(), new Text(containerToken.getKind()), new Text(containerToken.getService()));
            user = UserGroupInformation.createRemoteUser((String)containerID.toString());
            user.addToken(token);
        }
        ContainerManager proxy = (ContainerManager)user.doAs((PrivilegedAction)new PrivilegedAction<ContainerManager>(){

            @Override
            public ContainerManager run() {
                return (ContainerManager)ContainerLauncherImpl.this.rpc.getProxy(ContainerManager.class, NetUtils.createSocketAddr((String)containerManagerBindAddr), ContainerLauncherImpl.this.getConfig());
            }
        });
        return proxy;
    }

    void sendContainerLaunchFailedMsg(TaskAttemptId taskAttemptID, String message) {
        LOG.error((Object)message);
        this.context.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptID, message));
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED));
    }

    public void handle(ContainerLauncherEvent event) {
        try {
            this.eventQueue.put(event);
            this.allNodes.add(event.getContainerMgrAddress());
        }
        catch (InterruptedException e) {
            throw new YarnException((Throwable)e);
        }
    }

    class EventProcessor
    implements Runnable {
        private ContainerLauncherEvent event;

        EventProcessor(ContainerLauncherEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            LOG.info((Object)("Processing the event " + this.event.toString()));
            ContainerId containerID = this.event.getContainerID();
            Container c = ContainerLauncherImpl.this.getContainer(containerID);
            switch ((ContainerLauncher.EventType)this.event.getType()) {
                case CONTAINER_REMOTE_LAUNCH: {
                    ContainerRemoteLaunchEvent launchEvent = (ContainerRemoteLaunchEvent)this.event;
                    c.launch(launchEvent);
                    break;
                }
                case CONTAINER_REMOTE_CLEANUP: {
                    c.kill(this.event);
                }
            }
            ContainerLauncherImpl.this.removeContainerIfDone(containerID);
        }
    }

    private static class CommandTimerTask
    extends TimerTask {
        private final Thread commandThread;
        protected final String message;
        private boolean cancelled = false;

        public CommandTimerTask(Thread thread, ContainerLauncherEvent event) {
            this.commandThread = thread;
            this.message = "Couldn't complete " + event.getType() + " on " + event.getContainerID() + "/" + event.getTaskAttemptID() + ". Interrupting and returning";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CommandTimerTask commandTimerTask = this;
            synchronized (commandTimerTask) {
                if (this.cancelled) {
                    return;
                }
                LOG.warn((Object)this.message);
                StackTraceElement[] trace = this.commandThread.getStackTrace();
                StringBuilder logMsg = new StringBuilder();
                for (int i = 0; i < trace.length; ++i) {
                    logMsg.append("\n\tat " + trace[i]);
                }
                LOG.info((Object)("Stack trace of the command-thread: \n" + logMsg.toString()));
                this.commandThread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            CommandTimerTask commandTimerTask = this;
            synchronized (commandTimerTask) {
                this.cancelled = true;
                return super.cancel();
            }
        }
    }

    private class Container {
        private ContainerState state = ContainerState.PREP;

        public synchronized boolean isCompletelyDone() {
            return this.state == ContainerState.DONE || this.state == ContainerState.FAILED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void launch(ContainerRemoteLaunchEvent event) {
            StartContainerResponse response;
            ContainerManager proxy;
            ContainerId containerID;
            CommandTimerTask timerTask;
            TaskAttemptId taskAttemptID;
            block11: {
                block10: {
                    taskAttemptID = event.getTaskAttemptID();
                    LOG.info((Object)("Launching " + taskAttemptID));
                    if (this.state == ContainerState.KILLED_BEFORE_LAUNCH) {
                        this.state = ContainerState.DONE;
                        ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(taskAttemptID, "Container was killed before it was launched");
                        return;
                    }
                    timerTask = new CommandTimerTask(Thread.currentThread(), event);
                    String containerManagerBindAddr = event.getContainerMgrAddress();
                    containerID = event.getContainerID();
                    ContainerToken containerToken = event.getContainerToken();
                    proxy = null;
                    ContainerLauncherImpl.this.commandTimer.schedule((TimerTask)timerTask, ContainerLauncherImpl.this.nmTimeOut);
                    proxy = ContainerLauncherImpl.this.getCMProxy(containerID, containerManagerBindAddr, containerToken);
                    if (!Thread.interrupted()) break block10;
                    String message = "Container launch failed for " + containerID + " : Start-container for " + event.getContainerID() + " got interrupted. Returning.";
                    this.state = ContainerState.FAILED;
                    ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(taskAttemptID, message);
                    timerTask.cancel();
                    if (proxy == null) return;
                    ContainerLauncherImpl.this.rpc.stopProxy((Object)proxy, ContainerLauncherImpl.this.getConfig());
                    return;
                }
                ContainerLaunchContext containerLaunchContext = event.getContainer();
                StartContainerRequest startRequest = (StartContainerRequest)Records.newRecord(StartContainerRequest.class);
                startRequest.setContainerLaunchContext(containerLaunchContext);
                response = proxy.startContainer(startRequest);
                timerTask.cancel();
                if (!Thread.interrupted()) break block11;
                String message = "Container launch failed for " + containerID + " : Start-container for " + event.getContainerID() + " got interrupted. Returning.";
                this.state = ContainerState.FAILED;
                ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(taskAttemptID, message);
                timerTask.cancel();
                if (proxy == null) return;
                ContainerLauncherImpl.this.rpc.stopProxy((Object)proxy, ContainerLauncherImpl.this.getConfig());
                return;
            }
            try {
                ByteBuffer portInfo = response.getServiceResponse("mapreduce.shuffle");
                int port = -1;
                if (portInfo != null) {
                    port = ShuffleHandler.deserializeMetaData((ByteBuffer)portInfo);
                }
                LOG.info((Object)("Shuffle port returned by ContainerManager for " + taskAttemptID + " : " + port));
                if (port < 0) {
                    this.state = ContainerState.FAILED;
                    throw new IllegalStateException("Invalid shuffle port number " + port + " returned for " + taskAttemptID);
                }
                ContainerLauncherImpl.this.context.getEventHandler().handle((Event)new TaskAttemptContainerLaunchedEvent(taskAttemptID, port));
                this.state = ContainerState.RUNNING;
                timerTask.cancel();
            }
            catch (Throwable t) {
                try {
                    if (Thread.interrupted()) {
                        LOG.info((Object)("Start-container for " + event.getContainerID() + " got interrupted."));
                    }
                    String message = "Container launch failed for " + containerID + " : " + StringUtils.stringifyException((Throwable)t);
                    this.state = ContainerState.FAILED;
                    ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(taskAttemptID, message);
                    timerTask.cancel();
                }
                catch (Throwable throwable) {
                    timerTask.cancel();
                    if (proxy == null) throw throwable;
                    ContainerLauncherImpl.this.rpc.stopProxy(proxy, ContainerLauncherImpl.this.getConfig());
                    throw throwable;
                }
                if (proxy == null) return;
                ContainerLauncherImpl.this.rpc.stopProxy((Object)proxy, ContainerLauncherImpl.this.getConfig());
                return;
            }
            if (proxy == null) return;
            ContainerLauncherImpl.this.rpc.stopProxy((Object)proxy, ContainerLauncherImpl.this.getConfig());
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void kill(ContainerLauncherEvent event) {
            if (this.state == ContainerState.PREP) {
                this.state = ContainerState.KILLED_BEFORE_LAUNCH;
            } else {
                CommandTimerTask timerTask = new CommandTimerTask(Thread.currentThread(), event);
                String containerManagerBindAddr = event.getContainerMgrAddress();
                ContainerId containerID = event.getContainerID();
                ContainerToken containerToken = event.getContainerToken();
                TaskAttemptId taskAttemptID = event.getTaskAttemptID();
                LOG.info((Object)("KILLING " + taskAttemptID));
                ContainerLauncherImpl.this.commandTimer.schedule((TimerTask)timerTask, ContainerLauncherImpl.this.nmTimeOut);
                ContainerManager proxy = null;
                try {
                    proxy = ContainerLauncherImpl.this.getCMProxy(containerID, containerManagerBindAddr, containerToken);
                    if (Thread.interrupted()) {
                        LOG.info((Object)("Stop-container for " + event.getContainerID() + " got interrupted."));
                    } else {
                        StopContainerRequest stopRequest = (StopContainerRequest)Records.newRecord(StopContainerRequest.class);
                        stopRequest.setContainerId(event.getContainerID());
                        proxy.stopContainer(stopRequest);
                    }
                }
                catch (Throwable t) {
                    if (Thread.interrupted()) {
                        LOG.info((Object)("Stop-container for " + event.getContainerID() + " got interrupted."));
                    }
                    String message = "cleanup failed for container " + event.getContainerID() + " : " + StringUtils.stringifyException((Throwable)t);
                    ContainerLauncherImpl.this.context.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptID, message));
                    LOG.warn((Object)message);
                }
                finally {
                    timerTask.cancel();
                    if (Thread.interrupted()) {
                        LOG.info((Object)("Stop-container for " + event.getContainerID() + " got interrupted."));
                        ContainerLauncherImpl.this.context.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptID, "cleanup failed for container " + event.getContainerID()));
                    }
                    if (proxy != null) {
                        ContainerLauncherImpl.this.rpc.stopProxy((Object)proxy, ContainerLauncherImpl.this.getConfig());
                    }
                }
                this.state = ContainerState.DONE;
            }
            ContainerLauncherImpl.this.context.getEventHandler().handle((Event)new TaskAttemptEvent(event.getTaskAttemptID(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
        }
    }

    private static enum ContainerState {
        PREP,
        FAILED,
        RUNNING,
        DONE,
        KILLED_BEFORE_LAUNCH;

    }
}

