/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfEntryInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class ConfBlock
extends HtmlBlock {
    final AppContext appContext;
    final Configuration conf;

    @Inject
    ConfBlock(AppContext appctx, Configuration conf) {
        this.appContext = appctx;
        this.conf = conf;
    }

    protected void render(HtmlBlock.Block html) {
        String jid = this.$("job.id");
        if (jid.isEmpty()) {
            html.p()._(new Object[]{"Sorry, can't do anything without a JobID."})._();
            return;
        }
        JobId jobID = MRApps.toJobID((String)jid);
        Job job = this.appContext.getJob(jobID);
        if (job == null) {
            html.p()._(new Object[]{"Sorry, ", jid, " not found."})._();
            return;
        }
        Path confPath = job.getConfFile();
        try {
            ConfInfo info = new ConfInfo(job, this.conf);
            html.div().h3(confPath.toString())._();
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#conf").thead().tr().th(".ui-state-default", "key").th(".ui-state-default", "value")._())._()).tbody();
            for (ConfEntryInfo entry : info.getProperties()) {
                tbody.tr().td(entry.getName()).td(entry.getValue())._();
            }
            ((Hamlet.TABLE)((Hamlet.TFOOT)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TABLE)tbody._()).tfoot().tr().th().input("search_init").$type(HamletSpec.InputType.text).$name("key").$value("key")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("value").$value("value")._())._())._())._())._();
        }
        catch (IOException e) {
            LOG.error("Error while reading " + confPath, (Throwable)e);
            html.p()._(new Object[]{"Sorry got an error while reading conf file. ", confPath});
        }
    }
}

