/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEventHandler;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.mockito.Mockito;

class JHEvenHandlerForTest
extends JobHistoryEventHandler {
    private EventWriter eventWriter;
    private boolean mockHistoryProcessing = true;

    public JHEvenHandlerForTest(AppContext context, int startCount) {
        super(context, startCount);
        JobHistoryEventHandler.fileMap.clear();
    }

    public JHEvenHandlerForTest(AppContext context, int startCount, boolean mockHistoryProcessing) {
        super(context, startCount);
        this.mockHistoryProcessing = mockHistoryProcessing;
        JobHistoryEventHandler.fileMap.clear();
    }

    protected void serviceStart() {
    }

    protected EventWriter createEventWriter(Path historyFilePath) throws IOException {
        this.eventWriter = this.mockHistoryProcessing ? (EventWriter)Mockito.mock(EventWriter.class) : super.createEventWriter(historyFilePath);
        return this.eventWriter;
    }

    protected void closeEventWriter(JobId jobId) {
    }

    public EventWriter getEventWriter() {
        return this.eventWriter;
    }

    protected void processDoneFiles(JobId jobId) throws IOException {
        if (!this.mockHistoryProcessing) {
            super.processDoneFiles(jobId);
        }
    }
}

