/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.api.records;

import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskReportPBImpl;
import org.apache.hadoop.mapreduce.v2.app.MockJobs;
import org.apache.hadoop.mapreduce.v2.proto.MRProtos;
import org.apache.hadoop.yarn.util.Records;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskReport {
    @Test
    public void testSetRawCounters() {
        TaskReport report = (TaskReport)Records.newRecord(TaskReport.class);
        Counters rCounters = MockJobs.newCounters();
        report.setRawCounters(rCounters);
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = report.getCounters();
        Assert.assertNotEquals(null, (Object)counters);
    }

    @Test
    public void testBuildImplicitRawCounters() {
        TaskReportPBImpl report = new TaskReportPBImpl();
        Counters rCounters = MockJobs.newCounters();
        report.setRawCounters(rCounters);
        MRProtos.TaskReportProto protoVal = report.getProto();
        Assert.assertTrue((boolean)protoVal.hasCounters());
    }

    @Test
    public void testCountersOverRawCounters() {
        TaskReport report = (TaskReport)Records.newRecord(TaskReport.class);
        Counters rCounters = MockJobs.newCounters();
        org.apache.hadoop.mapreduce.v2.api.records.Counters altCounters = TypeConverter.toYarn((Counters)rCounters);
        report.setRawCounters(rCounters);
        report.setCounters(altCounters);
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = report.getCounters();
        Assertions.assertThat((Object)counters).isNotNull();
        Assert.assertNotEquals((Object)rCounters, (Object)altCounters);
        Assert.assertEquals((Object)counters, (Object)altCounters);
    }

    @Test
    public void testUninitializedCounters() {
        TaskReport report = (TaskReport)Records.newRecord(TaskReport.class);
        Assertions.assertThat((Object)report.getCounters()).isNull();
        Assertions.assertThat((Iterable)report.getRawCounters()).isNull();
    }

    @Test
    public void testSetRawCountersToNull() {
        TaskReport report = (TaskReport)Records.newRecord(TaskReport.class);
        report.setRawCounters(null);
        Assertions.assertThat((Object)report.getCounters()).isNull();
        Assertions.assertThat((Iterable)report.getRawCounters()).isNull();
    }

    @Test
    public void testSetCountersToNull() {
        TaskReport report = (TaskReport)Records.newRecord(TaskReport.class);
        report.setCounters(null);
        Assertions.assertThat((Object)report.getCounters()).isNull();
        Assertions.assertThat((Iterable)report.getRawCounters()).isNull();
    }

    @Test
    public void testSetNonNullCountersToNull() {
        TaskReport report = (TaskReport)Records.newRecord(TaskReport.class);
        Counters rCounters = MockJobs.newCounters();
        report.setRawCounters(rCounters);
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = report.getCounters();
        Assert.assertNotEquals(null, (Object)counters);
        report.setCounters(null);
        Assertions.assertThat((Object)report.getCounters()).isNull();
        Assertions.assertThat((Iterable)report.getRawCounters()).isNull();
    }

    @Test
    public void testSetNonNullRawCountersToNull() {
        TaskReport report = (TaskReport)Records.newRecord(TaskReport.class);
        Counters rCounters = MockJobs.newCounters();
        report.setRawCounters(rCounters);
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = report.getCounters();
        Assert.assertNotEquals(null, (Object)counters);
        report.setRawCounters(null);
        Assertions.assertThat((Object)report.getCounters()).isNull();
        Assertions.assertThat((Iterable)report.getRawCounters()).isNull();
    }
}

