/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.security;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapreduce.v2.api.HSClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.yarn.api.records.DelegationToken;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
public class MRDelegationTokenRenewer
extends TokenRenewer {
    private static final Log LOG = LogFactory.getLog(MRDelegationTokenRenewer.class);

    public boolean handleKind(Text kind) {
        return MRDelegationTokenIdentifier.KIND_NAME.equals((Object)kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        DelegationToken dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        MRClientProtocol histProxy = this.instantiateHistoryProxy(conf, SecurityUtil.getTokenServiceAddr(token));
        try {
            RenewDelegationTokenRequest request = (RenewDelegationTokenRequest)Records.newRecord(RenewDelegationTokenRequest.class);
            request.setDelegationToken(dToken);
            long l = histProxy.renewDelegationToken(request).getNextExpirationTime();
            return l;
        }
        finally {
            this.stopHistoryProxy(histProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        DelegationToken dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        MRClientProtocol histProxy = this.instantiateHistoryProxy(conf, SecurityUtil.getTokenServiceAddr(token));
        try {
            CancelDelegationTokenRequest request = (CancelDelegationTokenRequest)Records.newRecord(CancelDelegationTokenRequest.class);
            request.setDelegationToken(dToken);
            histProxy.cancelDelegationToken(request);
        }
        finally {
            this.stopHistoryProxy(histProxy);
        }
    }

    public boolean isManaged(Token<?> token) throws IOException {
        return true;
    }

    protected void stopHistoryProxy(MRClientProtocol proxy) {
        RPC.stopProxy((Object)proxy);
    }

    protected MRClientProtocol instantiateHistoryProxy(final Configuration conf, final InetSocketAddress hsAddress) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connecting to MRHistoryServer at: " + hsAddress));
        }
        final YarnRPC rpc = YarnRPC.create((Configuration)conf);
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        return (MRClientProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<MRClientProtocol>(){

            @Override
            public MRClientProtocol run() {
                return (MRClientProtocol)rpc.getProxy(HSClientProtocol.class, hsAddress, conf);
            }
        });
    }
}

