/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.counters.AbstractCounterGroup;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.counters.CounterGroupBase;
import org.apache.hadoop.mapreduce.counters.CounterGroupFactory;
import org.apache.hadoop.mapreduce.counters.FileSystemCounterGroup;
import org.apache.hadoop.mapreduce.counters.FrameworkCounterGroup;
import org.apache.hadoop.mapreduce.counters.GenericCounter;
import org.apache.hadoop.mapreduce.counters.Limits;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormatCounter;
import org.apache.hadoop.mapreduce.util.CountersStrings;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class Counters
extends AbstractCounters<Counter, Group> {
    private static final GroupFactory groupFactory = new GroupFactory();

    public Counters() {
        super(groupFactory);
    }

    public Counters(org.apache.hadoop.mapreduce.Counters newCounters) {
        super(newCounters, groupFactory);
    }

    static Counters downgrade(org.apache.hadoop.mapreduce.Counters newCounters) {
        return new Counters(newCounters);
    }

    static long getCounterValue(Group group, String counterName) {
        Counter counter = (Counter)group.findCounter(counterName, false);
        if (counter != null) {
            return counter.getValue();
        }
        return 0L;
    }

    @Override
    public synchronized Counter findCounter(String group, String name) {
        if (name.equals("MAP_INPUT_BYTES")) {
            LOG.warn((Object)"Counter name MAP_INPUT_BYTES is deprecated. Use FileInputFormatCounters as group name and  BYTES_READ as counter name instead");
            return (Counter)this.findCounter(FileInputFormatCounter.BYTES_READ);
        }
        return ((Group)this.getGroup(group)).getCounterForName(name);
    }

    @Deprecated
    public Counter findCounter(String group, int id, String name) {
        return this.findCounter(group, name);
    }

    public void incrCounter(Enum<?> key, long amount) {
        ((Counter)this.findCounter(key)).increment(amount);
    }

    public void incrCounter(String group, String counter, long amount) {
        this.findCounter(group, counter).increment(amount);
    }

    public synchronized long getCounter(Enum<?> key) {
        return ((Counter)this.findCounter(key)).getValue();
    }

    public synchronized void incrAllCounters(Counters other) {
        for (Group otherGroup : other) {
            Group group = (Group)this.getGroup(otherGroup.getName());
            group.setDisplayName(otherGroup.getDisplayName());
            for (Counter otherCounter : otherGroup) {
                Counter counter = group.getCounterForName(otherCounter.getName());
                counter.setDisplayName(otherCounter.getDisplayName());
                counter.increment(otherCounter.getValue());
            }
        }
    }

    public int size() {
        return this.countCounters();
    }

    public static Counters sum(Counters a, Counters b) {
        Counters counters = new Counters();
        counters.incrAllCounters(a);
        counters.incrAllCounters(b);
        return counters;
    }

    public void log(Log log) {
        log.info((Object)("Counters: " + this.size()));
        for (Group group : this) {
            log.info((Object)("  " + group.getDisplayName()));
            for (Counter counter : group) {
                log.info((Object)("    " + counter.getDisplayName() + "=" + counter.getCounter()));
            }
        }
    }

    public String makeEscapedCompactString() {
        return CountersStrings.toEscapedCompactString(this);
    }

    public static Counters fromEscapedCompactString(String compactString) throws ParseException {
        return CountersStrings.parseEscapedCompactString(compactString, new Counters());
    }

    static class GroupFactory
    extends CounterGroupFactory<Counter, Group> {
        GroupFactory() {
        }

        @Override
        protected <T extends Enum<T>> CounterGroupFactory.FrameworkGroupFactory<Group> newFrameworkGroupFactory(final Class<T> cls) {
            return new CounterGroupFactory.FrameworkGroupFactory<Group>(){

                @Override
                public Group newGroup(String name) {
                    return new FrameworkGroupImpl(cls);
                }
            };
        }

        @Override
        protected Group newGenericGroup(String name, String displayName, Limits limits) {
            return new GenericGroup(name, displayName, limits);
        }

        @Override
        protected Group newFileSystemGroup() {
            return new FSGroupImpl();
        }
    }

    private static class FSGroupImpl
    extends FileSystemCounterGroup<Counter>
    implements Group {
        private FSGroupImpl() {
        }

        @Override
        protected Counter newCounter(String scheme, FileSystemCounter key) {
            return new FSCounterImpl(scheme, key);
        }

        @Override
        public long getCounter(String counterName) {
            return Counters.getCounterValue(this, counterName);
        }

        @Override
        public String makeEscapedCompactString() {
            return CountersStrings.toEscapedCompactString(this);
        }

        @Override
        @Deprecated
        public Counter getCounter(int id, String name) {
            return (Counter)this.findCounter(name);
        }

        @Override
        public Counter getCounterForName(String name) {
            return (Counter)this.findCounter(name);
        }

        private class FSCounterImpl
        extends FileSystemCounterGroup.FSCounter
        implements Counter {
            FSCounterImpl(String scheme, FileSystemCounter key) {
                super(FSGroupImpl.this, scheme, key);
            }

            @Override
            public String makeEscapedCompactString() {
                return CountersStrings.toEscapedCompactString(this);
            }

            @Override
            @Deprecated
            public boolean contentEquals(Counter counter) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public long getCounter() {
                return this.getValue();
            }
        }
    }

    private static class FrameworkGroupImpl<T extends Enum<T>>
    extends FrameworkCounterGroup<T, Counter>
    implements Group {
        FrameworkGroupImpl(Class<T> cls) {
            super(cls);
        }

        @Override
        public long getCounter(String counterName) {
            return Counters.getCounterValue(this, counterName);
        }

        @Override
        public String makeEscapedCompactString() {
            return CountersStrings.toEscapedCompactString(this);
        }

        @Override
        @Deprecated
        public Counter getCounter(int id, String name) {
            return (Counter)this.findCounter(name);
        }

        @Override
        public Counter getCounterForName(String name) {
            return (Counter)this.findCounter(name);
        }

        @Override
        protected Counter newCounter(T key) {
            return new FrameworkCounterImpl(this, key);
        }

        static class FrameworkCounterImpl
        extends FrameworkCounterGroup.FrameworkCounter
        implements Counter {
            final /* synthetic */ FrameworkGroupImpl this$0;

            FrameworkCounterImpl(T key) {
                this.this$0 = var1_1;
                super((FrameworkCounterGroup)var1_1, key);
            }

            @Override
            public String makeEscapedCompactString() {
                return CountersStrings.toEscapedCompactString(this);
            }

            @Override
            public boolean contentEquals(Counter counter) {
                return this.equals(counter);
            }

            @Override
            public long getCounter() {
                return this.getValue();
            }
        }
    }

    private static class GenericGroup
    extends AbstractCounterGroup<Counter>
    implements Group {
        GenericGroup(String name, String displayName, Limits limits) {
            super(name, displayName, limits);
        }

        @Override
        public long getCounter(String counterName) {
            return Counters.getCounterValue(this, counterName);
        }

        @Override
        public String makeEscapedCompactString() {
            return CountersStrings.toEscapedCompactString(this);
        }

        @Override
        public Counter getCounter(int id, String name) {
            return (Counter)this.findCounter(name);
        }

        @Override
        public Counter getCounterForName(String name) {
            return (Counter)this.findCounter(name);
        }

        @Override
        protected Counter newCounter(String counterName, String displayName, long value) {
            return new OldCounterImpl(counterName, displayName, value);
        }

        @Override
        protected Counter newCounter() {
            return new OldCounterImpl();
        }
    }

    public static interface Group
    extends CounterGroupBase<Counter> {
        public long getCounter(String var1);

        public String makeEscapedCompactString();

        @Deprecated
        public Counter getCounter(int var1, String var2);

        public Counter getCounterForName(String var1);
    }

    static class OldCounterImpl
    extends GenericCounter
    implements Counter {
        OldCounterImpl() {
        }

        OldCounterImpl(String name, String displayName, long value) {
            super(name, displayName, value);
        }

        @Override
        public synchronized String makeEscapedCompactString() {
            return CountersStrings.toEscapedCompactString(this);
        }

        @Override
        @Deprecated
        public boolean contentEquals(Counter counter) {
            return this.equals(counter);
        }

        @Override
        public long getCounter() {
            return this.getValue();
        }
    }

    public static interface Counter
    extends org.apache.hadoop.mapreduce.Counter {
        public String makeEscapedCompactString();

        @Deprecated
        public boolean contentEquals(Counter var1);

        public long getCounter();
    }
}

