/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.security.authorize.AccessControlList;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class JobStatus
extends org.apache.hadoop.mapreduce.JobStatus {
    public static final int RUNNING = JobStatus.State.RUNNING.getValue();
    public static final int SUCCEEDED = JobStatus.State.SUCCEEDED.getValue();
    public static final int FAILED = JobStatus.State.FAILED.getValue();
    public static final int PREP = JobStatus.State.PREP.getValue();
    public static final int KILLED = JobStatus.State.KILLED.getValue();
    private static final String UNKNOWN = "UNKNOWN";
    private static final String[] runStates = new String[]{"UNKNOWN", "RUNNING", "SUCCEEDED", "FAILED", "PREP", "KILLED"};

    public static String getJobRunState(int state) {
        if (state < 1 || state >= runStates.length) {
            return UNKNOWN;
        }
        return runStates[state];
    }

    static JobStatus.State getEnum(int state) {
        switch (state) {
            case 1: {
                return JobStatus.State.RUNNING;
            }
            case 2: {
                return JobStatus.State.SUCCEEDED;
            }
            case 3: {
                return JobStatus.State.FAILED;
            }
            case 4: {
                return JobStatus.State.PREP;
            }
            case 5: {
                return JobStatus.State.KILLED;
            }
        }
        return null;
    }

    public JobStatus() {
    }

    public JobStatus(JobID jobid, float mapProgress, float reduceProgress, float cleanupProgress, int runState, String user, String jobName, String jobFile, String trackingUrl) {
        this(jobid, mapProgress, reduceProgress, cleanupProgress, runState, JobPriority.NORMAL, user, jobName, jobFile, trackingUrl);
    }

    public JobStatus(JobID jobid, float mapProgress, float reduceProgress, int runState, String user, String jobName, String jobFile, String trackingUrl) {
        this(jobid, mapProgress, reduceProgress, 0.0f, runState, user, jobName, jobFile, trackingUrl);
    }

    public JobStatus(JobID jobid, float mapProgress, float reduceProgress, float cleanupProgress, int runState, JobPriority jp, String user, String jobName, String jobFile, String trackingUrl) {
        this(jobid, 0.0f, mapProgress, reduceProgress, cleanupProgress, runState, jp, user, jobName, jobFile, trackingUrl);
    }

    public JobStatus(JobID jobid, float setupProgress, float mapProgress, float reduceProgress, float cleanupProgress, int runState, JobPriority jp, String user, String jobName, String jobFile, String trackingUrl) {
        this(jobid, setupProgress, mapProgress, reduceProgress, cleanupProgress, runState, jp, user, jobName, "default", jobFile, trackingUrl);
    }

    public JobStatus(JobID jobid, float setupProgress, float mapProgress, float reduceProgress, float cleanupProgress, int runState, JobPriority jp, String user, String jobName, String queue, String jobFile, String trackingUrl) {
        super(jobid, setupProgress, mapProgress, reduceProgress, cleanupProgress, JobStatus.getEnum(runState), org.apache.hadoop.mapreduce.JobPriority.valueOf(jp.name()), user, jobName, queue, jobFile, trackingUrl);
    }

    public static JobStatus downgrade(org.apache.hadoop.mapreduce.JobStatus stat) {
        JobStatus old = new JobStatus(JobID.downgrade(stat.getJobID()), stat.getSetupProgress(), stat.getMapProgress(), stat.getReduceProgress(), stat.getCleanupProgress(), stat.getState().getValue(), JobPriority.valueOf(stat.getPriority().name()), stat.getUsername(), stat.getJobName(), stat.getJobFile(), stat.getTrackingUrl());
        old.setStartTime(stat.getStartTime());
        old.setFinishTime(stat.getFinishTime());
        old.setSchedulingInfo(stat.getSchedulingInfo());
        old.setHistoryFile(stat.getHistoryFile());
        return old;
    }

    @Deprecated
    public String getJobId() {
        return this.getJobID().toString();
    }

    @Override
    public JobID getJobID() {
        return JobID.downgrade(super.getJobID());
    }

    public synchronized JobPriority getJobPriority() {
        return JobPriority.valueOf(super.getPriority().name());
    }

    @Override
    protected synchronized void setMapProgress(float p) {
        super.setMapProgress(p);
    }

    @Override
    protected synchronized void setCleanupProgress(float p) {
        super.setCleanupProgress(p);
    }

    @Override
    protected synchronized void setSetupProgress(float p) {
        super.setSetupProgress(p);
    }

    @Override
    protected synchronized void setReduceProgress(float p) {
        super.setReduceProgress(p);
    }

    @Override
    protected synchronized void setFinishTime(long finishTime) {
        super.setFinishTime(finishTime);
    }

    @Override
    protected synchronized void setHistoryFile(String historyFile) {
        super.setHistoryFile(historyFile);
    }

    @Override
    protected synchronized void setTrackingUrl(String trackingUrl) {
        super.setTrackingUrl(trackingUrl);
    }

    @Override
    protected synchronized void setRetired() {
        super.setRetired();
    }

    protected synchronized void setRunState(int state) {
        super.setState(JobStatus.getEnum(state));
    }

    public synchronized int getRunState() {
        return super.getState().getValue();
    }

    @Override
    protected synchronized void setStartTime(long startTime) {
        super.setStartTime(startTime);
    }

    @Override
    protected synchronized void setUsername(String userName) {
        super.setUsername(userName);
    }

    @Override
    protected synchronized void setSchedulingInfo(String schedulingInfo) {
        super.setSchedulingInfo(schedulingInfo);
    }

    @Override
    protected synchronized void setJobACLs(Map<JobACL, AccessControlList> acls) {
        super.setJobACLs(acls);
    }

    @Override
    public synchronized void setFailureInfo(String failureInfo) {
        super.setFailureInfo(failureInfo);
    }

    public synchronized void setJobPriority(JobPriority jp) {
        super.setPriority(org.apache.hadoop.mapreduce.JobPriority.valueOf(jp.name()));
    }

    public synchronized float mapProgress() {
        return super.getMapProgress();
    }

    public synchronized float cleanupProgress() {
        return super.getCleanupProgress();
    }

    public synchronized float setupProgress() {
        return super.getSetupProgress();
    }

    public synchronized float reduceProgress() {
        return super.getReduceProgress();
    }

    static int getOldNewJobRunState(JobStatus.State state) {
        return state.getValue();
    }
}

