/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class MultipleOutputs {
    private static final String NAMED_OUTPUTS = "mo.namedOutputs";
    private static final String MO_PREFIX = "mo.namedOutput.";
    private static final String FORMAT = ".format";
    private static final String KEY = ".key";
    private static final String VALUE = ".value";
    private static final String MULTI = ".multi";
    private static final String COUNTERS_ENABLED = "mo.counters";
    private static final String COUNTERS_GROUP = MultipleOutputs.class.getName();
    private JobConf conf;
    private OutputFormat outputFormat;
    private Set<String> namedOutputs;
    private Map<String, RecordWriter> recordWriters;
    private boolean countersEnabled;

    private static void checkNamedOutput(JobConf conf, String namedOutput, boolean alreadyDefined) {
        List<String> definedChannels = MultipleOutputs.getNamedOutputsList(conf);
        if (alreadyDefined && definedChannels.contains(namedOutput)) {
            throw new IllegalArgumentException("Named output '" + namedOutput + "' already alreadyDefined");
        }
        if (!alreadyDefined && !definedChannels.contains(namedOutput)) {
            throw new IllegalArgumentException("Named output '" + namedOutput + "' not defined");
        }
    }

    private static void checkTokenName(String namedOutput) {
        if (namedOutput == null || namedOutput.length() == 0) {
            throw new IllegalArgumentException("Name cannot be NULL or emtpy");
        }
        for (char ch : namedOutput.toCharArray()) {
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') continue;
            throw new IllegalArgumentException("Name cannot be have a '" + ch + "' char");
        }
    }

    private static void checkNamedOutputName(String namedOutput) {
        MultipleOutputs.checkTokenName(namedOutput);
        if (namedOutput.equals("part")) {
            throw new IllegalArgumentException("Named output name cannot be 'part'");
        }
    }

    public static List<String> getNamedOutputsList(JobConf conf) {
        ArrayList<String> names = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(conf.get(NAMED_OUTPUTS, ""), " ");
        while (st.hasMoreTokens()) {
            names.add(st.nextToken());
        }
        return names;
    }

    public static boolean isMultiNamedOutput(JobConf conf, String namedOutput) {
        MultipleOutputs.checkNamedOutput(conf, namedOutput, false);
        return conf.getBoolean(MO_PREFIX + namedOutput + MULTI, false);
    }

    public static Class<? extends OutputFormat> getNamedOutputFormatClass(JobConf conf, String namedOutput) {
        MultipleOutputs.checkNamedOutput(conf, namedOutput, false);
        return conf.getClass(MO_PREFIX + namedOutput + FORMAT, null, OutputFormat.class);
    }

    public static Class<?> getNamedOutputKeyClass(JobConf conf, String namedOutput) {
        MultipleOutputs.checkNamedOutput(conf, namedOutput, false);
        return conf.getClass(MO_PREFIX + namedOutput + KEY, null, Object.class);
    }

    public static Class<?> getNamedOutputValueClass(JobConf conf, String namedOutput) {
        MultipleOutputs.checkNamedOutput(conf, namedOutput, false);
        return conf.getClass(MO_PREFIX + namedOutput + VALUE, null, Object.class);
    }

    public static void addNamedOutput(JobConf conf, String namedOutput, Class<? extends OutputFormat> outputFormatClass, Class<?> keyClass, Class<?> valueClass) {
        MultipleOutputs.addNamedOutput(conf, namedOutput, false, outputFormatClass, keyClass, valueClass);
    }

    public static void addMultiNamedOutput(JobConf conf, String namedOutput, Class<? extends OutputFormat> outputFormatClass, Class<?> keyClass, Class<?> valueClass) {
        MultipleOutputs.addNamedOutput(conf, namedOutput, true, outputFormatClass, keyClass, valueClass);
    }

    private static void addNamedOutput(JobConf conf, String namedOutput, boolean multi, Class<? extends OutputFormat> outputFormatClass, Class<?> keyClass, Class<?> valueClass) {
        MultipleOutputs.checkNamedOutputName(namedOutput);
        MultipleOutputs.checkNamedOutput(conf, namedOutput, true);
        conf.set(NAMED_OUTPUTS, conf.get(NAMED_OUTPUTS, "") + " " + namedOutput);
        conf.setClass(MO_PREFIX + namedOutput + FORMAT, outputFormatClass, OutputFormat.class);
        conf.setClass(MO_PREFIX + namedOutput + KEY, keyClass, Object.class);
        conf.setClass(MO_PREFIX + namedOutput + VALUE, valueClass, Object.class);
        conf.setBoolean(MO_PREFIX + namedOutput + MULTI, multi);
    }

    public static void setCountersEnabled(JobConf conf, boolean enabled) {
        conf.setBoolean(COUNTERS_ENABLED, enabled);
    }

    public static boolean getCountersEnabled(JobConf conf) {
        return conf.getBoolean(COUNTERS_ENABLED, false);
    }

    public MultipleOutputs(JobConf job) {
        this.conf = job;
        this.outputFormat = new InternalFileOutputFormat();
        this.namedOutputs = Collections.unmodifiableSet(new HashSet<String>(MultipleOutputs.getNamedOutputsList(job)));
        this.recordWriters = new HashMap<String, RecordWriter>();
        this.countersEnabled = MultipleOutputs.getCountersEnabled(job);
    }

    public Iterator<String> getNamedOutputs() {
        return this.namedOutputs.iterator();
    }

    private synchronized RecordWriter getRecordWriter(String namedOutput, String baseFileName, Reporter reporter) throws IOException {
        RecordWriterWithCounter writer = this.recordWriters.get(baseFileName);
        if (writer == null) {
            if (this.countersEnabled && reporter == null) {
                throw new IllegalArgumentException("Counters are enabled, Reporter cannot be NULL");
            }
            JobConf jobConf = new JobConf(this.conf);
            jobConf.set("mo.config.namedOutput", namedOutput);
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            writer = this.outputFormat.getRecordWriter(fs, jobConf, baseFileName, reporter);
            if (this.countersEnabled) {
                if (reporter == null) {
                    throw new IllegalArgumentException("Counters are enabled, Reporter cannot be NULL");
                }
                writer = new RecordWriterWithCounter(writer, baseFileName, reporter);
            }
            this.recordWriters.put(baseFileName, writer);
        }
        return writer;
    }

    public OutputCollector getCollector(String namedOutput, Reporter reporter) throws IOException {
        return this.getCollector(namedOutput, null, reporter);
    }

    public OutputCollector getCollector(String namedOutput, String multiName, Reporter reporter) throws IOException {
        MultipleOutputs.checkNamedOutputName(namedOutput);
        if (!this.namedOutputs.contains(namedOutput)) {
            throw new IllegalArgumentException("Undefined named output '" + namedOutput + "'");
        }
        boolean multi = MultipleOutputs.isMultiNamedOutput(this.conf, namedOutput);
        if (!multi && multiName != null) {
            throw new IllegalArgumentException("Name output '" + namedOutput + "' has not been defined as multi");
        }
        if (multi) {
            MultipleOutputs.checkTokenName(multiName);
        }
        String baseFileName = multi ? namedOutput + "_" + multiName : namedOutput;
        final RecordWriter writer = this.getRecordWriter(namedOutput, baseFileName, reporter);
        return new OutputCollector(){

            public void collect(Object key, Object value) throws IOException {
                writer.write(key, value);
            }
        };
    }

    public void close() throws IOException {
        for (RecordWriter writer : this.recordWriters.values()) {
            writer.close(null);
        }
    }

    private static class InternalFileOutputFormat
    extends FileOutputFormat<Object, Object> {
        public static final String CONFIG_NAMED_OUTPUT = "mo.config.namedOutput";

        private InternalFileOutputFormat() {
        }

        @Override
        public RecordWriter<Object, Object> getRecordWriter(FileSystem fs, JobConf job, String baseFileName, Progressable progress) throws IOException {
            String nameOutput = job.get(CONFIG_NAMED_OUTPUT, null);
            String fileName = InternalFileOutputFormat.getUniqueName(job, baseFileName);
            JobConf outputConf = new JobConf(job);
            outputConf.setOutputFormat(MultipleOutputs.getNamedOutputFormatClass(job, nameOutput));
            outputConf.setOutputKeyClass(MultipleOutputs.getNamedOutputKeyClass(job, nameOutput));
            outputConf.setOutputValueClass(MultipleOutputs.getNamedOutputValueClass(job, nameOutput));
            OutputFormat outputFormat = outputConf.getOutputFormat();
            return outputFormat.getRecordWriter(fs, outputConf, fileName, progress);
        }
    }

    private static class RecordWriterWithCounter
    implements RecordWriter {
        private RecordWriter writer;
        private String counterName;
        private Reporter reporter;

        public RecordWriterWithCounter(RecordWriter writer, String counterName, Reporter reporter) {
            this.writer = writer;
            this.counterName = counterName;
            this.reporter = reporter;
        }

        public void write(Object key, Object value) throws IOException {
            this.reporter.incrCounter(COUNTERS_GROUP, this.counterName, 1L);
            this.writer.write(key, value);
        }

        @Override
        public void close(Reporter reporter) throws IOException {
            this.writer.close(reporter);
        }
    }
}

