/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.JobSubmitter;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.util.ConfigUtil;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Job
extends JobContextImpl
implements JobContext {
    private static final Log LOG = LogFactory.getLog(Job.class);
    private static final long MAX_JOBSTATUS_AGE = 2000L;
    public static final String OUTPUT_FILTER = "mapreduce.client.output.filter";
    public static final String COMPLETION_POLL_INTERVAL_KEY = "mapreduce.client.completion.pollinterval";
    static final int DEFAULT_COMPLETION_POLL_INTERVAL = 5000;
    public static final String PROGRESS_MONITOR_POLL_INTERVAL_KEY = "mapreduce.client.progressmonitor.pollinterval";
    static final int DEFAULT_MONITOR_POLL_INTERVAL = 1000;
    public static final String USED_GENERIC_PARSER = "mapreduce.client.genericoptionsparser.used";
    public static final String SUBMIT_REPLICATION = "mapreduce.client.submit.file.replication";
    private static final String TASKLOG_PULL_TIMEOUT_KEY = "mapreduce.client.tasklog.timeout";
    private static final int DEFAULT_TASKLOG_TIMEOUT = 60000;
    private JobState state = JobState.DEFINE;
    private JobStatus status;
    private long statustime;
    private Cluster cluster = null;

    @Deprecated
    public Job() throws IOException {
        this(new Configuration());
    }

    @Deprecated
    public Job(Configuration conf) throws IOException {
        this(new JobConf(conf));
    }

    @Deprecated
    public Job(Configuration conf, String jobName) throws IOException {
        this(conf);
        this.setJobName(jobName);
    }

    Job(JobConf conf) throws IOException {
        super(conf, null);
    }

    Job(JobStatus status, JobConf conf) throws IOException {
        this(conf);
        this.setJobID(status.getJobID());
        this.status = status;
        this.state = JobState.RUNNING;
    }

    public static Job getInstance() throws IOException {
        return Job.getInstance(new Configuration());
    }

    public static Job getInstance(Configuration conf) throws IOException {
        JobConf jobConf = new JobConf(conf);
        return new Job(jobConf);
    }

    public static Job getInstance(Configuration conf, String jobName) throws IOException {
        Job result = Job.getInstance(conf);
        result.setJobName(jobName);
        return result;
    }

    public static Job getInstance(JobStatus status, Configuration conf) throws IOException {
        return new Job(status, new JobConf(conf));
    }

    @Deprecated
    public static Job getInstance(Cluster ignored) throws IOException {
        return Job.getInstance();
    }

    @Deprecated
    public static Job getInstance(Cluster ignored, Configuration conf) throws IOException {
        return Job.getInstance(conf);
    }

    @InterfaceAudience.Private
    public static Job getInstance(Cluster cluster, JobStatus status, Configuration conf) throws IOException {
        Job job = Job.getInstance(status, conf);
        job.setCluster(cluster);
        return job;
    }

    private void ensureState(JobState state) throws IllegalStateException {
        if (state != this.state) {
            throw new IllegalStateException("Job in state " + (Object)((Object)this.state) + " instead of " + (Object)((Object)state));
        }
        if (state == JobState.RUNNING && this.cluster == null) {
            throw new IllegalStateException("Job in state " + (Object)((Object)this.state) + ", but it isn't attached to any job tracker!");
        }
    }

    synchronized void ensureFreshStatus() throws IOException, InterruptedException {
        if (System.currentTimeMillis() - this.statustime > 2000L) {
            this.updateStatus();
        }
    }

    synchronized void updateStatus() throws IOException, InterruptedException {
        this.status = this.cluster.getClient().getJobStatus(this.status.getJobID());
        if (this.status == null) {
            throw new IOException("Job status not available ");
        }
        this.statustime = System.currentTimeMillis();
    }

    public JobStatus getStatus() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status;
    }

    private void setStatus(JobStatus status) {
        this.status = status;
    }

    public JobStatus.State getJobState() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.getState();
    }

    public String getTrackingURL() {
        this.ensureState(JobState.RUNNING);
        return this.status.getTrackingUrl().toString();
    }

    public String getJobFile() {
        this.ensureState(JobState.RUNNING);
        return this.status.getJobFile();
    }

    public long getStartTime() {
        this.ensureState(JobState.RUNNING);
        return this.status.getStartTime();
    }

    public long getFinishTime() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.getFinishTime();
    }

    public String getSchedulingInfo() {
        this.ensureState(JobState.RUNNING);
        return this.status.getSchedulingInfo();
    }

    public org.apache.hadoop.mapreduce.JobPriority getPriority() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.getPriority();
    }

    @Override
    public String getJobName() {
        if (this.state == JobState.DEFINE) {
            return super.getJobName();
        }
        this.ensureState(JobState.RUNNING);
        return this.status.getJobName();
    }

    public String getHistoryUrl() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.getHistoryFile();
    }

    public boolean isRetired() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.isRetired();
    }

    @InterfaceAudience.Private
    private void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public String toString() {
        this.ensureState(JobState.RUNNING);
        String reasonforFailure = " ";
        try {
            this.updateStatus();
            if (this.status.getState().equals((Object)JobStatus.State.FAILED)) {
                reasonforFailure = this.getTaskFailureEventString();
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Job: ").append(this.status.getJobID()).append("\n");
        sb.append("Job File: ").append(this.status.getJobFile()).append("\n");
        sb.append("Job Tracking URL : ").append(this.status.getTrackingUrl());
        sb.append("\n");
        sb.append("map() completion: ");
        sb.append(this.status.getMapProgress()).append("\n");
        sb.append("reduce() completion: ");
        sb.append(this.status.getReduceProgress()).append("\n");
        sb.append("Job state: ");
        sb.append((Object)this.status.getState()).append("\n");
        sb.append("retired: ").append(this.status.isRetired()).append("\n");
        sb.append("reason for failure: ").append(reasonforFailure);
        return sb.toString();
    }

    String getTaskFailureEventString() throws IOException, InterruptedException {
        int failCount = 1;
        TaskCompletionEvent lastEvent = null;
        for (TaskCompletionEvent event : this.cluster.getClient().getTaskCompletionEvents(this.status.getJobID(), 0, 10)) {
            if (!event.getStatus().equals((Object)TaskCompletionEvent.Status.FAILED)) continue;
            ++failCount;
            lastEvent = event;
        }
        String[] taskAttemptID = lastEvent.getTaskAttemptId().toString().split("_", 2);
        String taskID = taskAttemptID[1].substring(0, taskAttemptID[1].length() - 2);
        return " task " + taskID + " failed " + failCount + " times " + "For details check tasktracker at: " + lastEvent.getTaskTrackerHttp();
    }

    public TaskReport[] getTaskReports(TaskType type) throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        return this.cluster.getClient().getTaskReports(this.getJobID(), type);
    }

    public float mapProgress() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.ensureFreshStatus();
        return this.status.getMapProgress();
    }

    public float reduceProgress() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.ensureFreshStatus();
        return this.status.getReduceProgress();
    }

    public float cleanupProgress() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.ensureFreshStatus();
        return this.status.getCleanupProgress();
    }

    public float setupProgress() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.ensureFreshStatus();
        return this.status.getSetupProgress();
    }

    public boolean isComplete() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.isJobComplete();
    }

    public boolean isSuccessful() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.getState() == JobStatus.State.SUCCEEDED;
    }

    public void killJob() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.cluster.getClient().killJob(this.getJobID());
    }

    public void setPriority(org.apache.hadoop.mapreduce.JobPriority priority) throws IOException, InterruptedException {
        if (this.state == JobState.DEFINE) {
            this.conf.setJobPriority(JobPriority.valueOf(priority.name()));
        } else {
            this.ensureState(JobState.RUNNING);
            this.cluster.getClient().setJobPriority(this.getJobID(), priority.toString());
        }
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(int startFrom, int numEvents) throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        return this.cluster.getClient().getTaskCompletionEvents(this.getJobID(), startFrom, numEvents);
    }

    public boolean killTask(TaskAttemptID taskId) throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        return this.cluster.getClient().killTask(taskId, false);
    }

    public boolean failTask(TaskAttemptID taskId) throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        return this.cluster.getClient().killTask(taskId, true);
    }

    public Counters getCounters() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        return this.cluster.getClient().getJobCounters(this.getJobID());
    }

    public String[] getTaskDiagnostics(TaskAttemptID taskid) throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        return this.cluster.getClient().getTaskDiagnostics(taskid);
    }

    public void setNumReduceTasks(int tasks) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setNumReduceTasks(tasks);
    }

    public void setWorkingDirectory(Path dir) throws IOException {
        this.ensureState(JobState.DEFINE);
        this.conf.setWorkingDirectory(dir);
    }

    public void setInputFormatClass(Class<? extends InputFormat> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.job.inputformat.class", cls, InputFormat.class);
    }

    public void setOutputFormatClass(Class<? extends OutputFormat> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.job.outputformat.class", cls, OutputFormat.class);
    }

    public void setMapperClass(Class<? extends Mapper> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.job.map.class", cls, Mapper.class);
    }

    public void setJarByClass(Class<?> cls) {
        this.ensureState(JobState.DEFINE);
        this.conf.setJarByClass(cls);
    }

    public void setJar(String jar) {
        this.ensureState(JobState.DEFINE);
        this.conf.setJar(jar);
    }

    public void setUser(String user) {
        this.ensureState(JobState.DEFINE);
        this.conf.setUser(user);
    }

    public void setCombinerClass(Class<? extends Reducer> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.job.combine.class", cls, Reducer.class);
    }

    public void setReducerClass(Class<? extends Reducer> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.job.reduce.class", cls, Reducer.class);
    }

    public void setPartitionerClass(Class<? extends Partitioner> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.job.partitioner.class", cls, Partitioner.class);
    }

    public void setMapOutputKeyClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setMapOutputKeyClass(theClass);
    }

    public void setMapOutputValueClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setMapOutputValueClass(theClass);
    }

    public void setOutputKeyClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputKeyClass(theClass);
    }

    public void setOutputValueClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputValueClass(theClass);
    }

    public void setSortComparatorClass(Class<? extends RawComparator> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputKeyComparatorClass(cls);
    }

    public void setGroupingComparatorClass(Class<? extends RawComparator> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputValueGroupingComparator(cls);
    }

    public void setJobName(String name) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setJobName(name);
    }

    public void setSpeculativeExecution(boolean speculativeExecution) {
        this.ensureState(JobState.DEFINE);
        this.conf.setSpeculativeExecution(speculativeExecution);
    }

    public void setMapSpeculativeExecution(boolean speculativeExecution) {
        this.ensureState(JobState.DEFINE);
        this.conf.setMapSpeculativeExecution(speculativeExecution);
    }

    public void setReduceSpeculativeExecution(boolean speculativeExecution) {
        this.ensureState(JobState.DEFINE);
        this.conf.setReduceSpeculativeExecution(speculativeExecution);
    }

    public void setJobSetupCleanupNeeded(boolean needed) {
        this.ensureState(JobState.DEFINE);
        this.conf.setBoolean("mapreduce.job.committer.setup.cleanup.needed", needed);
    }

    public void setCacheArchives(URI[] archives) {
        this.ensureState(JobState.DEFINE);
        DistributedCache.setCacheArchives(archives, this.conf);
    }

    public void setCacheFiles(URI[] files) {
        this.ensureState(JobState.DEFINE);
        DistributedCache.setCacheFiles(files, this.conf);
    }

    public void addCacheArchive(URI uri) {
        this.ensureState(JobState.DEFINE);
        DistributedCache.addCacheArchive(uri, this.conf);
    }

    public void addCacheFile(URI uri) {
        this.ensureState(JobState.DEFINE);
        DistributedCache.addCacheFile(uri, this.conf);
    }

    public void addFileToClassPath(Path file) throws IOException {
        this.ensureState(JobState.DEFINE);
        DistributedCache.addFileToClassPath(file, this.conf);
    }

    public void addArchiveToClassPath(Path archive) throws IOException {
        this.ensureState(JobState.DEFINE);
        DistributedCache.addArchiveToClassPath(archive, this.conf);
    }

    public void createSymlink() {
        this.ensureState(JobState.DEFINE);
        DistributedCache.createSymlink(this.conf);
    }

    public void setMaxMapAttempts(int n) {
        this.ensureState(JobState.DEFINE);
        this.conf.setMaxMapAttempts(n);
    }

    public void setMaxReduceAttempts(int n) {
        this.ensureState(JobState.DEFINE);
        this.conf.setMaxReduceAttempts(n);
    }

    public void setProfileEnabled(boolean newValue) {
        this.ensureState(JobState.DEFINE);
        this.conf.setProfileEnabled(newValue);
    }

    public void setProfileParams(String value) {
        this.ensureState(JobState.DEFINE);
        this.conf.setProfileParams(value);
    }

    public void setProfileTaskRange(boolean isMap, String newValue) {
        this.ensureState(JobState.DEFINE);
        this.conf.setProfileTaskRange(isMap, newValue);
    }

    private void ensureNotSet(String attr, String msg) throws IOException {
        if (this.conf.get(attr) != null) {
            throw new IOException(attr + " is incompatible with " + msg + " mode.");
        }
    }

    public void setCancelDelegationTokenUponJobCompletion(boolean value) {
        this.ensureState(JobState.DEFINE);
        this.conf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", value);
    }

    private void setUseNewAPI() throws IOException {
        String mode;
        int numReduces = this.conf.getNumReduceTasks();
        String oldMapperClass = "mapred.mapper.class";
        String oldReduceClass = "mapred.reducer.class";
        this.conf.setBooleanIfUnset("mapred.mapper.new-api", this.conf.get(oldMapperClass) == null);
        if (this.conf.getUseNewMapper()) {
            mode = "new map API";
            this.ensureNotSet("mapred.input.format.class", mode);
            this.ensureNotSet(oldMapperClass, mode);
            if (numReduces != 0) {
                this.ensureNotSet("mapred.partitioner.class", mode);
            } else {
                this.ensureNotSet("mapred.output.format.class", mode);
            }
        } else {
            mode = "map compatability";
            this.ensureNotSet("mapreduce.job.inputformat.class", mode);
            this.ensureNotSet("mapreduce.job.map.class", mode);
            if (numReduces != 0) {
                this.ensureNotSet("mapreduce.job.partitioner.class", mode);
            } else {
                this.ensureNotSet("mapreduce.job.outputformat.class", mode);
            }
        }
        if (numReduces != 0) {
            this.conf.setBooleanIfUnset("mapred.reducer.new-api", this.conf.get(oldReduceClass) == null);
            if (this.conf.getUseNewReducer()) {
                mode = "new reduce API";
                this.ensureNotSet("mapred.output.format.class", mode);
                this.ensureNotSet(oldReduceClass, mode);
            } else {
                mode = "reduce compatability";
                this.ensureNotSet("mapreduce.job.outputformat.class", mode);
                this.ensureNotSet("mapreduce.job.reduce.class", mode);
            }
        }
    }

    private synchronized void connect() throws IOException, InterruptedException, ClassNotFoundException {
        if (this.cluster == null) {
            this.cluster = (Cluster)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Cluster>(){

                @Override
                public Cluster run() throws IOException, InterruptedException, ClassNotFoundException {
                    return new Cluster(Job.this.getConfiguration());
                }
            });
        }
    }

    boolean isConnected() {
        return this.cluster != null;
    }

    @InterfaceAudience.Private
    public JobSubmitter getJobSubmitter(FileSystem fs, ClientProtocol submitClient) throws IOException {
        return new JobSubmitter(fs, submitClient);
    }

    public void submit() throws IOException, InterruptedException, ClassNotFoundException {
        this.ensureState(JobState.DEFINE);
        this.setUseNewAPI();
        this.connect();
        final JobSubmitter submitter = this.getJobSubmitter(this.cluster.getFileSystem(), this.cluster.getClient());
        this.status = (JobStatus)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<JobStatus>(){

            @Override
            public JobStatus run() throws IOException, InterruptedException, ClassNotFoundException {
                return submitter.submitJobInternal(Job.this, Job.this.cluster);
            }
        });
        this.state = JobState.RUNNING;
    }

    public boolean waitForCompletion(boolean verbose) throws IOException, InterruptedException, ClassNotFoundException {
        if (this.state == JobState.DEFINE) {
            this.submit();
        }
        if (verbose) {
            this.monitorAndPrintJob();
        } else {
            int completionPollIntervalMillis = Job.getCompletionPollInterval(this.cluster.getConf());
            while (!this.isComplete()) {
                try {
                    Thread.sleep(completionPollIntervalMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.isSuccessful();
    }

    public boolean monitorAndPrintJob() throws IOException, InterruptedException {
        String lastReport = null;
        Configuration clientConf = this.getConfiguration();
        TaskStatusFilter filter = Job.getTaskOutputFilter(clientConf);
        JobID jobId = this.getJobID();
        LOG.info((Object)("Running job: " + jobId));
        int eventCounter = 0;
        boolean profiling = this.getProfileEnabled();
        Configuration.IntegerRanges mapRanges = this.getProfileTaskRange(true);
        Configuration.IntegerRanges reduceRanges = this.getProfileTaskRange(false);
        int progMonitorPollIntervalMillis = Job.getProgressPollInterval(clientConf);
        boolean reportedAfterCompletion = false;
        while (!this.isComplete() || !reportedAfterCompletion) {
            if (this.isComplete()) {
                reportedAfterCompletion = true;
            } else {
                Thread.sleep(progMonitorPollIntervalMillis);
            }
            String report = " map " + StringUtils.formatPercent((double)this.mapProgress(), (int)0) + " reduce " + StringUtils.formatPercent((double)this.reduceProgress(), (int)0);
            if (!report.equals(lastReport)) {
                LOG.info((Object)report);
                lastReport = report;
            }
            TaskCompletionEvent[] events = this.getTaskCompletionEvents(eventCounter, 10);
            eventCounter += events.length;
            this.printTaskEvents(events, filter, profiling, mapRanges, reduceRanges);
        }
        boolean success = this.isSuccessful();
        if (success) {
            LOG.info((Object)("Job " + jobId + " completed successfully"));
        } else {
            LOG.info((Object)("Job " + jobId + " failed with state " + (Object)((Object)this.status.getState()) + " due to: " + this.status.getFailureInfo()));
        }
        Counters counters = this.getCounters();
        if (counters != null) {
            LOG.info((Object)counters.toString());
        }
        return success;
    }

    private boolean shouldDownloadProfile() {
        String profileParams = this.getProfileParams();
        if (null == profileParams) {
            return false;
        }
        String[] parts = profileParams.split("[ \\t]+");
        boolean hprofFound = false;
        boolean fileFound = false;
        for (String p : parts) {
            String[] subparts;
            if (!p.startsWith("-agentlib:hprof") && !p.startsWith("-Xrunhprof")) continue;
            hprofFound = true;
            for (String sub : subparts = p.split(",")) {
                if (!sub.startsWith("file=") || sub.length() == "file=".length()) continue;
                fileFound = true;
            }
        }
        return hprofFound && fileFound;
    }

    private void printTaskEvents(TaskCompletionEvent[] events, TaskStatusFilter filter, boolean profiling, Configuration.IntegerRanges mapRanges, Configuration.IntegerRanges reduceRanges) throws IOException, InterruptedException {
        block7: for (TaskCompletionEvent event : events) {
            TaskCompletionEvent.Status status = event.getStatus();
            if (profiling && this.shouldDownloadProfile() && (status == TaskCompletionEvent.Status.SUCCEEDED || status == TaskCompletionEvent.Status.FAILED) && (event.isMapTask() ? mapRanges : reduceRanges).isIncluded(event.idWithinJob())) {
                this.downloadProfile(event);
            }
            switch (filter) {
                case NONE: {
                    continue block7;
                }
                case SUCCEEDED: {
                    if (event.getStatus() != TaskCompletionEvent.Status.SUCCEEDED) continue block7;
                    LOG.info((Object)event.toString());
                    this.displayTaskLogs(event.getTaskAttemptId(), event.getTaskTrackerHttp());
                    continue block7;
                }
                case FAILED: {
                    if (event.getStatus() != TaskCompletionEvent.Status.FAILED) continue block7;
                    LOG.info((Object)event.toString());
                    TaskAttemptID taskId = event.getTaskAttemptId();
                    String[] taskDiagnostics = this.getTaskDiagnostics(taskId);
                    if (taskDiagnostics != null) {
                        for (String diagnostics : taskDiagnostics) {
                            System.err.println(diagnostics);
                        }
                    }
                    this.displayTaskLogs(event.getTaskAttemptId(), event.getTaskTrackerHttp());
                    continue block7;
                }
                case KILLED: {
                    if (event.getStatus() != TaskCompletionEvent.Status.KILLED) continue block7;
                    LOG.info((Object)event.toString());
                    continue block7;
                }
                case ALL: {
                    LOG.info((Object)event.toString());
                    this.displayTaskLogs(event.getTaskAttemptId(), event.getTaskTrackerHttp());
                }
            }
        }
    }

    private void downloadProfile(TaskCompletionEvent e) throws IOException {
        URLConnection connection = new URL(this.getTaskLogURL(e.getTaskAttemptId(), e.getTaskTrackerHttp()) + "&filter=profile").openConnection();
        InputStream in = connection.getInputStream();
        FileOutputStream out = new FileOutputStream(e.getTaskAttemptId() + ".profile");
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)65536, (boolean)true);
    }

    private void displayTaskLogs(TaskAttemptID taskId, String baseUrl) throws IOException {
        if (baseUrl != null) {
            String taskLogUrl = this.getTaskLogURL(taskId, baseUrl);
            this.getTaskLogs(taskId, new URL(taskLogUrl + "&filter=stdout"), System.out);
            this.getTaskLogs(taskId, new URL(taskLogUrl + "&filter=stderr"), System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTaskLogs(TaskAttemptID taskId, URL taskLogUrl, OutputStream out) {
        try {
            int tasklogtimeout = this.cluster.getConf().getInt(TASKLOG_PULL_TIMEOUT_KEY, 60000);
            URLConnection connection = taskLogUrl.openConnection();
            connection.setReadTimeout(tasklogtimeout);
            connection.setConnectTimeout(tasklogtimeout);
            BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            BufferedWriter output = new BufferedWriter(new OutputStreamWriter(out));
            try {
                String logData = null;
                while ((logData = input.readLine()) != null) {
                    if (logData.length() <= 0) continue;
                    output.write(taskId + ": " + logData + "\n");
                    output.flush();
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error reading task output " + ioe.getMessage()));
        }
    }

    private String getTaskLogURL(TaskAttemptID taskId, String baseUrl) {
        return baseUrl + "/tasklog?plaintext=true&attemptid=" + taskId;
    }

    public static int getProgressPollInterval(Configuration conf) {
        int progMonitorPollIntervalMillis = conf.getInt(PROGRESS_MONITOR_POLL_INTERVAL_KEY, 1000);
        if (progMonitorPollIntervalMillis < 1) {
            LOG.warn((Object)"mapreduce.client.progressmonitor.pollinterval has been set to an invalid value;  replacing with 1000");
            progMonitorPollIntervalMillis = 1000;
        }
        return progMonitorPollIntervalMillis;
    }

    public static int getCompletionPollInterval(Configuration conf) {
        int completionPollIntervalMillis = conf.getInt(COMPLETION_POLL_INTERVAL_KEY, 5000);
        if (completionPollIntervalMillis < 1) {
            LOG.warn((Object)"mapreduce.client.completion.pollinterval has been set to an invalid value; replacing with 5000");
            completionPollIntervalMillis = 5000;
        }
        return completionPollIntervalMillis;
    }

    public static TaskStatusFilter getTaskOutputFilter(Configuration conf) {
        return TaskStatusFilter.valueOf(conf.get(OUTPUT_FILTER, "FAILED"));
    }

    public static void setTaskOutputFilter(Configuration conf, TaskStatusFilter newValue) {
        conf.set(OUTPUT_FILTER, newValue.toString());
    }

    static {
        ConfigUtil.loadResources();
    }

    @InterfaceStability.Evolving
    public static enum TaskStatusFilter {
        NONE,
        KILLED,
        FAILED,
        SUCCEEDED,
        ALL;

    }

    @InterfaceStability.Evolving
    public static enum JobState {
        DEFINE,
        RUNNING;

    }
}

