/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.ProgressSplitsBlock;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.AvroArrayUtils;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinished;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MapAttemptFinishedEvent
implements HistoryEvent {
    private MapAttemptFinished datum = new MapAttemptFinished();

    public MapAttemptFinishedEvent(TaskAttemptID id, TaskType taskType, String taskStatus, long mapFinishTime, long finishTime, String hostname, String rackName, String state, Counters counters, int[][] allSplits) {
        this.datum.taskid = new Utf8(id.getTaskID().toString());
        this.datum.attemptId = new Utf8(id.toString());
        this.datum.taskType = new Utf8(taskType.name());
        this.datum.taskStatus = new Utf8(taskStatus);
        this.datum.mapFinishTime = mapFinishTime;
        this.datum.finishTime = finishTime;
        this.datum.hostname = new Utf8(hostname);
        this.datum.rackname = new Utf8(rackName);
        this.datum.state = new Utf8(state);
        this.datum.counters = EventWriter.toAvro(counters);
        this.datum.clockSplits = AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetWallclockTime(allSplits));
        this.datum.cpuUsages = AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetCPUTime(allSplits));
        this.datum.vMemKbytes = AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetVMemKbytes(allSplits));
        this.datum.physMemKbytes = AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetPhysMemKbytes(allSplits));
    }

    @Deprecated
    public MapAttemptFinishedEvent(TaskAttemptID id, TaskType taskType, String taskStatus, long mapFinishTime, long finishTime, String hostname, String state, Counters counters) {
        this(id, taskType, taskStatus, mapFinishTime, finishTime, hostname, "", state, counters, null);
    }

    MapAttemptFinishedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (MapAttemptFinished)((Object)datum);
    }

    public TaskID getTaskId() {
        return TaskID.forName(((Object)this.datum.taskid).toString());
    }

    public TaskAttemptID getAttemptId() {
        return TaskAttemptID.forName(((Object)this.datum.attemptId).toString());
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(((Object)this.datum.taskType).toString());
    }

    public String getTaskStatus() {
        return ((Object)this.datum.taskStatus).toString();
    }

    public long getMapFinishTime() {
        return this.datum.mapFinishTime;
    }

    public long getFinishTime() {
        return this.datum.finishTime;
    }

    public String getHostname() {
        return ((Object)this.datum.hostname).toString();
    }

    public String getRackname() {
        return ((Object)this.datum.rackname).toString();
    }

    public String getState() {
        return ((Object)this.datum.state).toString();
    }

    Counters getCounters() {
        return EventReader.fromAvro(this.datum.counters);
    }

    @Override
    public EventType getEventType() {
        return EventType.MAP_ATTEMPT_FINISHED;
    }

    public int[] getClockSplits() {
        return AvroArrayUtils.fromAvro(this.datum.clockSplits);
    }

    public int[] getCpuUsages() {
        return AvroArrayUtils.fromAvro(this.datum.cpuUsages);
    }

    public int[] getVMemKbytes() {
        return AvroArrayUtils.fromAvro(this.datum.vMemKbytes);
    }

    public int[] getPhysMemKbytes() {
        return AvroArrayUtils.fromAvro(this.datum.physMemKbytes);
    }
}

