/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TokenCache {
    private static final Log LOG = LogFactory.getLog(TokenCache.class);
    @InterfaceAudience.Private
    public static final String JOB_TOKEN_HDFS_FILE = "jobToken";
    @InterfaceAudience.Private
    public static final String JOB_TOKENS_FILENAME = "mapreduce.job.jobTokenFile";
    private static final Text JOB_TOKEN = new Text("ShuffleAndJobToken");

    public static byte[] getSecretKey(Credentials credentials, Text alias) {
        if (credentials == null) {
            return null;
        }
        return credentials.getSecretKey(alias);
    }

    public static void obtainTokensForNamenodes(Credentials credentials, Path[] ps, Configuration conf) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        TokenCache.obtainTokensForNamenodesInternal(credentials, ps, conf);
    }

    public static void cleanUpTokenReferral(Configuration conf) {
        conf.unset("mapreduce.job.credentials.binary");
    }

    static void obtainTokensForNamenodesInternal(Credentials credentials, Path[] ps, Configuration conf) throws IOException {
        for (Path p : ps) {
            FileSystem fs = FileSystem.get((URI)p.toUri(), (Configuration)conf);
            TokenCache.obtainTokensForNamenodesInternal(fs, credentials, conf);
        }
    }

    static void obtainTokensForNamenodesInternal(FileSystem fs, Credentials credentials, Configuration conf) throws IOException {
        String delegTokenRenewer = Master.getMasterPrincipal(conf);
        if (delegTokenRenewer == null || delegTokenRenewer.length() == 0) {
            throw new IOException("Can't get Master Kerberos principal for use as renewer");
        }
        TokenCache.mergeBinaryTokens(credentials, conf);
        String fsName = fs.getCanonicalServiceName();
        if (TokenCache.getDelegationToken(credentials, fsName) == null) {
            Token token;
            List tokens = fs.getDelegationTokens(delegTokenRenewer, credentials);
            if (tokens != null) {
                for (Token token2 : tokens) {
                    credentials.addToken(token2.getService(), token2);
                    LOG.info((Object)("Got dt for " + fs.getUri() + ";uri=" + fsName + ";t.service=" + token2.getService()));
                }
            }
            if ((tokens == null || tokens.size() == 0) && (token = fs.getDelegationToken(delegTokenRenewer)) != null) {
                credentials.addToken(token.getService(), token);
                LOG.info((Object)("Got dt for " + fs.getUri() + ";uri=" + fsName + ";t.service=" + token.getService()));
            }
        }
    }

    private static void mergeBinaryTokens(Credentials creds, Configuration conf) {
        String binaryTokenFilename = conf.get("mapreduce.job.credentials.binary");
        if (binaryTokenFilename != null) {
            Credentials binary;
            try {
                binary = Credentials.readTokenStorageFile((Path)new Path("file:///" + binaryTokenFilename), (Configuration)conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            creds.mergeAll(binary);
        }
    }

    @InterfaceAudience.Private
    public static Token<DelegationTokenIdentifier> getDelegationToken(Credentials credentials, String namenode) {
        if (namenode == null) {
            return null;
        }
        return credentials.getToken(new Text(namenode));
    }

    @InterfaceAudience.Private
    public static Credentials loadTokens(String jobTokenFile, JobConf conf) throws IOException {
        Path localJobTokenFile = new Path("file:///" + jobTokenFile);
        Credentials ts = Credentials.readTokenStorageFile((Path)localJobTokenFile, (Configuration)conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Task: Loaded jobTokenFile from: " + localJobTokenFile.toUri().getPath() + "; num of sec keys  = " + ts.numberOfSecretKeys() + " Number of tokens " + ts.numberOfTokens()));
        }
        return ts;
    }

    @InterfaceAudience.Private
    public static void setJobToken(Token<? extends TokenIdentifier> t, Credentials credentials) {
        credentials.addToken(JOB_TOKEN, t);
    }

    @InterfaceAudience.Private
    public static Token<JobTokenIdentifier> getJobToken(Credentials credentials) {
        return credentials.getToken(JOB_TOKEN);
    }
}

