/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.net.NodeBase;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class CombineFileInputFormat<K, V>
extends FileInputFormat<K, V> {
    public static final String SPLIT_MINSIZE_PERNODE = "mapreduce.input.fileinputformat.split.minsize.per.node";
    public static final String SPLIT_MINSIZE_PERRACK = "mapreduce.input.fileinputformat.split.minsize.per.rack";
    private long maxSplitSize = 0L;
    private long minSplitSizeNode = 0L;
    private long minSplitSizeRack = 0L;
    private ArrayList<MultiPathFilter> pools = new ArrayList();
    private HashMap<String, Set<String>> rackToNodes = new HashMap();

    protected void setMaxSplitSize(long maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
    }

    protected void setMinSplitSizeNode(long minSplitSizeNode) {
        this.minSplitSizeNode = minSplitSizeNode;
    }

    protected void setMinSplitSizeRack(long minSplitSizeRack) {
        this.minSplitSizeRack = minSplitSizeRack;
    }

    protected void createPool(List<PathFilter> filters) {
        this.pools.add(new MultiPathFilter(filters));
    }

    protected void createPool(PathFilter ... filters) {
        MultiPathFilter multi = new MultiPathFilter();
        for (PathFilter f : filters) {
            multi.add(f);
        }
        this.pools.add(multi);
    }

    @Override
    protected boolean isSplitable(JobContext context, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        if (null == codec) {
            return true;
        }
        return codec instanceof SplittableCompressionCodec;
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        long minSizeNode = 0L;
        long minSizeRack = 0L;
        long maxSize = 0L;
        Configuration conf = job.getConfiguration();
        minSizeNode = this.minSplitSizeNode != 0L ? this.minSplitSizeNode : conf.getLong(SPLIT_MINSIZE_PERNODE, 0L);
        minSizeRack = this.minSplitSizeRack != 0L ? this.minSplitSizeRack : conf.getLong(SPLIT_MINSIZE_PERRACK, 0L);
        maxSize = this.maxSplitSize != 0L ? this.maxSplitSize : conf.getLong("mapreduce.input.fileinputformat.split.maxsize", 0L);
        if (minSizeNode != 0L && maxSize != 0L && minSizeNode > maxSize) {
            throw new IOException("Minimum split size pernode " + minSizeNode + " cannot be larger than maximum split size " + maxSize);
        }
        if (minSizeRack != 0L && maxSize != 0L && minSizeRack > maxSize) {
            throw new IOException("Minimum split size per rack" + minSizeRack + " cannot be larger than maximum split size " + maxSize);
        }
        if (minSizeRack != 0L && minSizeNode > minSizeRack) {
            throw new IOException("Minimum split size per node" + minSizeNode + " cannot be smaller than minimum split " + "size per rack " + minSizeRack);
        }
        Path[] paths = FileUtil.stat2Paths((FileStatus[])this.listStatus(job).toArray(new FileStatus[0]));
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (paths.length == 0) {
            return splits;
        }
        LinkedList<Path> newpaths = new LinkedList<Path>();
        for (int i = 0; i < paths.length; ++i) {
            Path p = new Path(paths[i].toUri().getPath());
            newpaths.add(p);
        }
        paths = null;
        for (MultiPathFilter onepool : this.pools) {
            ArrayList<Path> myPaths = new ArrayList<Path>();
            Iterator iter = newpaths.iterator();
            while (iter.hasNext()) {
                Path p = (Path)iter.next();
                if (!onepool.accept(p)) continue;
                myPaths.add(p);
                iter.remove();
            }
            this.getMoreSplits(job, myPaths.toArray(new Path[myPaths.size()]), maxSize, minSizeNode, minSizeRack, splits);
        }
        this.getMoreSplits(job, newpaths.toArray(new Path[newpaths.size()]), maxSize, minSizeNode, minSizeRack, splits);
        this.rackToNodes.clear();
        return splits;
    }

    private void getMoreSplits(JobContext job, Path[] paths, long maxSize, long minSizeNode, long minSizeRack, List<InputSplit> splits) throws IOException {
        Configuration conf = job.getConfiguration();
        HashMap<String, List<OneBlockInfo>> rackToBlocks = new HashMap<String, List<OneBlockInfo>>();
        HashMap<OneBlockInfo, String[]> blockToNodes = new HashMap<OneBlockInfo, String[]>();
        HashMap<String, List<OneBlockInfo>> nodeToBlocks = new HashMap<String, List<OneBlockInfo>>();
        OneFileInfo[] files = new OneFileInfo[paths.length];
        if (paths.length == 0) {
            return;
        }
        long totLength = 0L;
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new OneFileInfo(paths[i], conf, this.isSplitable(job, paths[i]), rackToBlocks, blockToNodes, nodeToBlocks, this.rackToNodes, maxSize);
            totLength += files[i].getLength();
        }
        ArrayList<OneBlockInfo> validBlocks = new ArrayList<OneBlockInfo>();
        HashSet<String> nodes = new HashSet<String>();
        long curSplitSize = 0L;
        for (Map.Entry one : nodeToBlocks.entrySet()) {
            nodes.add((String)one.getKey());
            List blocksInNode = (List)one.getValue();
            for (OneBlockInfo oneblock : blocksInNode) {
                if (!blockToNodes.containsKey(oneblock)) continue;
                validBlocks.add(oneblock);
                blockToNodes.remove(oneblock);
                if (maxSize == 0L || (curSplitSize += oneblock.length) < maxSize) continue;
                this.addCreatedSplit(splits, nodes, validBlocks);
                curSplitSize = 0L;
                validBlocks.clear();
            }
            if (minSizeNode != 0L && curSplitSize >= minSizeNode) {
                this.addCreatedSplit(splits, nodes, validBlocks);
            } else {
                for (OneBlockInfo oneblock : validBlocks) {
                    blockToNodes.put(oneblock, oneblock.hosts);
                }
            }
            validBlocks.clear();
            nodes.clear();
            curSplitSize = 0L;
        }
        ArrayList<OneBlockInfo> overflowBlocks = new ArrayList<OneBlockInfo>();
        HashSet<String> racks = new HashSet<String>();
        while (blockToNodes.size() > 0) {
            for (Map.Entry<String, List<OneBlockInfo>> one : rackToBlocks.entrySet()) {
                racks.add(one.getKey());
                List<OneBlockInfo> blocks = one.getValue();
                boolean createdSplit = false;
                for (OneBlockInfo oneblock : blocks) {
                    if (!blockToNodes.containsKey(oneblock)) continue;
                    validBlocks.add(oneblock);
                    blockToNodes.remove(oneblock);
                    if (maxSize == 0L || (curSplitSize += oneblock.length) < maxSize) continue;
                    this.addCreatedSplit(splits, this.getHosts(racks), validBlocks);
                    createdSplit = true;
                    break;
                }
                if (createdSplit) {
                    curSplitSize = 0L;
                    validBlocks.clear();
                    racks.clear();
                    continue;
                }
                if (!validBlocks.isEmpty()) {
                    if (minSizeRack != 0L && curSplitSize >= minSizeRack) {
                        this.addCreatedSplit(splits, this.getHosts(racks), validBlocks);
                    } else {
                        overflowBlocks.addAll(validBlocks);
                    }
                }
                curSplitSize = 0L;
                validBlocks.clear();
                racks.clear();
            }
        }
        assert (blockToNodes.isEmpty());
        assert (curSplitSize == 0L);
        assert (validBlocks.isEmpty());
        assert (racks.isEmpty());
        for (OneBlockInfo oneblock : overflowBlocks) {
            validBlocks.add(oneblock);
            curSplitSize += oneblock.length;
            for (int i = 0; i < oneblock.racks.length; ++i) {
                racks.add(oneblock.racks[i]);
            }
            if (maxSize == 0L || curSplitSize < maxSize) continue;
            this.addCreatedSplit(splits, this.getHosts(racks), validBlocks);
            curSplitSize = 0L;
            validBlocks.clear();
            racks.clear();
        }
        if (!validBlocks.isEmpty()) {
            this.addCreatedSplit(splits, this.getHosts(racks), validBlocks);
        }
    }

    private void addCreatedSplit(List<InputSplit> splitList, Collection<String> locations, ArrayList<OneBlockInfo> validBlocks) {
        Path[] fl = new Path[validBlocks.size()];
        long[] offset = new long[validBlocks.size()];
        long[] length = new long[validBlocks.size()];
        for (int i = 0; i < validBlocks.size(); ++i) {
            fl[i] = validBlocks.get((int)i).onepath;
            offset[i] = validBlocks.get((int)i).offset;
            length[i] = validBlocks.get((int)i).length;
        }
        CombineFileSplit thissplit = new CombineFileSplit(fl, offset, length, locations.toArray(new String[0]));
        splitList.add(thissplit);
    }

    @Override
    public abstract RecordReader<K, V> createRecordReader(InputSplit var1, TaskAttemptContext var2) throws IOException;

    protected BlockLocation[] getFileBlockLocations(FileSystem fs, FileStatus stat) throws IOException {
        return fs.getFileBlockLocations(stat, 0L, stat.getLen());
    }

    private static void addHostToRack(HashMap<String, Set<String>> rackToNodes, String rack, String host) {
        Set<String> hosts = rackToNodes.get(rack);
        if (hosts == null) {
            hosts = new HashSet<String>();
            rackToNodes.put(rack, hosts);
        }
        hosts.add(host);
    }

    private Set<String> getHosts(Set<String> racks) {
        HashSet<String> hosts = new HashSet<String>();
        for (String rack : racks) {
            if (!this.rackToNodes.containsKey(rack)) continue;
            hosts.addAll((Collection<String>)this.rackToNodes.get(rack));
        }
        return hosts;
    }

    private static class MultiPathFilter
    implements PathFilter {
        private List<PathFilter> filters;

        public MultiPathFilter() {
            this.filters = new ArrayList<PathFilter>();
        }

        public MultiPathFilter(List<PathFilter> filters) {
            this.filters = filters;
        }

        public void add(PathFilter one) {
            this.filters.add(one);
        }

        public boolean accept(Path path) {
            for (PathFilter filter : this.filters) {
                if (!filter.accept(path)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            for (PathFilter f : this.filters) {
                buf.append(f);
                buf.append(",");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    private static class OneBlockInfo {
        Path onepath;
        long offset;
        long length;
        String[] hosts;
        String[] racks;

        OneBlockInfo(Path path, long offset, long len, String[] hosts, String[] topologyPaths) {
            int i;
            this.onepath = path;
            this.offset = offset;
            this.hosts = hosts;
            this.length = len;
            assert (hosts.length == topologyPaths.length || topologyPaths.length == 0);
            if (topologyPaths.length == 0) {
                topologyPaths = new String[hosts.length];
                for (i = 0; i < topologyPaths.length; ++i) {
                    topologyPaths[i] = new NodeBase(hosts[i], "/default-rack").toString();
                }
            }
            this.racks = new String[topologyPaths.length];
            for (i = 0; i < topologyPaths.length; ++i) {
                this.racks[i] = new NodeBase(topologyPaths[i]).getNetworkLocation();
            }
        }
    }

    private static class OneFileInfo {
        private long fileSize = 0L;
        private OneBlockInfo[] blocks;

        OneFileInfo(Path path, Configuration conf, boolean isSplitable, HashMap<String, List<OneBlockInfo>> rackToBlocks, HashMap<OneBlockInfo, String[]> blockToNodes, HashMap<String, List<OneBlockInfo>> nodeToBlocks, HashMap<String, Set<String>> rackToNodes, long maxSize) throws IOException {
            FileSystem fs = path.getFileSystem(conf);
            FileStatus stat = fs.getFileStatus(path);
            BlockLocation[] locations = fs.getFileBlockLocations(stat, 0L, stat.getLen());
            if (locations == null) {
                this.blocks = new OneBlockInfo[0];
            } else {
                if (!isSplitable) {
                    this.blocks = new OneBlockInfo[1];
                    this.fileSize = stat.getLen();
                    this.blocks[0] = new OneBlockInfo(path, 0L, this.fileSize, locations[0].getHosts(), locations[0].getTopologyPaths());
                } else {
                    ArrayList<OneBlockInfo> blocksList = new ArrayList<OneBlockInfo>(locations.length);
                    for (int i = 0; i < locations.length; ++i) {
                        this.fileSize += locations[i].getLength();
                        long left = locations[i].getLength();
                        long myOffset = locations[i].getOffset();
                        long myLength = 0L;
                        do {
                            myLength = maxSize == 0L ? left : (left > maxSize && left < 2L * maxSize ? left / 2L : Math.min(maxSize, left));
                            OneBlockInfo oneblock = new OneBlockInfo(path, myOffset, myLength, locations[i].getHosts(), locations[i].getTopologyPaths());
                            myOffset += myLength;
                            blocksList.add(oneblock);
                        } while ((left -= myLength) > 0L);
                    }
                    this.blocks = blocksList.toArray(new OneBlockInfo[blocksList.size()]);
                }
                for (OneBlockInfo oneblock : this.blocks) {
                    List<OneBlockInfo> blklist;
                    int j;
                    blockToNodes.put(oneblock, oneblock.hosts);
                    String[] racks = null;
                    racks = oneblock.hosts.length == 0 ? new String[]{"/default-rack"} : oneblock.racks;
                    for (j = 0; j < racks.length; ++j) {
                        String rack = racks[j];
                        blklist = rackToBlocks.get(rack);
                        if (blklist == null) {
                            blklist = new ArrayList<OneBlockInfo>();
                            rackToBlocks.put(rack, blklist);
                        }
                        blklist.add(oneblock);
                        if (racks[j].equals("/default-rack")) continue;
                        CombineFileInputFormat.addHostToRack(rackToNodes, racks[j], oneblock.hosts[j]);
                    }
                    for (j = 0; j < oneblock.hosts.length; ++j) {
                        String node = oneblock.hosts[j];
                        blklist = nodeToBlocks.get(node);
                        if (blklist == null) {
                            blklist = new ArrayList<OneBlockInfo>();
                            nodeToBlocks.put(node, blklist);
                        }
                        blklist.add(oneblock);
                    }
                }
            }
        }

        long getLength() {
            return this.fileSize;
        }

        OneBlockInfo[] getBlocks() {
            return this.blocks;
        }
    }
}

