/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.filecache;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;

@InterfaceAudience.Private
public class ClientDistributedCacheManager {
    public static void determineTimestamps(Configuration job) throws IOException {
        URI[] tfiles;
        URI[] tarchives = DistributedCache.getCacheArchives(job);
        if (tarchives != null) {
            FileStatus status = ClientDistributedCacheManager.getFileStatus(job, tarchives[0]);
            StringBuilder archiveFileSizes = new StringBuilder(String.valueOf(status.getLen()));
            StringBuilder archiveTimestamps = new StringBuilder(String.valueOf(status.getModificationTime()));
            for (int i = 1; i < tarchives.length; ++i) {
                status = ClientDistributedCacheManager.getFileStatus(job, tarchives[i]);
                archiveFileSizes.append(",");
                archiveFileSizes.append(String.valueOf(status.getLen()));
                archiveTimestamps.append(",");
                archiveTimestamps.append(String.valueOf(status.getModificationTime()));
            }
            job.set("mapreduce.job.cache.archives.filesizes", archiveFileSizes.toString());
            ClientDistributedCacheManager.setArchiveTimestamps(job, archiveTimestamps.toString());
        }
        if ((tfiles = DistributedCache.getCacheFiles(job)) != null) {
            FileStatus status = ClientDistributedCacheManager.getFileStatus(job, tfiles[0]);
            StringBuilder fileSizes = new StringBuilder(String.valueOf(status.getLen()));
            StringBuilder fileTimestamps = new StringBuilder(String.valueOf(status.getModificationTime()));
            for (int i = 1; i < tfiles.length; ++i) {
                status = ClientDistributedCacheManager.getFileStatus(job, tfiles[i]);
                fileSizes.append(",");
                fileSizes.append(String.valueOf(status.getLen()));
                fileTimestamps.append(",");
                fileTimestamps.append(String.valueOf(status.getModificationTime()));
            }
            job.set("mapreduce.job.cache.files.filesizes", fileSizes.toString());
            ClientDistributedCacheManager.setFileTimestamps(job, fileTimestamps.toString());
        }
    }

    public static void getDelegationTokens(Configuration job, Credentials credentials) throws IOException {
        URI[] tarchives = DistributedCache.getCacheArchives(job);
        URI[] tfiles = DistributedCache.getCacheFiles(job);
        int size = (tarchives != null ? tarchives.length : 0) + (tfiles != null ? tfiles.length : 0);
        Path[] ps = new Path[size];
        int i = 0;
        if (tarchives != null) {
            for (i = 0; i < tarchives.length; ++i) {
                ps[i] = new Path(tarchives[i].toString());
            }
        }
        if (tfiles != null) {
            for (int j = 0; j < tfiles.length; ++j) {
                ps[i + j] = new Path(tfiles[j].toString());
            }
        }
        TokenCache.obtainTokensForNamenodes(credentials, ps, job);
    }

    public static void determineCacheVisibilities(Configuration job) throws IOException {
        URI[] tfiles;
        URI[] tarchives = DistributedCache.getCacheArchives(job);
        if (tarchives != null) {
            StringBuilder archiveVisibilities = new StringBuilder(String.valueOf(ClientDistributedCacheManager.isPublic(job, tarchives[0])));
            for (int i = 1; i < tarchives.length; ++i) {
                archiveVisibilities.append(",");
                archiveVisibilities.append(String.valueOf(ClientDistributedCacheManager.isPublic(job, tarchives[i])));
            }
            ClientDistributedCacheManager.setArchiveVisibilities(job, archiveVisibilities.toString());
        }
        if ((tfiles = DistributedCache.getCacheFiles(job)) != null) {
            StringBuilder fileVisibilities = new StringBuilder(String.valueOf(ClientDistributedCacheManager.isPublic(job, tfiles[0])));
            for (int i = 1; i < tfiles.length; ++i) {
                fileVisibilities.append(",");
                fileVisibilities.append(String.valueOf(ClientDistributedCacheManager.isPublic(job, tfiles[i])));
            }
            ClientDistributedCacheManager.setFileVisibilities(job, fileVisibilities.toString());
        }
    }

    static void setArchiveVisibilities(Configuration conf, String booleans) {
        conf.set("mapreduce.job.cache.archives.visibilities", booleans);
    }

    static void setFileVisibilities(Configuration conf, String booleans) {
        conf.set("mapreduce.job.cache.files.visibilities", booleans);
    }

    static void setArchiveTimestamps(Configuration conf, String timestamps) {
        conf.set("mapreduce.job.cache.archives.timestamps", timestamps);
    }

    static void setFileTimestamps(Configuration conf, String timestamps) {
        conf.set("mapreduce.job.cache.files.timestamps", timestamps);
    }

    static FileStatus getFileStatus(Configuration conf, URI cache) throws IOException {
        FileSystem fileSystem = FileSystem.get((URI)cache, (Configuration)conf);
        Path filePath = new Path(cache.getPath());
        return fileSystem.getFileStatus(filePath);
    }

    static boolean isPublic(Configuration conf, URI uri) throws IOException {
        Path current;
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        if (!ClientDistributedCacheManager.checkPermissionOfOther(fs, current = new Path(uri.getPath()), FsAction.READ)) {
            return false;
        }
        return ClientDistributedCacheManager.ancestorsHaveExecutePermissions(fs, current.getParent());
    }

    static boolean ancestorsHaveExecutePermissions(FileSystem fs, Path path) throws IOException {
        for (Path current = path; current != null; current = current.getParent()) {
            if (ClientDistributedCacheManager.checkPermissionOfOther(fs, current, FsAction.EXECUTE)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPermissionOfOther(FileSystem fs, Path path, FsAction action) throws IOException {
        FileStatus status = fs.getFileStatus(path);
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        return otherAction.implies(action);
    }
}

