/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.ProgressSplitsBlock;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.AvroArrayUtils;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinished;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ReduceAttemptFinishedEvent
implements HistoryEvent {
    private ReduceAttemptFinished datum = null;
    private TaskAttemptID attemptId;
    private TaskType taskType;
    private String taskStatus;
    private long shuffleFinishTime;
    private long sortFinishTime;
    private long finishTime;
    private String hostname;
    private String rackName;
    private int port;
    private String state;
    private Counters counters;
    int[][] allSplits;
    int[] clockSplits;
    int[] cpuUsages;
    int[] vMemKbytes;
    int[] physMemKbytes;

    public ReduceAttemptFinishedEvent(TaskAttemptID id, TaskType taskType, String taskStatus, long shuffleFinishTime, long sortFinishTime, long finishTime, String hostname, int port, String rackName, String state, Counters counters, int[][] allSplits) {
        this.attemptId = id;
        this.taskType = taskType;
        this.taskStatus = taskStatus;
        this.shuffleFinishTime = shuffleFinishTime;
        this.sortFinishTime = sortFinishTime;
        this.finishTime = finishTime;
        this.hostname = hostname;
        this.rackName = rackName;
        this.port = port;
        this.state = state;
        this.counters = counters;
        this.allSplits = allSplits;
        this.clockSplits = ProgressSplitsBlock.arrayGetWallclockTime(allSplits);
        this.cpuUsages = ProgressSplitsBlock.arrayGetCPUTime(allSplits);
        this.vMemKbytes = ProgressSplitsBlock.arrayGetVMemKbytes(allSplits);
        this.physMemKbytes = ProgressSplitsBlock.arrayGetPhysMemKbytes(allSplits);
    }

    public ReduceAttemptFinishedEvent(TaskAttemptID id, TaskType taskType, String taskStatus, long shuffleFinishTime, long sortFinishTime, long finishTime, String hostname, String state, Counters counters) {
        this(id, taskType, taskStatus, shuffleFinishTime, sortFinishTime, finishTime, hostname, -1, "", state, counters, null);
    }

    ReduceAttemptFinishedEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new ReduceAttemptFinished();
            this.datum.taskid = new Utf8(this.attemptId.getTaskID().toString());
            this.datum.attemptId = new Utf8(this.attemptId.toString());
            this.datum.taskType = new Utf8(this.taskType.name());
            this.datum.taskStatus = new Utf8(this.taskStatus);
            this.datum.shuffleFinishTime = this.shuffleFinishTime;
            this.datum.sortFinishTime = this.sortFinishTime;
            this.datum.finishTime = this.finishTime;
            this.datum.hostname = new Utf8(this.hostname);
            this.datum.port = this.port;
            if (this.rackName != null) {
                this.datum.rackname = new Utf8(this.rackName);
            }
            this.datum.state = new Utf8(this.state);
            this.datum.counters = EventWriter.toAvro(this.counters);
            this.datum.clockSplits = AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetWallclockTime(this.allSplits));
            this.datum.cpuUsages = AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetCPUTime(this.allSplits));
            this.datum.vMemKbytes = AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetVMemKbytes(this.allSplits));
            this.datum.physMemKbytes = AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetPhysMemKbytes(this.allSplits));
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object oDatum) {
        this.datum = (ReduceAttemptFinished)((Object)oDatum);
        this.attemptId = TaskAttemptID.forName(((Object)this.datum.attemptId).toString());
        this.taskType = TaskType.valueOf(((Object)this.datum.taskType).toString());
        this.taskStatus = ((Object)this.datum.taskStatus).toString();
        this.shuffleFinishTime = this.datum.shuffleFinishTime;
        this.sortFinishTime = this.datum.sortFinishTime;
        this.finishTime = this.datum.finishTime;
        this.hostname = ((Object)this.datum.hostname).toString();
        this.rackName = ((Object)this.datum.rackname).toString();
        this.port = this.datum.port;
        this.state = ((Object)this.datum.state).toString();
        this.counters = EventReader.fromAvro(this.datum.counters);
        this.clockSplits = AvroArrayUtils.fromAvro(this.datum.clockSplits);
        this.cpuUsages = AvroArrayUtils.fromAvro(this.datum.cpuUsages);
        this.vMemKbytes = AvroArrayUtils.fromAvro(this.datum.vMemKbytes);
        this.physMemKbytes = AvroArrayUtils.fromAvro(this.datum.physMemKbytes);
    }

    public TaskID getTaskId() {
        return this.attemptId.getTaskID();
    }

    public TaskAttemptID getAttemptId() {
        return TaskAttemptID.forName(this.attemptId.toString());
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(this.taskType.toString());
    }

    public String getTaskStatus() {
        return this.taskStatus.toString();
    }

    public long getSortFinishTime() {
        return this.sortFinishTime;
    }

    public long getShuffleFinishTime() {
        return this.shuffleFinishTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public String getHostname() {
        return this.hostname.toString();
    }

    public int getPort() {
        return this.port;
    }

    public String getRackName() {
        return this.rackName == null ? null : this.rackName.toString();
    }

    public String getState() {
        return this.state.toString();
    }

    Counters getCounters() {
        return this.counters;
    }

    @Override
    public EventType getEventType() {
        return EventType.REDUCE_ATTEMPT_FINISHED;
    }

    public int[] getClockSplits() {
        return this.clockSplits;
    }

    public int[] getCpuUsages() {
        return this.cpuUsages;
    }

    public int[] getVMemKbytes() {
        return this.vMemKbytes;
    }

    public int[] getPhysMemKbytes() {
        return this.physMemKbytes;
    }
}

