/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryViewer;
import org.apache.hadoop.mapreduce.jobhistory.HistoryViewerPrinter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class JSONHistoryViewerPrinter
implements HistoryViewerPrinter {
    private JobHistoryParser.JobInfo job;
    private boolean printAll;
    private String scheme;
    private JSONObject json;

    JSONHistoryViewerPrinter(JobHistoryParser.JobInfo job, boolean printAll, String scheme) {
        this.job = job;
        this.printAll = printAll;
        this.scheme = scheme;
    }

    @Override
    public void print(PrintStream ps) throws IOException {
        this.json = new JSONObject();
        try (Writer writer = null;){
            this.printJobDetails();
            this.printTaskSummary();
            this.printTasks();
            writer = new OutputStreamWriter((OutputStream)ps, "UTF-8");
            this.json.write(writer);
            writer.flush();
        }
    }

    private void printJobDetails() throws JSONException {
        this.json.put("hadoopJob", (Object)this.job.getJobId().toString());
        this.json.put("user", (Object)this.job.getUsername());
        this.json.put("jobName", (Object)this.job.getJobname());
        this.json.put("jobConf", (Object)this.job.getJobConfPath());
        this.json.put("submittedAt", this.job.getSubmitTime());
        this.json.put("launchedAt", this.job.getLaunchTime());
        this.json.put("finishedAt", this.job.getFinishTime());
        this.json.put("status", (Object)(this.job.getJobStatus() == null ? "Incomplete" : this.job.getJobStatus()));
        this.printJobCounters(this.job.getTotalCounters(), this.job.getMapCounters(), this.job.getReduceCounters());
    }

    private void printJobCounters(Counters totalCounters, Counters mapCounters, Counters reduceCounters) throws JSONException {
        if (totalCounters != null) {
            JSONObject jGroups = new JSONObject();
            for (CounterGroup counterGroup : totalCounters) {
                String groupName = counterGroup.getName();
                CounterGroup totalGroup = (CounterGroup)totalCounters.getGroup(groupName);
                CounterGroup mapGroup = (CounterGroup)mapCounters.getGroup(groupName);
                CounterGroup reduceGroup = (CounterGroup)reduceCounters.getGroup(groupName);
                Iterator ctrItr = totalGroup.iterator();
                JSONArray jGroup = new JSONArray();
                while (ctrItr.hasNext()) {
                    JSONObject jCounter = new JSONObject();
                    Counter counter = (Counter)ctrItr.next();
                    String name = counter.getName();
                    long mapValue = mapGroup.findCounter(name).getValue();
                    long reduceValue = reduceGroup.findCounter(name).getValue();
                    long totalValue = counter.getValue();
                    jCounter.put("counterName", (Object)name);
                    jCounter.put("mapValue", mapValue);
                    jCounter.put("reduceValue", reduceValue);
                    jCounter.put("totalValue", totalValue);
                    jGroup.put((Object)jCounter);
                }
                jGroups.put(this.fixGroupNameForShuffleErrors(totalGroup.getName()), (Object)jGroup);
            }
            this.json.put("counters", (Object)jGroups);
        }
    }

    private void printTaskSummary() throws JSONException {
        HistoryViewer.SummarizedJob ts = new HistoryViewer.SummarizedJob(this.job);
        JSONObject jSums = new JSONObject();
        JSONObject jSumSetup = new JSONObject();
        jSumSetup.put("total", ts.totalSetups);
        jSumSetup.put("successful", ts.numFinishedSetups);
        jSumSetup.put("failed", ts.numFailedSetups);
        jSumSetup.put("killed", ts.numKilledSetups);
        jSumSetup.put("startTime", ts.setupStarted);
        jSumSetup.put("finishTime", ts.setupFinished);
        jSums.put("setup", (Object)jSumSetup);
        JSONObject jSumMap = new JSONObject();
        jSumMap.put("total", ts.totalMaps);
        jSumMap.put("successful", this.job.getSucceededMaps());
        jSumMap.put("failed", ts.numFailedMaps);
        jSumMap.put("killed", ts.numKilledMaps);
        jSumMap.put("startTime", ts.mapStarted);
        jSumMap.put("finishTime", ts.mapFinished);
        jSums.put("map", (Object)jSumMap);
        JSONObject jSumReduce = new JSONObject();
        jSumReduce.put("total", ts.totalReduces);
        jSumReduce.put("successful", this.job.getSucceededReduces());
        jSumReduce.put("failed", ts.numFailedReduces);
        jSumReduce.put("killed", ts.numKilledReduces);
        jSumReduce.put("startTime", ts.reduceStarted);
        jSumReduce.put("finishTime", ts.reduceFinished);
        jSums.put("reduce", (Object)jSumReduce);
        JSONObject jSumCleanup = new JSONObject();
        jSumCleanup.put("total", ts.totalCleanups);
        jSumCleanup.put("successful", ts.numFinishedCleanups);
        jSumCleanup.put("failed", ts.numFailedCleanups);
        jSumCleanup.put("killed", ts.numKilledCleanups);
        jSumCleanup.put("startTime", ts.cleanupStarted);
        jSumCleanup.put("finishTime", ts.cleanupFinished);
        jSums.put("cleanup", (Object)jSumCleanup);
        this.json.put("taskSummary", (Object)jSums);
    }

    private void printTasks() throws JSONException {
        Map<TaskID, JobHistoryParser.TaskInfo> tasks = this.job.getAllTasks();
        JSONArray jTasks = new JSONArray();
        for (JobHistoryParser.TaskInfo task : tasks.values()) {
            if (!task.getTaskType().equals((Object)TaskType.TASK_CLEANUP) && (this.printAll && task.getTaskStatus().equals(TaskStatus.State.SUCCEEDED.toString()) || task.getTaskStatus().equals(TaskStatus.State.KILLED.toString()) || task.getTaskStatus().equals(TaskStatus.State.FAILED.toString()))) {
                JSONObject jTask = new JSONObject();
                jTask.put("taskId", (Object)task.getTaskId().toString());
                jTask.put("type", (Object)task.getTaskType().toString());
                jTask.put("status", (Object)task.getTaskStatus());
                jTask.put("startTime", task.getStartTime());
                jTask.put("finishTime", task.getFinishTime());
                if (!task.getError().isEmpty()) {
                    jTask.put("error", (Object)task.getError());
                }
                if (task.getTaskType().equals((Object)TaskType.MAP)) {
                    jTask.put("inputSplits", (Object)task.getSplitLocations());
                }
                if (this.printAll) {
                    this.printTaskCounters(jTask, task.getCounters());
                    JSONObject jAtt = new JSONObject();
                    for (JobHistoryParser.TaskAttemptInfo attempt : task.getAllTaskAttempts().values()) {
                        String taskLogsUrl;
                        jAtt.put("attemptId", (Object)attempt.getAttemptId());
                        jAtt.put("startTime", attempt.getStartTime());
                        if (task.getTaskType().equals((Object)TaskType.REDUCE)) {
                            jAtt.put("shuffleFinished", attempt.getShuffleFinishTime());
                            jAtt.put("sortFinished", attempt.getSortFinishTime());
                        }
                        jAtt.put("finishTime", attempt.getFinishTime());
                        jAtt.put("hostName", (Object)attempt.getHostname());
                        if (!attempt.getError().isEmpty()) {
                            jAtt.put("error", (Object)task.getError());
                        }
                        if ((taskLogsUrl = HistoryViewer.getTaskLogsUrl(this.scheme, attempt)) == null) continue;
                        jAtt.put("taskLogs", (Object)taskLogsUrl);
                    }
                    jTask.put("attempts", (Object)jAtt);
                }
                jTasks.put((Object)jTask);
            }
            this.json.put("tasks", (Object)jTasks);
        }
    }

    private void printTaskCounters(JSONObject jTask, Counters taskCounters) throws JSONException {
        if (taskCounters != null) {
            JSONObject jGroups = new JSONObject();
            for (String groupName : taskCounters.getGroupNames()) {
                CounterGroup group = (CounterGroup)taskCounters.getGroup(groupName);
                Iterator ctrItr = group.iterator();
                JSONArray jGroup = new JSONArray();
                while (ctrItr.hasNext()) {
                    JSONObject jCounter = new JSONObject();
                    Counter counter = (Counter)ctrItr.next();
                    jCounter.put("counterName", (Object)counter.getName());
                    jCounter.put("value", counter.getValue());
                    jGroup.put((Object)jCounter);
                }
                jGroups.put(this.fixGroupNameForShuffleErrors(group.getName()), (Object)jGroup);
            }
            jTask.put("counters", (Object)jGroups);
        }
    }

    private String fixGroupNameForShuffleErrors(String name) {
        String retName = name;
        if (name.equals("Shuffle Errors")) {
            retName = "org.apache.hadoop.mapreduce.task.reduce.Fetcher.ShuffleErrors";
        }
        return retName;
    }
}

