/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsTasksBlock;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsView;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class HsTasksPage
extends HsView {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        this.set("ui.dataTables.id", "tasks");
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:1}");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"tasks"), this.tasksTableInit());
        this.set(JQueryUI.postInitID((String)"ui.dataTables", (String)"tasks"), this.jobsPostTableInit());
        this.setTableStyles(html, "tasks", new String[0]);
    }

    @Override
    protected Class<? extends SubView> content() {
        return HsTasksBlock.class;
    }

    private String tasksTableInit() {
        TaskType type = null;
        String symbol = this.$("task.type");
        if (!symbol.isEmpty()) {
            type = MRApps.taskType((String)symbol);
        }
        StringBuilder b = JQueryUI.tableInit().append(",aoColumnDefs:[");
        b.append("{'sType':'title-numeric', 'aTargets': [ 0, 4");
        if (type == TaskType.REDUCE) {
            b.append(", 9, 10, 11, 12");
        } else {
            b.append(", 7");
        }
        b.append(" ] }]");
        b.append(", aaSorting: [[0, 'asc']]");
        b.append("}");
        return b.toString();
    }

    private String jobsPostTableInit() {
        return "var asInitVals = new Array();\n$('tfoot input').keyup( function () \n{  tasksDataTable.fnFilter( this.value, $('tfoot input').index(this) );\n} );\n$('tfoot input').each( function (i) {\n  asInitVals[i] = this.value;\n} );\n$('tfoot input').focus( function () {\n  if ( this.className == 'search_init' )\n  {\n    this.className = '';\n    this.value = '';\n  }\n} );\n$('tfoot input').blur( function (i) {\n  if ( this.value == '' )\n  {\n    this.className = 'search_init';\n    this.value = asInitVals[$('tfoot input').index(this)];\n  }\n} );\n";
    }
}

