/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobCounterInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobTaskAttemptCounterInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobTaskCounterInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ReduceTaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptsInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TasksInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.AMAttemptInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.AMAttemptsInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.HistoryInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobsInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.WebApp;

@Path(value="/ws/v1/history")
public class HsWebServices {
    private final AppContext appCtx;
    private WebApp webapp;
    private final Configuration conf;
    @Context
    UriInfo uriInfo;

    @Inject
    public HsWebServices(AppContext appCtx, Configuration conf, WebApp webapp) {
        this.appCtx = appCtx;
        this.conf = conf;
        this.webapp = webapp;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public HistoryInfo get() {
        return this.getHistoryInfo();
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json", "application/xml"})
    public HistoryInfo getHistoryInfo() {
        return new HistoryInfo();
    }

    @GET
    @Path(value="/mapreduce/jobs")
    @Produces(value={"application/json", "application/xml"})
    public JobsInfo getJobs(@QueryParam(value="user") String userQuery, @QueryParam(value="limit") String count, @QueryParam(value="queue") String queueQuery, @QueryParam(value="startedTimeBegin") String startedBegin, @QueryParam(value="startedTimeEnd") String startedEnd, @QueryParam(value="finishedTimeBegin") String finishBegin, @QueryParam(value="finishedTimeEnd") String finishEnd) {
        JobsInfo allJobs = new JobsInfo();
        long num = 0L;
        boolean checkCount = false;
        boolean checkStart = false;
        boolean checkEnd = false;
        long countNum = 0L;
        long sBegin = 0L;
        long sEnd = Long.MAX_VALUE;
        long fBegin = 0L;
        long fEnd = Long.MAX_VALUE;
        if (count != null && !count.isEmpty()) {
            checkCount = true;
            try {
                countNum = Long.parseLong(count);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException(e.getMessage());
            }
            if (countNum <= 0L) {
                throw new BadRequestException("limit value must be greater then 0");
            }
        }
        if (startedBegin != null && !startedBegin.isEmpty()) {
            checkStart = true;
            try {
                sBegin = Long.parseLong(startedBegin);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Invalid number format: " + e.getMessage());
            }
            if (sBegin < 0L) {
                throw new BadRequestException("startedTimeBegin must be greater than 0");
            }
        }
        if (startedEnd != null && !startedEnd.isEmpty()) {
            checkStart = true;
            try {
                sEnd = Long.parseLong(startedEnd);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Invalid number format: " + e.getMessage());
            }
            if (sEnd < 0L) {
                throw new BadRequestException("startedTimeEnd must be greater than 0");
            }
        }
        if (sBegin > sEnd) {
            throw new BadRequestException("startedTimeEnd must be greater than startTimeBegin");
        }
        if (finishBegin != null && !finishBegin.isEmpty()) {
            checkEnd = true;
            try {
                fBegin = Long.parseLong(finishBegin);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Invalid number format: " + e.getMessage());
            }
            if (fBegin < 0L) {
                throw new BadRequestException("finishedTimeBegin must be greater than 0");
            }
        }
        if (finishEnd != null && !finishEnd.isEmpty()) {
            checkEnd = true;
            try {
                fEnd = Long.parseLong(finishEnd);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Invalid number format: " + e.getMessage());
            }
            if (fEnd < 0L) {
                throw new BadRequestException("finishedTimeEnd must be greater than 0");
            }
        }
        if (fBegin > fEnd) {
            throw new BadRequestException("finishedTimeEnd must be greater than finishedTimeBegin");
        }
        for (Job job : this.appCtx.getAllJobs().values()) {
            if (checkCount && num == countNum) break;
            if (queueQuery != null && !queueQuery.isEmpty() && !job.getQueueName().equals(queueQuery) || userQuery != null && !userQuery.isEmpty() && !job.getUserName().equals(userQuery)) continue;
            JobReport report = job.getReport();
            if (checkStart && (report.getStartTime() < sBegin || report.getStartTime() > sEnd) || checkEnd && (report.getFinishTime() < fBegin || report.getFinishTime() > fEnd)) continue;
            JobInfo jobInfo = new JobInfo(job);
            allJobs.add(jobInfo);
            ++num;
        }
        return allJobs;
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}")
    @Produces(value={"application/json", "application/xml"})
    public JobInfo getJob(@PathParam(value="jobid") String jid) {
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.appCtx);
        return new JobInfo(job);
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/jobattempts")
    @Produces(value={"application/json", "application/xml"})
    public AMAttemptsInfo getJobAttempts(@PathParam(value="jobid") String jid) {
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.appCtx);
        AMAttemptsInfo amAttempts = new AMAttemptsInfo();
        for (AMInfo amInfo : job.getAMInfos()) {
            AMAttemptInfo attempt = new AMAttemptInfo(amInfo, MRApps.toString((JobId)job.getID()), job.getUserName(), this.uriInfo.getBaseUri().toString(), this.webapp.name());
            amAttempts.add(attempt);
        }
        return amAttempts;
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/counters")
    @Produces(value={"application/json", "application/xml"})
    public JobCounterInfo getJobCounters(@PathParam(value="jobid") String jid) {
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.appCtx);
        return new JobCounterInfo(this.appCtx, job);
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/conf")
    @Produces(value={"application/json", "application/xml"})
    public ConfInfo getJobConf(@PathParam(value="jobid") String jid) {
        ConfInfo info;
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.appCtx);
        try {
            info = new ConfInfo(job, this.conf);
        }
        catch (IOException e) {
            throw new NotFoundException("unable to load configuration for job: " + jid);
        }
        return info;
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/tasks")
    @Produces(value={"application/json", "application/xml"})
    public TasksInfo getJobTasks(@PathParam(value="jobid") String jid, @QueryParam(value="type") String type) {
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.appCtx);
        TasksInfo allTasks = new TasksInfo();
        for (Task task : job.getTasks().values()) {
            TaskType ttype = null;
            if (type != null && !type.isEmpty()) {
                try {
                    ttype = MRApps.taskType((String)type);
                }
                catch (YarnException e) {
                    throw new BadRequestException("tasktype must be either m or r");
                }
            }
            if (ttype != null && task.getType() != ttype) continue;
            allTasks.add(new TaskInfo(task));
        }
        return allTasks;
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/tasks/{taskid}")
    @Produces(value={"application/json", "application/xml"})
    public TaskInfo getJobTask(@PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid) {
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.appCtx);
        Task task = AMWebServices.getTaskFromTaskIdString((String)tid, (Job)job);
        return new TaskInfo(task);
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/tasks/{taskid}/counters")
    @Produces(value={"application/json", "application/xml"})
    public JobTaskCounterInfo getSingleTaskCounters(@PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid) {
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.appCtx);
        TaskId taskID = MRApps.toTaskID((String)tid);
        if (taskID == null) {
            throw new NotFoundException("taskid " + tid + " not found or invalid");
        }
        Task task = job.getTask(taskID);
        if (task == null) {
            throw new NotFoundException("task not found with id " + tid);
        }
        return new JobTaskCounterInfo(task);
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/tasks/{taskid}/attempts")
    @Produces(value={"application/json", "application/xml"})
    public TaskAttemptsInfo getJobTaskAttempts(@PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid) {
        TaskAttemptsInfo attempts = new TaskAttemptsInfo();
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.appCtx);
        Task task = AMWebServices.getTaskFromTaskIdString((String)tid, (Job)job);
        for (TaskAttempt ta : task.getAttempts().values()) {
            if (ta == null) continue;
            if (task.getType() == TaskType.REDUCE) {
                attempts.add((TaskAttemptInfo)new ReduceTaskAttemptInfo(ta, task.getType()));
                continue;
            }
            attempts.add(new TaskAttemptInfo(ta, task.getType(), Boolean.valueOf(false)));
        }
        return attempts;
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/tasks/{taskid}/attempts/{attemptid}")
    @Produces(value={"application/json", "application/xml"})
    public TaskAttemptInfo getJobTaskAttemptId(@PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid, @PathParam(value="attemptid") String attId) {
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.appCtx);
        Task task = AMWebServices.getTaskFromTaskIdString((String)tid, (Job)job);
        TaskAttempt ta = AMWebServices.getTaskAttemptFromTaskAttemptString((String)attId, (Task)task);
        if (task.getType() == TaskType.REDUCE) {
            return new ReduceTaskAttemptInfo(ta, task.getType());
        }
        return new TaskAttemptInfo(ta, task.getType(), Boolean.valueOf(false));
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/tasks/{taskid}/attempts/{attemptid}/counters")
    @Produces(value={"application/json", "application/xml"})
    public JobTaskAttemptCounterInfo getJobTaskAttemptIdCounters(@PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid, @PathParam(value="attemptid") String attId) {
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.appCtx);
        Task task = AMWebServices.getTaskFromTaskIdString((String)tid, (Job)job);
        TaskAttempt ta = AMWebServices.getTaskAttemptFromTaskAttemptString((String)attId, (Task)task);
        return new JobTaskAttemptCounterInfo(ta);
    }
}

