/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import org.apache.hadoop.RandomTextWriterJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class RandomTextWriterJob
extends Configured
implements Tool {
    public static final String TOTAL_BYTES = "mapreduce.randomtextwriter.totalbytes";
    public static final String BYTES_PER_MAP = "mapreduce.randomtextwriter.bytespermap";
    public static final String MAX_VALUE = "mapreduce.randomtextwriter.maxwordsvalue";
    public static final String MIN_VALUE = "mapreduce.randomtextwriter.minwordsvalue";
    public static final String MIN_KEY = "mapreduce.randomtextwriter.minwordskey";
    public static final String MAX_KEY = "mapreduce.randomtextwriter.maxwordskey";

    public Job createJob(Configuration conf) throws IOException {
        long numBytesToWritePerMap = conf.getLong("mapreduce.randomtextwriter.bytespermap", 10240L);
        long totalBytesToWrite = conf.getLong("mapreduce.randomtextwriter.totalbytes", numBytesToWritePerMap);
        int numMaps = (int)(totalBytesToWrite / numBytesToWritePerMap);
        if (numMaps == 0 && totalBytesToWrite > 0L) {
            numMaps = 1;
            conf.setLong("mapreduce.randomtextwriter.bytespermap", totalBytesToWrite);
        }
        conf.setInt("mapreduce.job.maps", numMaps);
        Job job = new Job(conf);
        job.setJarByClass(RandomTextWriterJob.class);
        job.setJobName("random-text-writer");
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(RandomInputFormat.class);
        job.setMapperClass(RandomTextMapper.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setNumReduceTasks(0);
        return job;
    }

    public int run(String[] args) throws Exception {
        if (args.length == 0) {
            return RandomTextWriterJob.printUsage();
        }
        Job job = this.createJob(this.getConf());
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[0]));
        Date startTime = new Date();
        System.out.println("Job started: " + startTime);
        int ret = job.waitForCompletion(true) ? 0 : 1;
        Date endTime = new Date();
        System.out.println("Job ended: " + endTime);
        System.out.println("The job took " + (endTime.getTime() - startTime.getTime()) / 1000L + " seconds.");
        return ret;
    }

    static int printUsage() {
        System.out.println("randomtextwriter [-outFormat <output format class>] <output>");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return 2;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new RandomTextWriterJob(), (String[])args);
        System.exit(res);
    }
}

