/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Timer;

class MkdirOp
extends Operation {
    private static final Log LOG = LogFactory.getLog(MkdirOp.class);

    MkdirOp(ConfigExtractor cfg, Random rnd) {
        super(MkdirOp.class.getSimpleName(), cfg, rnd);
    }

    protected Path getDirectory() {
        Path dir = this.getFinder().getDirectory();
        return dir;
    }

    List<OperationOutput> run(FileSystem fs) {
        List out = super.run(fs);
        try {
            Path dir = this.getDirectory();
            boolean mkRes = false;
            long timeTaken = 0L;
            long startTime = Timer.now();
            mkRes = fs.mkdirs(dir);
            timeTaken = Timer.elapsed((long)startTime);
            if (mkRes) {
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", (Object)timeTaken));
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", (Object)1L));
                LOG.info((Object)("Made directory " + dir));
            } else {
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", (Object)1L));
                LOG.warn((Object)("Could not make " + dir));
            }
        }
        catch (FileNotFoundException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "files_not_found", (Object)1L));
            LOG.warn((Object)"Error with mkdir", (Throwable)e);
        }
        catch (IOException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", (Object)1L));
            LOG.warn((Object)"Error with mkdir", (Throwable)e);
        }
        return out;
    }
}

