/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.TestMRJobClient;
import org.apache.hadoop.mapreduce.tools.CLI;
import org.apache.hadoop.util.Tool;
import org.junit.Ignore;

@Ignore
public class TestJobClient
extends TestMRJobClient {
    private String runJob() throws Exception {
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getInputDir(), "text.txt"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("hello1\n");
        wr.write("hello2\n");
        wr.write("hello3\n");
        ((Writer)wr).close();
        JobConf conf = this.createJobConf();
        conf.setJobName("mr");
        conf.setJobPriority(JobPriority.HIGH);
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputDir()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.getOutputDir());
        return JobClient.runJob((JobConf)conf).getID().toString();
    }

    public static int runTool(Configuration conf, Tool tool, String[] args, OutputStream out) throws Exception {
        return TestMRJobClient.runTool((Configuration)conf, (Tool)tool, (String[])args, (OutputStream)out);
    }

    static void verifyJobPriority(String jobId, String priority, JobConf conf) throws Exception {
        TestJobClient test = new TestJobClient();
        test.verifyJobPriority(jobId, priority, (Configuration)conf, test.createJobClient());
    }

    public void testJobClient() throws Exception {
        JobConf conf = this.createJobConf();
        String jobId = this.runJob();
        this.testGetCounter(jobId, (Configuration)conf);
        this.testAllJobList(jobId, (Configuration)conf);
        this.testChangingJobPriority(jobId, (Configuration)conf);
    }

    protected CLI createJobClient() throws IOException {
        return new JobClient();
    }
}

