/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TestMerge;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMerge
extends TestCase {
    private static final int NUM_HADOOP_DATA_NODES = 2;
    private static final int NUM_MAPPERS = 10;
    private static final int NUM_REDUCERS = 4;
    private static final int NUM_LINES = 1000;
    private static final Path INPUT_DIR = new Path("/testplugin/input");
    private static final Path OUTPUT = new Path("/testplugin/output");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMerge() throws Exception {
        MiniDFSCluster dfsCluster = null;
        MiniMRClientCluster mrCluster = null;
        DistributedFileSystem fileSystem = null;
        try {
            Configuration conf = new Configuration();
            dfsCluster = new MiniDFSCluster(conf, 2, true, null);
            fileSystem = dfsCluster.getFileSystem();
            mrCluster = MiniMRClientClusterFactory.create(this.getClass(), (int)2, (Configuration)conf);
            this.createInput((FileSystem)fileSystem);
            this.runMergeTest(new JobConf(mrCluster.getConfig()), (FileSystem)fileSystem);
        }
        finally {
            if (dfsCluster != null) {
                dfsCluster.shutdown();
            }
            if (mrCluster != null) {
                mrCluster.stop();
            }
        }
    }

    private void createInput(FileSystem fs) throws Exception {
        fs.delete(INPUT_DIR, true);
        for (int i = 0; i < 10; ++i) {
            FSDataOutputStream os = fs.create(new Path(INPUT_DIR, "input_" + i + ".txt"));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os);
            for (int j = 0; j < 1000; ++j) {
                int k = j + 1;
                String formattedNumber = String.format("%09d", k);
                writer.write(formattedNumber + " " + formattedNumber + "\n");
            }
            ((Writer)writer).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMergeTest(JobConf job, FileSystem fileSystem) throws Exception {
        fileSystem.delete(OUTPUT, true);
        job.setJobName("MergeTest");
        JobClient client = new JobClient(job);
        RunningJob submittedJob = null;
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{INPUT_DIR});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)OUTPUT);
        job.set("mapreduce.output.textoutputformat.separator", " ");
        job.setInputFormat(TextInputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setMapperClass(MyMapper.class);
        job.setPartitionerClass(MyPartitioner.class);
        job.setOutputFormat(TextOutputFormat.class);
        job.setNumReduceTasks(4);
        job.set("mapreduce.job.map.output.collector.class", MapOutputCopier.class.getName());
        try {
            submittedJob = client.submitJob(job);
            try {
                if (!client.monitorAndPrintJob(job, submittedJob)) {
                    throw new IOException("Job failed!");
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException ioe) {
            System.err.println("Job failed with: " + ioe);
        }
        finally {
            this.verifyOutput(submittedJob, fileSystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOutput(RunningJob submittedJob, FileSystem fileSystem) throws Exception {
        Path[] fileList;
        FSDataInputStream dis = null;
        long numValidRecords = 0L;
        long numInvalidRecords = 0L;
        long numMappersLaunched = 10L;
        String prevKeyValue = "000000000";
        for (Path outFile : fileList = FileUtil.stat2Paths((FileStatus[])fileSystem.listStatus(OUTPUT, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()))) {
            try {
                String record;
                dis = fileSystem.open(outFile);
                while ((record = dis.readLine()) != null) {
                    int blankPos = record.indexOf(" ");
                    String keyString = record.substring(0, blankPos);
                    String valueString = record.substring(blankPos + 1);
                    if (keyString.compareTo(prevKeyValue) >= 0 && keyString.equals(valueString)) {
                        prevKeyValue = keyString;
                        ++numValidRecords;
                        continue;
                    }
                    ++numInvalidRecords;
                }
            }
            finally {
                if (dis != null) {
                    dis.close();
                    dis = null;
                }
            }
        }
        TestMerge.assertEquals((long)10000L, (long)numValidRecords);
        TestMerge.assertEquals((long)0L, (long)numInvalidRecords);
    }
}

