/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapred.pipes.Submitter;
import org.apache.hadoop.mapred.pipes.WordCountInputFormat;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Ignore;

/*
 * Exception performing whole class analysis ignored.
 */
@Ignore
public class TestPipes
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestPipes.class.getName());
    private static Path cppExamples = new Path(System.getProperty("install.c++.examples"));
    static Path wordCountSimple = new Path(cppExamples, "bin/wordcount-simple");
    static Path wordCountPart = new Path(cppExamples, "bin/wordcount-part");
    static Path wordCountNoPipes = new Path(cppExamples, "bin/wordcount-nopipe");
    static Path nonPipedOutDir;
    static final String[] twoSplitOutput;
    static final String[] noSortOutput;
    static final String[] fixedPartitionOutput;

    static void cleanup(FileSystem fs, Path p) throws IOException {
        fs.delete(p, true);
        TestPipes.assertFalse((String)"output not cleaned up", (boolean)fs.exists(p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPipes() throws IOException {
        if (System.getProperty("compile.c++") == null) {
            LOG.info((Object)"compile.c++ is not defined, so skipping TestPipes");
            return;
        }
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        Path inputPath = new Path("testing/in");
        Path outputPath = new Path("testing/out");
        try {
            int numSlaves = 2;
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 2, true, null);
            mr = new MiniMRCluster(2, dfs.getFileSystem().getUri().toString(), 1);
            TestPipes.writeInputFile((FileSystem)dfs.getFileSystem(), (Path)inputPath);
            TestPipes.runProgram((MiniMRCluster)mr, (MiniDFSCluster)dfs, (Path)wordCountSimple, (Path)inputPath, (Path)outputPath, (int)3, (int)2, (String[])twoSplitOutput, null);
            TestPipes.cleanup((FileSystem)dfs.getFileSystem(), (Path)outputPath);
            TestPipes.runProgram((MiniMRCluster)mr, (MiniDFSCluster)dfs, (Path)wordCountSimple, (Path)inputPath, (Path)outputPath, (int)3, (int)0, (String[])noSortOutput, null);
            TestPipes.cleanup((FileSystem)dfs.getFileSystem(), (Path)outputPath);
            TestPipes.runProgram((MiniMRCluster)mr, (MiniDFSCluster)dfs, (Path)wordCountPart, (Path)inputPath, (Path)outputPath, (int)3, (int)2, (String[])fixedPartitionOutput, null);
            TestPipes.runNonPipedProgram((MiniMRCluster)mr, (MiniDFSCluster)dfs, (Path)wordCountNoPipes, null);
            mr.waitUntilIdle();
        }
        finally {
            mr.shutdown();
            dfs.shutdown();
        }
    }

    static void writeInputFile(FileSystem fs, Path dir) throws IOException {
        FSDataOutputStream out = fs.create(new Path(dir, "part0"));
        out.writeBytes("Alice was beginning to get very tired of sitting by her\n");
        out.writeBytes("sister on the bank, and of having nothing to do: once\n");
        out.writeBytes("or twice she had peeped into the book her sister was\n");
        out.writeBytes("reading, but it had no pictures or conversations in\n");
        out.writeBytes("it, `and what is the use of a book,' thought Alice\n");
        out.writeBytes("`without pictures or conversation?'\n");
        out.close();
    }

    static void runProgram(MiniMRCluster mr, MiniDFSCluster dfs, Path program, Path inputPath, Path outputPath, int numMaps, int numReduces, String[] expectedResults, JobConf conf) throws IOException {
        Path wordExec = new Path("testing/bin/application");
        JobConf job = null;
        job = conf == null ? mr.createJobConf() : new JobConf((Configuration)conf);
        job.setNumMapTasks(numMaps);
        job.setNumReduceTasks(numReduces);
        DistributedFileSystem fs = dfs.getFileSystem();
        fs.delete(wordExec.getParent(), true);
        fs.copyFromLocalFile(program, wordExec);
        Submitter.setExecutable((JobConf)job, (String)fs.makeQualified(wordExec).toString());
        Submitter.setIsJavaRecordReader((JobConf)job, (boolean)true);
        Submitter.setIsJavaRecordWriter((JobConf)job, (boolean)true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inputPath});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
        RunningJob rJob = null;
        if (numReduces == 0) {
            rJob = Submitter.jobSubmit((JobConf)job);
            while (!rJob.isComplete()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
        } else {
            rJob = Submitter.runJob((JobConf)job);
        }
        TestPipes.assertTrue((String)"pipes job failed", (boolean)rJob.isSuccessful());
        Counters counters = rJob.getCounters();
        Counters.Group wordCountCounters = counters.getGroup("WORDCOUNT");
        int numCounters = 0;
        for (Counters.Counter c : wordCountCounters) {
            System.out.println(c);
            ++numCounters;
        }
        TestPipes.assertTrue((String)"No counters found!", (numCounters > 0 ? 1 : 0) != 0);
        ArrayList<String> results = new ArrayList<String>();
        for (Path p : FileUtil.stat2Paths((FileStatus[])dfs.getFileSystem().listStatus(outputPath, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()))) {
            results.add(MapReduceTestUtil.readOutput((Path)p, (Configuration)job));
        }
        TestPipes.assertEquals((String)"number of reduces is wrong", (int)expectedResults.length, (int)results.size());
        for (int i = 0; i < results.size(); ++i) {
            TestPipes.assertEquals((String)("pipes program " + program + " output " + i + " wrong"), (String)expectedResults[i], (String)((String)results.get(i)));
        }
    }

    static void runNonPipedProgram(MiniMRCluster mr, MiniDFSCluster dfs, Path program, JobConf conf) throws IOException {
        JobConf job = conf == null ? mr.createJobConf() : new JobConf((Configuration)conf);
        job.setInputFormat(WordCountInputFormat.class);
        LocalFileSystem local = FileSystem.getLocal((Configuration)job);
        Path testDir = new Path("file:" + System.getProperty("test.build.data"), "pipes");
        Path inDir = new Path(testDir, "input");
        nonPipedOutDir = new Path(testDir, "output");
        Path wordExec = new Path("testing/bin/application");
        Path jobXml = new Path(testDir, "job.xml");
        DistributedFileSystem fs = dfs.getFileSystem();
        fs.delete(wordExec.getParent(), true);
        fs.copyFromLocalFile(program, wordExec);
        FSDataOutputStream out = local.create(new Path(inDir, "part0"));
        out.writeBytes("i am a silly test\n");
        out.writeBytes("you are silly\n");
        out.writeBytes("i am a cat test\n");
        out.writeBytes("you is silly\n");
        out.writeBytes("i am a billy test\n");
        out.writeBytes("hello are silly\n");
        out.close();
        out = local.create(new Path(inDir, "part1"));
        out.writeBytes("mall world things drink java\n");
        out.writeBytes("hall silly cats drink java\n");
        out.writeBytes("all dogs bow wow\n");
        out.writeBytes("hello drink java\n");
        out.close();
        local.delete(nonPipedOutDir, true);
        local.mkdirs(nonPipedOutDir, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        out = local.create(jobXml);
        job.writeXml((OutputStream)out);
        out.close();
        System.err.println("About to run: Submitter -conf " + jobXml + " -input " + inDir + " -output " + nonPipedOutDir + " -program " + dfs.getFileSystem().makeQualified(wordExec));
        try {
            int ret = ToolRunner.run((Tool)new Submitter(), (String[])new String[]{"-conf", jobXml.toString(), "-input", inDir.toString(), "-output", nonPipedOutDir.toString(), "-program", dfs.getFileSystem().makeQualified(wordExec).toString(), "-reduces", "2"});
            TestPipes.assertEquals((int)0, (int)ret);
        }
        catch (Exception e) {
            TestPipes.assertTrue((String)("got exception: " + StringUtils.stringifyException((Throwable)e)), (boolean)false);
        }
    }

    static {
        twoSplitOutput = new String[]{"`and\t1\na\t1\nand\t1\nbeginning\t1\nbook\t1\nbut\t1\nby\t1\nconversation?'\t1\ndo:\t1\nhad\t2\nhaving\t1\nher\t2\nin\t1\nit\t1\nit,\t1\nno\t1\nnothing\t1\nof\t3\non\t1\nonce\t1\nor\t3\npeeped\t1\npictures\t2\nthe\t3\nthought\t1\nto\t2\nuse\t1\nwas\t2\n", "Alice\t2\n`without\t1\nbank,\t1\nbook,'\t1\nconversations\t1\nget\t1\ninto\t1\nis\t1\nreading,\t1\nshe\t1\nsister\t2\nsitting\t1\ntired\t1\ntwice\t1\nvery\t1\nwhat\t1\n"};
        noSortOutput = new String[]{"it,\t1\n`and\t1\nwhat\t1\nis\t1\nthe\t1\nuse\t1\nof\t1\na\t1\nbook,'\t1\nthought\t1\nAlice\t1\n`without\t1\npictures\t1\nor\t1\nconversation?'\t1\n", "Alice\t1\nwas\t1\nbeginning\t1\nto\t1\nget\t1\nvery\t1\ntired\t1\nof\t1\nsitting\t1\nby\t1\nher\t1\nsister\t1\non\t1\nthe\t1\nbank,\t1\nand\t1\nof\t1\nhaving\t1\nnothing\t1\nto\t1\ndo:\t1\nonce\t1\n", "or\t1\ntwice\t1\nshe\t1\nhad\t1\npeeped\t1\ninto\t1\nthe\t1\nbook\t1\nher\t1\nsister\t1\nwas\t1\nreading,\t1\nbut\t1\nit\t1\nhad\t1\nno\t1\npictures\t1\nor\t1\nconversations\t1\nin\t1\n"};
        fixedPartitionOutput = new String[]{"Alice\t2\n`and\t1\n`without\t1\na\t1\nand\t1\nbank,\t1\nbeginning\t1\nbook\t1\nbook,'\t1\nbut\t1\nby\t1\nconversation?'\t1\nconversations\t1\ndo:\t1\nget\t1\nhad\t2\nhaving\t1\nher\t2\nin\t1\ninto\t1\nis\t1\nit\t1\nit,\t1\nno\t1\nnothing\t1\nof\t3\non\t1\nonce\t1\nor\t3\npeeped\t1\npictures\t2\nreading,\t1\nshe\t1\nsister\t2\nsitting\t1\nthe\t3\nthought\t1\ntired\t1\nto\t2\ntwice\t1\nuse\t1\nvery\t1\nwas\t2\nwhat\t1\n", ""};
    }
}

