/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FileBench;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileBench
extends Configured
implements Tool {
    static String[] keys;
    static String[] values;
    static StringBuilder sentence;
    static Map<Class<? extends Enum>, Map<String, ? extends Enum>> fullmap;
    private static final String[] words;

    static int printUsage() {
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        System.out.println("Usage: Task list:           -[no]r -[no]w\n       Format:              -[no]seq -[no]txt\n       CompressionCodec:    -[no]zip -[no]pln\n       CompressionType:     -[no]blk -[no]rec\n       Required:            -dir <working dir>\nAll valid combinations are implicitly enabled, unless an option is enabled\nexplicitly. For example, specifying \"-zip\", excludes -pln,\nunless they are also explicitly included, as in \"-pln -zip\"\nNote that CompressionType params only apply to SequenceFiles\n\nUseful options to set:\n-D fs.defaultFS=\"file:///\" \\\n-D fs.file.impl=org.apache.hadoop.fs.RawLocalFileSystem \\\n-D filebench.file.bytes=$((10*1024*1024*1024)) \\\n-D filebench.key.words=5 \\\n-D filebench.val.words=20\n");
        return -1;
    }

    private static String generateSentence(Random r, int noWords) {
        sentence.setLength(0);
        for (int i = 0; i < noWords; ++i) {
            sentence.append(words[r.nextInt(words.length)]);
            sentence.append(" ");
        }
        return sentence.toString();
    }

    private static void fillBlocks(JobConf conf) {
        Random r = new Random();
        long seed = conf.getLong("filebench.seed", -1L);
        if (seed > 0L) {
            r.setSeed(seed);
        }
        int keylen = conf.getInt("filebench.key.words", 5);
        int vallen = conf.getInt("filebench.val.words", 20);
        int acc = 3 * conf.getInt("io.seqfile.compress.blocksize", 1000000) >> 1;
        ArrayList<String> k = new ArrayList<String>();
        ArrayList<String> v = new ArrayList<String>();
        int i = 0;
        while (acc > 0) {
            String s = FileBench.generateSentence((Random)r, (int)keylen);
            acc -= s.length();
            k.add(s);
            s = FileBench.generateSentence((Random)r, (int)vallen);
            acc -= s.length();
            v.add(s);
            ++i;
        }
        keys = k.toArray(new String[0]);
        values = v.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long writeBench(JobConf conf) throws IOException {
        long filelen = conf.getLong("filebench.file.bytes", 0x40000000L);
        Text key = new Text();
        Text val = new Text();
        String fn = conf.get("test.filebench.name", "");
        Path outd = FileOutputFormat.getOutputPath((JobConf)conf);
        conf.set("mapred.work.output.dir", outd.toString());
        OutputFormat outf = conf.getOutputFormat();
        RecordWriter rw = outf.getRecordWriter(outd.getFileSystem((Configuration)conf), conf, fn, (Progressable)Reporter.NULL);
        try {
            long acc = 0L;
            Date start = new Date();
            int i = 0;
            while (acc < filelen) {
                key.set(keys[i %= keys.length]);
                val.set(values[i]);
                rw.write((Object)key, (Object)val);
                acc += (long)keys[i].length();
                acc += (long)values[i].length();
                ++i;
            }
            Date end = new Date();
            long l = end.getTime() - start.getTime();
            return l;
        }
        finally {
            rw.close(Reporter.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readBench(JobConf conf) throws IOException {
        InputFormat inf = conf.getInputFormat();
        String fn = conf.get("test.filebench.name", "");
        Path pin = new Path(FileInputFormat.getInputPaths((JobConf)conf)[0], fn);
        FileStatus in = pin.getFileSystem((Configuration)conf).getFileStatus(pin);
        RecordReader rr = inf.getRecordReader((InputSplit)new FileSplit(pin, 0L, in.getLen(), (String[])null), conf, Reporter.NULL);
        try {
            Object key = rr.createKey();
            Object val = rr.createValue();
            Date start = new Date();
            while (rr.next(key, val)) {
            }
            Date end = new Date();
            long l = end.getTime() - start.getTime();
            return l;
        }
        finally {
            rr.close();
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new FileBench(), (String[])args);
        System.exit(res);
    }

    public int run(String[] argv) throws IOException {
        JobConf job = new JobConf(this.getConf());
        EnumSet cc = null;
        EnumSet ct = null;
        EnumSet f = null;
        EnumSet rw = null;
        Path root = null;
        FileSystem fs = FileSystem.get((Configuration)job);
        for (int i = 0; i < argv.length; ++i) {
            try {
                String arg;
                if ("-dir".equals(argv[i])) {
                    root = new Path(argv[++i]).makeQualified(fs);
                    System.out.println("DIR: " + root.toString());
                    continue;
                }
                if ("-seed".equals(argv[i])) {
                    job.setLong("filebench.seed", Long.valueOf(argv[++i]).longValue());
                    continue;
                }
                if (argv[i].startsWith("-no")) {
                    arg = argv[i].substring(3);
                    cc = FileBench.rem(CCodec.class, cc, (String)arg);
                    ct = FileBench.rem(CType.class, ct, (String)arg);
                    f = FileBench.rem(Format.class, f, (String)arg);
                    rw = FileBench.rem(RW.class, rw, (String)arg);
                    continue;
                }
                arg = argv[i].substring(1);
                cc = FileBench.add(CCodec.class, cc, (String)arg);
                ct = FileBench.add(CType.class, ct, (String)arg);
                f = FileBench.add(Format.class, f, (String)arg);
                rw = FileBench.add(RW.class, rw, (String)arg);
                continue;
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        if (null == root) {
            System.out.println("Missing -dir param");
            FileBench.printUsage();
            return -1;
        }
        FileBench.fillBlocks((JobConf)job);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{root});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)root);
        if (null == cc) {
            cc = EnumSet.allOf(CCodec.class);
        }
        if (null == ct) {
            ct = EnumSet.allOf(CType.class);
        }
        if (null == f) {
            f = EnumSet.allOf(Format.class);
        }
        if (null == rw) {
            rw = EnumSet.allOf(RW.class);
        }
        for (RW rwop : rw) {
            for (Format fmt : f) {
                fmt.configure(job);
                for (CCodec cod : cc) {
                    cod.configure(job);
                    if (fmt != Format.txt && cod != CCodec.pln) {
                        for (CType typ : ct) {
                            String fn = fmt.name().toUpperCase() + "_" + cod.name().toUpperCase() + "_" + typ.name().toUpperCase();
                            typ.configure(job);
                            System.out.print(rwop.name().toUpperCase() + " " + fn + ": ");
                            System.out.println(rwop.exec(fn, job) / 1000L + " seconds");
                        }
                        continue;
                    }
                    String fn = fmt.name().toUpperCase() + "_" + cod.name().toUpperCase();
                    Path p = new Path(root, fn);
                    if (rwop == RW.r && !fs.exists(p)) {
                        fn = fn + cod.getExt();
                    }
                    System.out.print(rwop.name().toUpperCase() + " " + fn + ": ");
                    System.out.println(rwop.exec(fn, job) / 1000L + " seconds");
                }
            }
        }
        return 0;
    }

    public static <T extends Enum<T>> EnumSet<T> rem(Class<T> c, EnumSet<T> set, String s) {
        if (null != fullmap.get(c) && ((Map)fullmap.get(c)).get(s) != null) {
            if (null == set) {
                set = EnumSet.allOf(c);
            }
            set.remove(((Map)fullmap.get(c)).get(s));
        }
        return set;
    }

    public static <T extends Enum<T>> EnumSet<T> add(Class<T> c, EnumSet<T> set, String s) {
        if (null != fullmap.get(c) && ((Map)fullmap.get(c)).get(s) != null) {
            if (null == set) {
                set = EnumSet.noneOf(c);
            }
            set.add((Enum)((Map)fullmap.get(c)).get(s));
        }
        return set;
    }

    static {
        sentence = new StringBuilder();
        fullmap = new HashMap();
        HashMap<String, CCodec> m1 = new HashMap<String, CCodec>();
        for (CCodec v : CCodec.values()) {
            m1.put(v.name(), v);
        }
        fullmap.put(CCodec.class, m1);
        HashMap<String, CType> m2 = new HashMap<String, CType>();
        for (CType v : CType.values()) {
            m2.put(v.name(), v);
        }
        fullmap.put(CType.class, m2);
        HashMap<String, Format> m3 = new HashMap<String, Format>();
        for (Format v : Format.values()) {
            m3.put(v.name(), v);
        }
        fullmap.put(Format.class, m3);
        HashMap<String, RW> m4 = new HashMap<String, RW>();
        for (RW v : RW.values()) {
            m4.put(v.name(), v);
        }
        fullmap.put(RW.class, m4);
        words = new String[]{"diurnalness", "Homoiousian", "spiranthic", "tetragynian", "silverhead", "ungreat", "lithograph", "exploiter", "physiologian", "by", "hellbender", "Filipendula", "undeterring", "antiscolic", "pentagamist", "hypoid", "cacuminal", "sertularian", "schoolmasterism", "nonuple", "gallybeggar", "phytonic", "swearingly", "nebular", "Confervales", "thermochemically", "characinoid", "cocksuredom", "fallacious", "feasibleness", "debromination", "playfellowship", "tramplike", "testa", "participatingly", "unaccessible", "bromate", "experientialist", "roughcast", "docimastical", "choralcelo", "blightbird", "peptonate", "sombreroed", "unschematized", "antiabolitionist", "besagne", "mastication", "bromic", "sviatonosite", "cattimandoo", "metaphrastical", "endotheliomyoma", "hysterolysis", "unfulminated", "Hester", "oblongly", "blurredness", "authorling", "chasmy", "Scorpaenidae", "toxihaemia", "Dictograph", "Quakerishly", "deaf", "timbermonger", "strammel", "Thraupidae", "seditious", "plerome", "Arneb", "eristically", "serpentinic", "glaumrie", "socioromantic", "apocalypst", "tartrous", "Bassaris", "angiolymphoma", "horsefly", "kenno", "astronomize", "euphemious", "arsenide", "untongued", "parabolicness", "uvanite", "helpless", "gemmeous", "stormy", "templar", "erythrodextrin", "comism", "interfraternal", "preparative", "parastas", "frontoorbital", "Ophiosaurus", "diopside", "serosanguineous", "ununiformly", "karyological", "collegian", "allotropic", "depravity", "amylogenesis", "reformatory", "epidymides", "pleurotropous", "trillium", "dastardliness", "coadvice", "embryotic", "benthonic", "pomiferous", "figureheadship", "Megaluridae", "Harpa", "frenal", "commotion", "abthainry", "cobeliever", "manilla", "spiciferous", "nativeness", "obispo", "monilioid", "biopsic", "valvula", "enterostomy", "planosubulate", "pterostigma", "lifter", "triradiated", "venialness", "tum", "archistome", "tautness", "unswanlike", "antivenin", "Lentibulariaceae", "Triphora", "angiopathy", "anta", "Dawsonia", "becomma", "Yannigan", "winterproof", "antalgol", "harr", "underogating", "ineunt", "cornberry", "flippantness", "scyphostoma", "approbation", "Ghent", "Macraucheniidae", "scabbiness", "unanatomized", "photoelasticity", "eurythermal", "enation", "prepavement", "flushgate", "subsequentially", "Edo", "antihero", "Isokontae", "unforkedness", "porriginous", "daytime", "nonexecutive", "trisilicic", "morphiomania", "paranephros", "botchedly", "impugnation", "Dodecatheon", "obolus", "unburnt", "provedore", "Aktistetae", "superindifference", "Alethea", "Joachimite", "cyanophilous", "chorograph", "brooky", "figured", "periclitation", "quintette", "hondo", "ornithodelphous", "unefficient", "pondside", "bogydom", "laurinoxylon", "Shiah", "unharmed", "cartful", "noncrystallized", "abusiveness", "cromlech", "japanned", "rizzomed", "underskin", "adscendent", "allectory", "gelatinousness", "volcano", "uncompromisingly", "cubit", "idiotize", "unfurbelowed", "undinted", "magnetooptics", "Savitar", "diwata", "ramosopalmate", "Pishquow", "tomorn", "apopenptic", "Haversian", "Hysterocarpus", "ten", "outhue", "Bertat", "mechanist", "asparaginic", "velaric", "tonsure", "bubble", "Pyrales", "regardful", "glyphography", "calabazilla", "shellworker", "stradametrical", "havoc", "theologicopolitical", "sawdust", "diatomaceous", "jajman", "temporomastoid", "Serrifera", "Ochnaceae", "aspersor", "trailmaking", "Bishareen", "digitule", "octogynous", "epididymitis", "smokefarthings", "bacillite", "overcrown", "mangonism", "sirrah", "undecorated", "psychofugal", "bismuthiferous", "rechar", "Lemuridae", "frameable", "thiodiazole", "Scanic", "sportswomanship", "interruptedness", "admissory", "osteopaedion", "tingly", "tomorrowness", "ethnocracy", "trabecular", "vitally", "fossilism", "adz", "metopon", "prefatorial", "expiscate", "diathermacy", "chronist", "nigh", "generalizable", "hysterogen", "aurothiosulphuric", "whitlowwort", "downthrust", "Protestantize", "monander", "Itea", "chronographic", "silicize", "Dunlop", "eer", "componental", "spot", "pamphlet", "antineuritic", "paradisean", "interruptor", "debellator", "overcultured", "Florissant", "hyocholic", "pneumatotherapy", "tailoress", "rave", "unpeople", "Sebastian", "thermanesthesia", "Coniferae", "swacking", "posterishness", "ethmopalatal", "whittle", "analgize", "scabbardless", "naught", "symbiogenetically", "trip", "parodist", "columniform", "trunnel", "yawler", "goodwill", "pseudohalogen", "swangy", "cervisial", "mediateness", "genii", "imprescribable", "pony", "consumptional", "carposporangial", "poleax", "bestill", "subfebrile", "sapphiric", "arrowworm", "qualminess", "ultraobscure", "thorite", "Fouquieria", "Bermudian", "prescriber", "elemicin", "warlike", "semiangle", "rotular", "misthread", "returnability", "seraphism", "precostal", "quarried", "Babylonism", "sangaree", "seelful", "placatory", "pachydermous", "bozal", "galbulus", "spermaphyte", "cumbrousness", "pope", "signifier", "Endomycetaceae", "shallowish", "sequacity", "periarthritis", "bathysphere", "pentosuria", "Dadaism", "spookdom", "Consolamentum", "afterpressure", "mutter", "louse", "ovoviviparous", "corbel", "metastoma", "biventer", "Hydrangea", "hogmace", "seizing", "nonsuppressed", "oratorize", "uncarefully", "benzothiofuran", "penult", "balanocele", "macropterous", "dishpan", "marten", "absvolt", "jirble", "parmelioid", "airfreighter", "acocotl", "archesporial", "hypoplastral", "preoral", "quailberry", "cinque", "terrestrially", "stroking", "limpet", "moodishness", "canicule", "archididascalian", "pompiloid", "overstaid", "introducer", "Italical", "Christianopaganism", "prescriptible", "subofficer", "danseuse", "cloy", "saguran", "frictionlessly", "deindividualization", "Bulanda", "ventricous", "subfoliar", "basto", "scapuloradial", "suspend", "stiffish", "Sphenodontidae", "eternal", "verbid", "mammonish", "upcushion", "barkometer", "concretion", "preagitate", "incomprehensible", "tristich", "visceral", "hemimelus", "patroller", "stentorophonic", "pinulus", "kerykeion", "brutism", "monstership", "merciful", "overinstruct", "defensibly", "bettermost", "splenauxe", "Mormyrus", "unreprimanded", "taver", "ell", "proacquittal", "infestation", "overwoven", "Lincolnlike", "chacona", "Tamil", "classificational", "lebensraum", "reeveland", "intuition", "Whilkut", "focaloid", "Eleusinian", "micromembrane", "byroad", "nonrepetition", "bacterioblast", "brag", "ribaldrous", "phytoma", "counteralliance", "pelvimetry", "pelf", "relaster", "thermoresistant", "aneurism", "molossic", "euphonym", "upswell", "ladhood", "phallaceous", "inertly", "gunshop", "stereotypography", "laryngic", "refasten", "twinling", "oflete", "hepatorrhaphy", "electrotechnics", "cockal", "guitarist", "topsail", "Cimmerianism", "larklike", "Llandovery", "pyrocatechol", "immatchable", "chooser", "metrocratic", "craglike", "quadrennial", "nonpoisonous", "undercolored", "knob", "ultratense", "balladmonger", "slait", "sialadenitis", "bucketer", "magnificently", "unstipulated", "unscourged", "unsupercilious", "packsack", "pansophism", "soorkee", "percent", "subirrigate", "champer", "metapolitics", "spherulitic", "involatile", "metaphonical", "stachyuraceous", "speckedness", "bespin", "proboscidiform", "gul", "squit", "yeelaman", "peristeropode", "opacousness", "shibuichi", "retinize", "yote", "misexposition", "devilwise", "pumpkinification", "vinny", "bonze", "glossing", "decardinalize", "transcortical", "serphoid", "deepmost", "guanajuatite", "wemless", "arval", "lammy", "Effie", "Saponaria", "tetrahedral", "prolificy", "excerpt", "dunkadoo", "Spencerism", "insatiately", "Gilaki", "oratorship", "arduousness", "unbashfulness", "Pithecolobium", "unisexuality", "veterinarian", "detractive", "liquidity", "acidophile", "proauction", "sural", "totaquina", "Vichyite", "uninhabitedness", "allegedly", "Gothish", "manny", "Inger", "flutist", "ticktick", "Ludgatian", "homotransplant", "orthopedical", "diminutively", "monogoneutic", "Kenipsim", "sarcologist", "drome", "stronghearted", "Fameuse", "Swaziland", "alen", "chilblain", "beatable", "agglomeratic", "constitutor", "tendomucoid", "porencephalous", "arteriasis", "boser", "tantivy", "rede", "lineamental", "uncontradictableness", "homeotypical", "masa", "folious", "dosseret", "neurodegenerative", "subtransverse", "Chiasmodontidae", "palaeotheriodont", "unstressedly", "chalcites", "piquantness", "lampyrine", "Aplacentalia", "projecting", "elastivity", "isopelletierin", "bladderwort", "strander", "almud", "iniquitously", "theologal", "bugre", "chargeably", "imperceptivity", "meriquinoidal", "mesophyte", "divinator", "perfunctory", "counterappellant", "synovial", "charioteer", "crystallographical", "comprovincial", "infrastapedial", "pleasurehood", "inventurous", "ultrasystematic", "subangulated", "supraoesophageal", "Vaishnavism", "transude", "chrysochrous", "ungrave", "reconciliable", "uninterpleaded", "erlking", "wherefrom", "aprosopia", "antiadiaphorist", "metoxazine", "incalculable", "umbellic", "predebit", "foursquare", "unimmortal", "nonmanufacture", "slangy", "predisputant", "familist", "preaffiliate", "friarhood", "corelysis", "zoonitic", "halloo", "paunchy", "neuromimesis", "aconitine", "hackneyed", "unfeeble", "cubby", "autoschediastical", "naprapath", "lyrebird", "inexistency", "leucophoenicite", "ferrogoslarite", "reperuse", "uncombable", "tambo", "propodiale", "diplomatize", "Russifier", "clanned", "corona", "michigan", "nonutilitarian", "transcorporeal", "bought", "Cercosporella", "stapedius", "glandularly", "pictorially", "weism", "disilane", "rainproof", "Caphtor", "scrubbed", "oinomancy", "pseudoxanthine", "nonlustrous", "redesertion", "Oryzorictinae", "gala", "Mycogone", "reappreciate", "cyanoguanidine", "seeingness", "breadwinner", "noreast", "furacious", "epauliere", "omniscribent", "Passiflorales", "uninductive", "inductivity", "Orbitolina", "Semecarpus", "migrainoid", "steprelationship", "phlogisticate", "mesymnion", "sloped", "edificator", "beneficent", "culm", "paleornithology", "unurban", "throbless", "amplexifoliate", "sesquiquintile", "sapience", "astucious", "dithery", "boor", "ambitus", "scotching", "uloid", "uncompromisingness", "hoove", "waird", "marshiness", "Jerusalem", "mericarp", "unevoked", "benzoperoxide", "outguess", "pyxie", "hymnic", "euphemize", "mendacity", "erythremia", "rosaniline", "unchatteled", "lienteria", "Bushongo", "dialoguer", "unrepealably", "rivethead", "antideflation", "vinegarish", "manganosiderite", "doubtingness", "ovopyriform", "Cephalodiscus", "Muscicapa", "Animalivora", "angina", "planispheric", "ipomoein", "cuproiodargyrite", "sandbox", "scrat", "Munnopsidae", "shola", "pentafid", "overstudiousness", "times", "nonprofession", "appetible", "valvulotomy", "goladar", "uniarticular", "oxyterpene", "unlapsing", "omega", "trophonema", "seminonflammable", "circumzenithal", "starer", "depthwise", "liberatress", "unleavened", "unrevolting", "groundneedle", "topline", "wandoo", "umangite", "ordinant", "unachievable", "oversand", "snare", "avengeful", "unexplicit", "mustafina", "sonable", "rehabilitative", "eulogization", "papery", "technopsychology", "impressor", "cresylite", "entame", "transudatory", "scotale", "pachydermatoid", "imaginary", "yeat", "slipped", "stewardship", "adatom", "cockstone", "skyshine", "heavenful", "comparability", "exprobratory", "dermorhynchous", "parquet", "cretaceous", "vesperal", "raphis", "undangered", "Glecoma", "engrain", "counteractively", "Zuludom", "orchiocatabasis", "Auriculariales", "warriorwise", "extraorganismal", "overbuilt", "alveolite", "tetchy", "terrificness", "widdle", "unpremonished", "rebilling", "sequestrum", "equiconvex", "heliocentricism", "catabaptist", "okonite", "propheticism", "helminthagogic", "calycular", "giantly", "wingable", "golem", "unprovided", "commandingness", "greave", "haply", "doina", "depressingly", "subdentate", "impairment", "decidable", "neurotrophic", "unpredict", "bicorporeal", "pendulant", "flatman", "intrabred", "toplike", "Prosobranchiata", "farrantly", "toxoplasmosis", "gorilloid", "dipsomaniacal", "aquiline", "atlantite", "ascitic", "perculsive", "prospectiveness", "saponaceous", "centrifugalization", "dinical", "infravaginal", "beadroll", "affaite", "Helvidian", "tickleproof", "abstractionism", "enhedge", "outwealth", "overcontribute", "coldfinch", "gymnastic", "Pincian", "Munychian", "codisjunct", "quad", "coracomandibular", "phoenicochroite", "amender", "selectivity", "putative", "semantician", "lophotrichic", "Spatangoidea", "saccharogenic", "inferent", "Triconodonta", "arrendation", "sheepskin", "taurocolla", "bunghole", "Machiavel", "triakistetrahedral", "dehairer", "prezygapophysial", "cylindric", "pneumonalgia", "sleigher", "emir", "Socraticism", "licitness", "massedly", "instructiveness", "sturdied", "redecrease", "starosta", "evictor", "orgiastic", "squdge", "meloplasty", "Tsonecan", "repealableness", "swoony", "myesthesia", "molecule", "autobiographist", "reciprocation", "refective", "unobservantness", "tricae", "ungouged", "floatability", "Mesua", "fetlocked", "chordacentrum", "sedentariness", "various", "laubanite", "nectopod", "zenick", "sequentially", "analgic", "biodynamics", "posttraumatic", "nummi", "pyroacetic", "bot", "redescend", "dispermy", "undiffusive", "circular", "trillion", "Uraniidae", "ploration", "discipular", "potentness", "sud", "Hu", "Eryon", "plugger", "subdrainage", "jharal", "abscission", "supermarket", "countergabion", "glacierist", "lithotresis", "minniebush", "zanyism", "eucalypteol", "sterilely", "unrealize", "unpatched", "hypochondriacism", "critically", "cheesecutter"};
    }
}

