/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationAttemptId
implements Comparable<ApplicationAttemptId> {
    static final ThreadLocal<NumberFormat> attemptIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(6);
            return fmt;
        }
    };

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationId getApplicationId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationId(ApplicationId var1);

    public abstract int getAttemptId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAttemptId(int var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        ApplicationId appId = this.getApplicationId();
        result = 31 * result + appId.hashCode();
        result = 31 * result + this.getAttemptId();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationAttemptId other = (ApplicationAttemptId)obj;
        if (!this.getApplicationId().equals(other.getApplicationId())) {
            return false;
        }
        return this.getAttemptId() == other.getAttemptId();
    }

    @Override
    public int compareTo(ApplicationAttemptId other) {
        int compareAppIds = this.getApplicationId().compareTo(other.getApplicationId());
        if (compareAppIds == 0) {
            return this.getAttemptId() - other.getAttemptId();
        }
        return compareAppIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("appattempt_");
        sb.append(this.getApplicationId().getClusterTimestamp()).append("_");
        sb.append(ApplicationId.appIdFormat.get().format(this.getApplicationId().getId()));
        sb.append("_").append(attemptIdFormat.get().format(this.getAttemptId()));
        return sb.toString();
    }
}

