/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationId
implements Comparable<ApplicationId> {
    static final ThreadLocal<NumberFormat> appIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(4);
            return fmt;
        }
    };

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setId(int var1);

    public abstract long getClusterTimestamp();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setClusterTimestamp(long var1);

    @Override
    public int compareTo(ApplicationId other) {
        if (this.getClusterTimestamp() - other.getClusterTimestamp() == 0L) {
            return this.getId() - other.getId();
        }
        return this.getClusterTimestamp() > other.getClusterTimestamp() ? 1 : (this.getClusterTimestamp() < other.getClusterTimestamp() ? -1 : 0);
    }

    public String toString() {
        return "application_" + this.getClusterTimestamp() + "_" + appIdFormat.get().format(this.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long clusterTimestamp = this.getClusterTimestamp();
        result = 31 * result + (int)(clusterTimestamp ^ clusterTimestamp >>> 32);
        result = 31 * result + this.getId();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationId other = (ApplicationId)obj;
        if (this.getClusterTimestamp() != other.getClusterTimestamp()) {
            return false;
        }
        return this.getId() == other.getId();
    }
}

