/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.exceptions.impl.pb;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class YarnRemoteExceptionPBImpl
extends YarnRemoteException {
    private static final long serialVersionUID = 1L;
    YarnProtos.YarnRemoteExceptionProto proto = YarnProtos.YarnRemoteExceptionProto.getDefaultInstance();
    YarnProtos.YarnRemoteExceptionProto.Builder builder = null;
    boolean viaProto = false;

    public YarnRemoteExceptionPBImpl() {
    }

    public YarnRemoteExceptionPBImpl(YarnProtos.YarnRemoteExceptionProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnRemoteExceptionPBImpl(String message) {
        super(message);
        this.maybeInitBuilder();
        this.builder.setMessage(super.getMessage());
    }

    public YarnRemoteExceptionPBImpl(Throwable t) {
        super(t);
        this.maybeInitBuilder();
        if (t.getCause() != null) {
            this.builder.setCause(new YarnRemoteExceptionPBImpl(t.getCause()).getProto());
            this.builder.setClassName(t.getClass().getName());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        if (sw.toString() != null) {
            this.builder.setTrace(sw.toString());
        }
        if (t.getMessage() != null) {
            this.builder.setMessage(t.getMessage());
        }
    }

    public YarnRemoteExceptionPBImpl(String message, Throwable t) {
        this(t);
        if (message != null) {
            this.builder.setMessage(message);
        }
    }

    @Override
    public String getMessage() {
        YarnProtos.YarnRemoteExceptionProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getMessage();
    }

    @Override
    public String getRemoteTrace() {
        YarnProtos.YarnRemoteExceptionProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getTrace();
    }

    @Override
    public YarnRemoteException getCause() {
        YarnProtos.YarnRemoteExceptionProtoOrBuilder p;
        YarnProtos.YarnRemoteExceptionProtoOrBuilder yarnRemoteExceptionProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (p.hasCause()) {
            return new YarnRemoteExceptionPBImpl(p.getCause());
        }
        return null;
    }

    public YarnProtos.YarnRemoteExceptionProto getProto() {
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.YarnRemoteExceptionProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    public static YarnRemoteException unwrapAndThrowException(ServiceException se) throws UndeclaredThrowableException {
        if (se.getCause() instanceof RemoteException) {
            try {
                throw ((RemoteException)se.getCause()).unwrapRemoteException(new Class[]{YarnRemoteExceptionPBImpl.class});
            }
            catch (YarnRemoteException ex) {
                return ex;
            }
            catch (IOException e1) {
                throw new UndeclaredThrowableException(e1);
            }
        }
        if (se.getCause() instanceof YarnRemoteException) {
            return (YarnRemoteException)se.getCause();
        }
        if (se.getCause() instanceof UndeclaredThrowableException) {
            throw (UndeclaredThrowableException)se.getCause();
        }
        throw new UndeclaredThrowableException((Throwable)se);
    }
}

