/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.PrintWriter;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class NodeCLI
extends YarnCLI {
    private static final String NODES_PATTERN = "%16s\t%10s\t%17s\t%26s\t%18s\n";

    public static void main(String[] args) throws Exception {
        NodeCLI cli = new NodeCLI();
        cli.setSysOutPrintStream(System.out);
        cli.setSysErrPrintStream(System.err);
        int res = ToolRunner.run((Tool)cli, (String[])args);
        cli.stop();
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options opts = new Options();
        opts.addOption("status", true, "Prints the status report of the node.");
        opts.addOption("list", false, "Lists all the nodes.");
        CommandLine cliParser = new GnuParser().parse(opts, args);
        int exitCode = -1;
        if (cliParser.hasOption("status")) {
            if (args.length != 2) {
                this.printUsage(opts);
                return exitCode;
            }
            this.printNodeStatus(cliParser.getOptionValue("status"));
        } else if (cliParser.hasOption("list")) {
            this.listClusterNodes();
        } else {
            this.syserr.println("Invalid Command Usage : ");
            this.printUsage(opts);
        }
        return 0;
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("node", opts);
    }

    private void listClusterNodes() throws YarnRemoteException {
        PrintWriter writer = new PrintWriter(this.sysout);
        List<NodeReport> nodesReport = this.client.getNodeReports();
        writer.println("Total Nodes:" + nodesReport.size());
        writer.printf(NODES_PATTERN, "Node-Id", "Node-State", "Node-Http-Address", "Health-Status(isNodeHealthy)", "Running-Containers");
        for (NodeReport nodeReport : nodesReport) {
            writer.printf(NODES_PATTERN, nodeReport.getNodeId(), nodeReport.getNodeState(), nodeReport.getHttpAddress(), nodeReport.getNodeHealthStatus().getIsNodeHealthy(), nodeReport.getNumContainers());
        }
        writer.flush();
    }

    private void printNodeStatus(String nodeIdStr) throws YarnRemoteException {
        NodeId nodeId = ConverterUtils.toNodeId((String)nodeIdStr);
        List<NodeReport> nodesReport = this.client.getNodeReports();
        StringBuffer nodeReportStr = new StringBuffer();
        NodeReport nodeReport = null;
        for (NodeReport report : nodesReport) {
            if (!report.getNodeId().equals((Object)nodeId)) continue;
            nodeReport = report;
            nodeReportStr.append("Node Report : ");
            nodeReportStr.append("\n\tNode-Id : ");
            nodeReportStr.append(nodeReport.getNodeId());
            nodeReportStr.append("\n\tRack : ");
            nodeReportStr.append(nodeReport.getRackName());
            nodeReportStr.append("\n\tNode-State : ");
            nodeReportStr.append(nodeReport.getNodeState());
            nodeReportStr.append("\n\tNode-Http-Address : ");
            nodeReportStr.append(nodeReport.getHttpAddress());
            nodeReportStr.append("\n\tHealth-Status(isNodeHealthy) : ");
            nodeReportStr.append(nodeReport.getNodeHealthStatus().getIsNodeHealthy());
            nodeReportStr.append("\n\tLast-Last-Health-Update : ");
            nodeReportStr.append(nodeReport.getNodeHealthStatus().getLastHealthReportTime());
            nodeReportStr.append("\n\tHealth-Report : ");
            nodeReportStr.append(nodeReport.getNodeHealthStatus().getHealthReport());
            nodeReportStr.append("\n\tContainers : ");
            nodeReportStr.append(nodeReport.getNumContainers());
            nodeReportStr.append("\n\tMemory-Used : ");
            nodeReportStr.append(nodeReport.getUsed() == null ? "0M" : nodeReport.getUsed().getMemory() + "M");
            nodeReportStr.append("\n\tMemory-Capacity : ");
            nodeReportStr.append(nodeReport.getCapability().getMemory());
        }
        if (nodeReport == null) {
            nodeReportStr.append("Could not find the node report for node id : " + nodeIdStr);
        }
        this.sysout.println(nodeReportStr.toString());
    }
}

