/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class NodeCLI
extends YarnCLI {
    private static final String NODES_PATTERN = "%16s\t%10s\t%17s\t%26s\t%18s" + System.getProperty("line.separator");

    public static void main(String[] args) throws Exception {
        NodeCLI cli = new NodeCLI();
        cli.setSysOutPrintStream(System.out);
        cli.setSysErrPrintStream(System.err);
        int res = ToolRunner.run((Tool)cli, (String[])args);
        cli.stop();
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options opts = new Options();
        opts.addOption("status", true, "Prints the status report of the node.");
        opts.addOption("list", false, "Lists all the nodes.");
        CommandLine cliParser = new GnuParser().parse(opts, args);
        int exitCode = -1;
        if (cliParser.hasOption("status")) {
            if (args.length != 2) {
                this.printUsage(opts);
                return exitCode;
            }
            this.printNodeStatus(cliParser.getOptionValue("status"));
        } else if (cliParser.hasOption("list")) {
            this.listClusterNodes();
        } else {
            this.syserr.println("Invalid Command Usage : ");
            this.printUsage(opts);
        }
        return 0;
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("node", opts);
    }

    private void listClusterNodes() throws YarnRemoteException {
        PrintWriter writer = new PrintWriter(this.sysout);
        List<NodeReport> nodesReport = this.client.getNodeReports();
        writer.println("Total Nodes:" + nodesReport.size());
        writer.printf(NODES_PATTERN, "Node-Id", "Node-State", "Node-Http-Address", "Health-Status(isNodeHealthy)", "Running-Containers");
        for (NodeReport nodeReport : nodesReport) {
            writer.printf(NODES_PATTERN, nodeReport.getNodeId(), nodeReport.getNodeState(), nodeReport.getHttpAddress(), nodeReport.getNodeHealthStatus().getIsNodeHealthy(), nodeReport.getNumContainers());
        }
        writer.flush();
    }

    private void printNodeStatus(String nodeIdStr) throws YarnRemoteException, IOException {
        NodeId nodeId = ConverterUtils.toNodeId((String)nodeIdStr);
        List<NodeReport> nodesReport = this.client.getNodeReports();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter nodeReportStr = new PrintWriter(baos);
        NodeReport nodeReport = null;
        for (NodeReport report : nodesReport) {
            if (!report.getNodeId().equals((Object)nodeId)) continue;
            nodeReport = report;
            nodeReportStr.println("Node Report : ");
            nodeReportStr.print("\tNode-Id : ");
            nodeReportStr.println(nodeReport.getNodeId());
            nodeReportStr.print("\tRack : ");
            nodeReportStr.println(nodeReport.getRackName());
            nodeReportStr.print("\tNode-State : ");
            nodeReportStr.println(nodeReport.getNodeState());
            nodeReportStr.print("\tNode-Http-Address : ");
            nodeReportStr.println(nodeReport.getHttpAddress());
            nodeReportStr.print("\tHealth-Status(isNodeHealthy) : ");
            nodeReportStr.println(nodeReport.getNodeHealthStatus().getIsNodeHealthy());
            nodeReportStr.print("\tLast-Health-Update : ");
            nodeReportStr.println(DateFormatUtils.format((Date)new Date(nodeReport.getNodeHealthStatus().getLastHealthReportTime()), (String)"E dd/MMM/yy hh:mm:ss:SSzz"));
            nodeReportStr.print("\tHealth-Report : ");
            nodeReportStr.println(nodeReport.getNodeHealthStatus().getHealthReport());
            nodeReportStr.print("\tContainers : ");
            nodeReportStr.println(nodeReport.getNumContainers());
            nodeReportStr.print("\tMemory-Used : ");
            nodeReportStr.println(nodeReport.getUsed() == null ? "0M" : nodeReport.getUsed().getMemory() + "M");
            nodeReportStr.print("\tMemory-Capacity : ");
            nodeReportStr.println(nodeReport.getCapability().getMemory());
        }
        if (nodeReport == null) {
            nodeReportStr.print("Could not find the node report for node id : " + nodeIdStr);
        }
        nodeReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
    }
}

