/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ContainerManager;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerRequest;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.client.NMClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.util.ProtoUtils;
import org.apache.hadoop.yarn.util.Records;

public class NMClientImpl
extends AbstractService
implements NMClient {
    private static final Log LOG = LogFactory.getLog(NMClientImpl.class);
    protected ConcurrentMap<ContainerId, StartedContainer> startedContainers = new ConcurrentHashMap<ContainerId, StartedContainer>();
    protected final AtomicBoolean cleanupRunningContainers = new AtomicBoolean(true);

    public NMClientImpl() {
        super(NMClientImpl.class.getName());
    }

    public NMClientImpl(String name) {
        super(name);
    }

    protected void serviceStop() throws Exception {
        if (this.cleanupRunningContainers.get()) {
            this.cleanupRunningContainers();
        }
        super.serviceStop();
    }

    protected synchronized void cleanupRunningContainers() {
        for (StartedContainer startedContainer : this.startedContainers.values()) {
            try {
                this.stopContainer(startedContainer.getContainerId(), startedContainer.getNodeId(), startedContainer.getContainerToken());
            }
            catch (YarnException e) {
                LOG.error((Object)("Failed to stop Container " + startedContainer.getContainerId() + "when stopping NMClientImpl"));
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to stop Container " + startedContainer.getContainerId() + "when stopping NMClientImpl"));
            }
        }
    }

    @Override
    public void cleanupRunningContainersOnStop(boolean enabled) {
        this.cleanupRunningContainers.set(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ByteBuffer> startContainer(Container container, ContainerLaunchContext containerLaunchContext) throws YarnException, IOException {
        StartedContainer startedContainer = this.addStartedContainer(container);
        synchronized (startedContainer) {
            Map<String, ByteBuffer> allServiceResponse;
            NMCommunicator nmCommunicator = null;
            try {
                nmCommunicator = new NMCommunicator(container.getId(), container.getNodeId(), container.getContainerToken());
                nmCommunicator.init(this.getConfig());
                nmCommunicator.start();
                allServiceResponse = nmCommunicator.startContainer(container, containerLaunchContext);
            }
            catch (YarnException e) {
                this.removeStartedContainer(container.getId());
                throw e;
            }
            catch (IOException e) {
                this.removeStartedContainer(container.getId());
                throw e;
            }
            catch (Throwable t) {
                this.removeStartedContainer(container.getId());
                throw RPCUtil.getRemoteException((Throwable)t);
            }
            finally {
                if (nmCommunicator != null) {
                    nmCommunicator.stop();
                }
            }
            return allServiceResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopContainer(ContainerId containerId, NodeId nodeId, org.apache.hadoop.yarn.api.records.Token containerToken) throws YarnException, IOException {
        StartedContainer startedContainer = this.getStartedContainer(containerId);
        if (startedContainer == null) {
            throw RPCUtil.getRemoteException((String)("Container " + containerId + " is either not started yet or already stopped"));
        }
        StartedContainer startedContainer2 = startedContainer;
        synchronized (startedContainer2) {
            if (startedContainer.stopped) {
                return;
            }
            NMCommunicator nmCommunicator = null;
            try {
                nmCommunicator = new NMCommunicator(containerId, nodeId, containerToken);
                nmCommunicator.init(this.getConfig());
                nmCommunicator.start();
                nmCommunicator.stopContainer();
            }
            finally {
                if (nmCommunicator != null) {
                    nmCommunicator.stop();
                }
                startedContainer.stopped = true;
                this.removeStartedContainer(containerId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerStatus getContainerStatus(ContainerId containerId, NodeId nodeId, org.apache.hadoop.yarn.api.records.Token containerToken) throws YarnException, IOException {
        NMCommunicator nmCommunicator = null;
        try {
            ContainerStatus containerStatus;
            nmCommunicator = new NMCommunicator(containerId, nodeId, containerToken);
            nmCommunicator.init(this.getConfig());
            nmCommunicator.start();
            ContainerStatus containerStatus2 = containerStatus = nmCommunicator.getContainerStatus();
            return containerStatus2;
        }
        finally {
            if (nmCommunicator != null) {
                nmCommunicator.stop();
            }
        }
    }

    protected synchronized StartedContainer addStartedContainer(Container container) throws YarnException, IOException {
        if (this.startedContainers.containsKey(container.getId())) {
            throw RPCUtil.getRemoteException((String)("Container " + container.getId() + " is already started"));
        }
        StartedContainer startedContainer = new StartedContainer(container.getId(), container.getNodeId(), container.getContainerToken());
        this.startedContainers.put(startedContainer.getContainerId(), startedContainer);
        return startedContainer;
    }

    protected synchronized void removeStartedContainer(ContainerId containerId) {
        this.startedContainers.remove(containerId);
    }

    protected synchronized StartedContainer getStartedContainer(ContainerId containerId) {
        return (StartedContainer)this.startedContainers.get(containerId);
    }

    protected static final class NMCommunicator
    extends AbstractService {
        private ContainerId containerId;
        private NodeId nodeId;
        private org.apache.hadoop.yarn.api.records.Token containerToken;
        private ContainerManager containerManager;

        public NMCommunicator(ContainerId containerId, NodeId nodeId, org.apache.hadoop.yarn.api.records.Token containerToken) {
            super(NMCommunicator.class.getName());
            this.containerId = containerId;
            this.nodeId = nodeId;
            this.containerToken = containerToken;
        }

        protected void serviceStart() throws Exception {
            final YarnRPC rpc = YarnRPC.create((Configuration)this.getConfig());
            final InetSocketAddress containerAddress = NetUtils.createSocketAddr((String)this.nodeId.toString());
            UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)this.containerId.toString());
            Token token = ProtoUtils.convertFromProtoFormat((org.apache.hadoop.yarn.api.records.Token)this.containerToken, (InetSocketAddress)containerAddress);
            currentUser.addToken(token);
            this.containerManager = (ContainerManager)currentUser.doAs((PrivilegedAction)new PrivilegedAction<ContainerManager>(){

                @Override
                public ContainerManager run() {
                    return (ContainerManager)rpc.getProxy(ContainerManager.class, containerAddress, NMCommunicator.this.getConfig());
                }
            });
            LOG.debug((Object)("Connecting to ContainerManager at " + containerAddress));
            super.serviceStart();
        }

        protected void serviceStop() throws Exception {
            if (this.containerManager != null) {
                RPC.stopProxy((Object)this.containerManager);
                if (LOG.isDebugEnabled()) {
                    InetSocketAddress containerAddress = NetUtils.createSocketAddr((String)this.nodeId.toString());
                    LOG.debug((Object)("Disconnecting from ContainerManager at " + containerAddress));
                }
            }
            super.serviceStop();
        }

        public synchronized Map<String, ByteBuffer> startContainer(Container container, ContainerLaunchContext containerLaunchContext) throws YarnException, IOException {
            if (!container.getId().equals((Object)this.containerId)) {
                throw new IllegalArgumentException("NMCommunicator's containerId  mismatches the given Container's");
            }
            StartContainerResponse startResponse = null;
            try {
                StartContainerRequest startRequest = (StartContainerRequest)Records.newRecord(StartContainerRequest.class);
                startRequest.setContainerToken(container.getContainerToken());
                startRequest.setContainerLaunchContext(containerLaunchContext);
                startResponse = this.containerManager.startContainer(startRequest);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Started Container " + this.containerId));
                }
            }
            catch (YarnException e) {
                LOG.warn((Object)("Container " + this.containerId + " failed to start"), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                LOG.warn((Object)("Container " + this.containerId + " failed to start"), (Throwable)e);
                throw e;
            }
            return startResponse.getAllServiceResponse();
        }

        public synchronized void stopContainer() throws YarnException, IOException {
            try {
                StopContainerRequest stopRequest = (StopContainerRequest)Records.newRecord(StopContainerRequest.class);
                stopRequest.setContainerId(this.containerId);
                this.containerManager.stopContainer(stopRequest);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Stopped Container " + this.containerId));
                }
            }
            catch (YarnException e) {
                LOG.warn((Object)("Container " + this.containerId + " failed to stop"), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                LOG.warn((Object)("Container " + this.containerId + " failed to stop"), (Throwable)e);
                throw e;
            }
        }

        public synchronized ContainerStatus getContainerStatus() throws YarnException, IOException {
            GetContainerStatusResponse statusResponse = null;
            try {
                GetContainerStatusRequest statusRequest = (GetContainerStatusRequest)Records.newRecord(GetContainerStatusRequest.class);
                statusRequest.setContainerId(this.containerId);
                statusResponse = this.containerManager.getContainerStatus(statusRequest);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Got the status of Container " + this.containerId));
                }
            }
            catch (YarnException e) {
                LOG.warn((Object)("Unable to get the status of Container " + this.containerId), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to get the status of Container " + this.containerId), (Throwable)e);
                throw e;
            }
            return statusResponse.getStatus();
        }
    }

    protected static class StartedContainer {
        private ContainerId containerId;
        private NodeId nodeId;
        private org.apache.hadoop.yarn.api.records.Token containerToken;
        private boolean stopped;

        public StartedContainer(ContainerId containerId, NodeId nodeId, org.apache.hadoop.yarn.api.records.Token containerToken) {
            this.containerId = containerId;
            this.nodeId = nodeId;
            this.containerToken = containerToken;
            this.stopped = false;
        }

        public ContainerId getContainerId() {
            return this.containerId;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }

        public org.apache.hadoop.yarn.api.records.Token getContainerToken() {
            return this.containerToken;
        }
    }
}

