/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class YarnClient
extends AbstractService {
    @InterfaceAudience.Public
    public static YarnClient createYarnClient() {
        YarnClientImpl client = new YarnClientImpl();
        return client;
    }

    @InterfaceAudience.Public
    public static YarnClient createYarnClient(InetSocketAddress rmAddress) {
        YarnClientImpl client = new YarnClientImpl(rmAddress);
        return client;
    }

    @InterfaceAudience.Public
    public static YarnClient createYarnClient(String name, InetSocketAddress rmAddress) {
        YarnClientImpl client = new YarnClientImpl(name, rmAddress);
        return client;
    }

    @InterfaceAudience.Private
    protected YarnClient(String name) {
        super(name);
    }

    public abstract YarnClientApplication createApplication() throws YarnException, IOException;

    public abstract ApplicationId submitApplication(ApplicationSubmissionContext var1) throws YarnException, IOException;

    public abstract void killApplication(ApplicationId var1) throws YarnException, IOException;

    public abstract ApplicationReport getApplicationReport(ApplicationId var1) throws YarnException, IOException;

    public abstract List<ApplicationReport> getApplicationList() throws YarnException, IOException;

    public abstract YarnClusterMetrics getYarnClusterMetrics() throws YarnException, IOException;

    public abstract List<NodeReport> getNodeReports() throws YarnException, IOException;

    public abstract Token getRMDelegationToken(Text var1) throws YarnException, IOException;

    public abstract QueueInfo getQueueInfo(String var1) throws YarnException, IOException;

    public abstract List<QueueInfo> getAllQueues() throws YarnException, IOException;

    public abstract List<QueueInfo> getRootQueueInfos() throws YarnException, IOException;

    public abstract List<QueueInfo> getChildQueueInfos(String var1) throws YarnException, IOException;

    public abstract List<QueueUserACLInfo> getQueueAclsInfo() throws YarnException, IOException;
}

