/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class AMRMClient<T extends ContainerRequest>
extends AbstractService {
    @InterfaceAudience.Public
    public static <T extends ContainerRequest> AMRMClient<T> createAMRMClient() {
        AMRMClientImpl client = new AMRMClientImpl();
        return client;
    }

    @InterfaceAudience.Private
    protected AMRMClient(String name) {
        super(name);
    }

    public abstract RegisterApplicationMasterResponse registerApplicationMaster(String var1, int var2, String var3) throws YarnException, IOException;

    public abstract AllocateResponse allocate(float var1) throws YarnException, IOException;

    public abstract void unregisterApplicationMaster(FinalApplicationStatus var1, String var2, String var3) throws YarnException, IOException;

    public abstract void addContainerRequest(T var1);

    public abstract void removeContainerRequest(T var1);

    public abstract void releaseAssignedContainer(ContainerId var1);

    public abstract Resource getAvailableResources();

    public abstract int getClusterNodeCount();

    public abstract List<? extends Collection<T>> getMatchingRequests(Priority var1, String var2, Resource var3);

    public abstract void updateBlacklist(List<String> var1, List<String> var2);

    public static class ContainerRequest {
        final Resource capability;
        final List<String> nodes;
        final List<String> racks;
        final Priority priority;
        final boolean relaxLocality;

        public ContainerRequest(Resource capability, String[] nodes, String[] racks, Priority priority) {
            this(capability, nodes, racks, priority, true);
        }

        public ContainerRequest(Resource capability, String[] nodes, String[] racks, Priority priority, boolean relaxLocality) {
            Preconditions.checkArgument((capability != null ? 1 : 0) != 0, (Object)"The Resource to be requested for each container should not be null ");
            Preconditions.checkArgument((priority != null ? 1 : 0) != 0, (Object)"The priority at which to request containers should not be null ");
            Preconditions.checkArgument((relaxLocality || racks != null && racks.length != 0 || nodes != null && nodes.length != 0 ? 1 : 0) != 0, (Object)"Can't turn off locality relaxation on a request with no location constraints");
            this.capability = capability;
            this.nodes = nodes != null ? ImmutableList.copyOf((Object[])nodes) : null;
            this.racks = racks != null ? ImmutableList.copyOf((Object[])racks) : null;
            this.priority = priority;
            this.relaxLocality = relaxLocality;
        }

        public Resource getCapability() {
            return this.capability;
        }

        public List<String> getNodes() {
            return this.nodes;
        }

        public List<String> getRacks() {
            return this.racks;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public boolean getRelaxLocality() {
            return this.relaxLocality;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Capability[").append(this.capability).append("]");
            sb.append("Priority[").append(this.priority).append("]");
            return sb.toString();
        }
    }
}

