/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.AvroSpecificRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;

public class HadoopYarnRPC
extends YarnRPC {
    private static final Log LOG = LogFactory.getLog(HadoopYarnRPC.class);

    @Override
    public Object getProxy(Class protocol, InetSocketAddress addr, Configuration conf) {
        LOG.info((Object)("Creating a HadoopYarnRpc proxy for protocol " + protocol));
        RPC.setProtocolEngine((Configuration)conf, (Class)protocol, AvroSpecificRpcEngine.class);
        try {
            return RPC.getProxy((Class)protocol, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
        }
        catch (IOException e) {
            throw new YarnException(e);
        }
    }

    @Override
    public void stopProxy(Object proxy, Configuration conf) {
        RPC.stopProxy((Object)proxy);
    }

    @Override
    public Server getServer(Class protocol, Object instance, InetSocketAddress addr, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, int numHandlers) {
        RPC.Server hadoopServer;
        LOG.info((Object)("Creating a HadoopYarnRpc server for protocol " + protocol + " with " + numHandlers + " handlers"));
        RPC.setProtocolEngine((Configuration)conf, (Class)protocol, AvroSpecificRpcEngine.class);
        try {
            hadoopServer = RPC.getServer((Class)protocol, (Object)instance, (String)addr.getHostName(), (int)addr.getPort(), (int)numHandlers, (boolean)false, (Configuration)conf, secretManager);
        }
        catch (IOException e) {
            throw new YarnException(e);
        }
        return hadoopServer;
    }
}

