/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;

public class ApplicationTokenIdentifier
extends TokenIdentifier {
    public static final Text KIND_NAME = new Text("YARN_APPLICATION_TOKEN");
    private String applicationAttemptId;

    public ApplicationTokenIdentifier() {
    }

    public ApplicationTokenIdentifier(ApplicationAttemptId appAttemptId) {
        this();
        this.applicationAttemptId = appAttemptId.toString();
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.applicationAttemptId);
    }

    public void readFields(DataInput in) throws IOException {
        this.applicationAttemptId = Text.readString((DataInput)in);
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public UserGroupInformation getUser() {
        if (this.applicationAttemptId == null || "".equals(this.applicationAttemptId.toString())) {
            return null;
        }
        return UserGroupInformation.createRemoteUser((String)this.applicationAttemptId.toString());
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        protected Text getKind() {
            return KIND_NAME;
        }
    }
}

