/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import javax.crypto.SecretKey;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.security.ApplicationTokenIdentifier;

public class ApplicationTokenSecretManager
extends SecretManager<ApplicationTokenIdentifier> {
    private SecretKey masterKey = this.generateSecret();

    public void setMasterKey(SecretKey mk) {
        this.masterKey = mk;
    }

    public SecretKey getMasterKey() {
        return this.masterKey;
    }

    public static SecretKey createSecretKey(byte[] key) {
        return SecretManager.createSecretKey((byte[])key);
    }

    public byte[] createPassword(ApplicationTokenIdentifier identifier) {
        return ApplicationTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.masterKey);
    }

    public byte[] retrievePassword(ApplicationTokenIdentifier identifier) throws SecretManager.InvalidToken {
        return ApplicationTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.masterKey);
    }

    public ApplicationTokenIdentifier createIdentifier() {
        return new ApplicationTokenIdentifier();
    }
}

