/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.StringHelper;

public class Apps {
    public static final String APP = "application";
    public static final String ID = "ID";
    private static final String SYSTEM_PATH_SEPARATOR = System.getProperty("path.separator");

    public static ApplicationId toAppID(String aid) {
        Iterator<String> it = StringHelper._split(aid).iterator();
        return Apps.toAppID(APP, aid, it);
    }

    public static ApplicationId toAppID(String prefix, String s, Iterator<String> it) {
        if (!it.hasNext() || !it.next().equals(prefix)) {
            Apps.throwParseException(StringHelper.sjoin(prefix, ID), s);
        }
        Apps.shouldHaveNext(prefix, s, it);
        ApplicationId appId = RecordFactoryProvider.getRecordFactory(null).newRecordInstance(ApplicationId.class);
        appId.setClusterTimestamp(Long.parseLong(it.next()));
        Apps.shouldHaveNext(prefix, s, it);
        appId.setId(Integer.parseInt(it.next()));
        return appId;
    }

    public static void shouldHaveNext(String prefix, String s, Iterator<String> it) {
        if (!it.hasNext()) {
            Apps.throwParseException(StringHelper.sjoin(prefix, ID), s);
        }
    }

    public static void throwParseException(String name, String s) {
        throw new YarnException(StringHelper.join("Error parsing ", name, ": ", s));
    }

    public static void setEnvFromInputString(Map<String, String> env, String envString) {
        if (envString != null && envString.length() > 0) {
            String[] childEnvs;
            for (String cEnv : childEnvs = envString.split(",")) {
                String envValue;
                String[] parts = cEnv.split("=");
                String value = env.get(parts[0]);
                value = value != null ? parts[1].replace("$" + parts[0], value) : ((value = System.getenv(parts[0])) != null ? parts[1].replace("$" + parts[0], value) : ((envValue = System.getenv(parts[1].substring(1))) != null ? envValue : parts[1].replace("$" + parts[0], "")));
                Apps.addToEnvironment(env, parts[0], value);
            }
        }
    }

    public static void addToEnvironment(Map<String, String> environment, String variable, String value) {
        String val = environment.get(variable);
        val = val == null ? value : val + SYSTEM_PATH_SEPARATOR + value;
        environment.put(variable, val);
    }
}

