/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.StringHelper;

public class ConverterUtils {
    public static final String APPLICATION_PREFIX = "application";
    public static final String CONTAINER_PREFIX = "container";
    public static final String APPLICATION_ATTEMPT_PREFIX = "appattempt";

    public static Path getPathFromYarnURL(URL url) throws URISyntaxException {
        String scheme = url.getScheme() == null ? "" : url.getScheme();
        String authority = "";
        if (url.getHost() != null) {
            authority = url.getHost();
            if (url.getPort() > 0) {
                authority = authority + ":" + url.getPort();
            }
        }
        return new Path(new URI(scheme, authority, url.getFile(), null, null).normalize());
    }

    public static Map<String, String> convertToString(Map<CharSequence, CharSequence> env) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<CharSequence, CharSequence> entry : env.entrySet()) {
            stringMap.put(((Object)entry.getKey()).toString(), ((Object)entry.getValue()).toString());
        }
        return stringMap;
    }

    public static URL getYarnUrlFromPath(Path path) {
        return ConverterUtils.getYarnUrlFromURI(path.toUri());
    }

    public static URL getYarnUrlFromURI(URI uri) {
        URL url = RecordFactoryProvider.getRecordFactory(null).newRecordInstance(URL.class);
        if (uri.getHost() != null) {
            url.setHost(uri.getHost());
        }
        url.setPort(uri.getPort());
        url.setScheme(uri.getScheme());
        url.setFile(uri.getPath());
        return url;
    }

    public static String toString(ApplicationId appId) {
        return appId.toString();
    }

    public static ApplicationId toApplicationId(RecordFactory recordFactory, String appIdStr) {
        Iterator<String> it = StringHelper._split(appIdStr).iterator();
        it.next();
        return ConverterUtils.toApplicationId(recordFactory, it);
    }

    private static ApplicationId toApplicationId(RecordFactory recordFactory, Iterator<String> it) {
        ApplicationId appId = recordFactory.newRecordInstance(ApplicationId.class);
        appId.setClusterTimestamp(Long.parseLong(it.next()));
        appId.setId(Integer.parseInt(it.next()));
        return appId;
    }

    private static ApplicationAttemptId toApplicationAttemptId(Iterator<String> it) throws NumberFormatException {
        ApplicationId appId = Records.newRecord(ApplicationId.class);
        appId.setClusterTimestamp(Long.parseLong(it.next()));
        appId.setId(Integer.parseInt(it.next()));
        ApplicationAttemptId appAttemptId = Records.newRecord(ApplicationAttemptId.class);
        appAttemptId.setApplicationId(appId);
        appAttemptId.setAttemptId(Integer.parseInt(it.next()));
        return appAttemptId;
    }

    private static ApplicationId toApplicationId(Iterator<String> it) throws NumberFormatException {
        ApplicationId appId = Records.newRecord(ApplicationId.class);
        appId.setClusterTimestamp(Long.parseLong(it.next()));
        appId.setId(Integer.parseInt(it.next()));
        return appId;
    }

    public static String toString(ContainerId cId) {
        return cId.toString();
    }

    public static NodeId toNodeId(String nodeIdStr) {
        String[] parts = nodeIdStr.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid NodeId [" + nodeIdStr + "]. Expected host:port");
        }
        try {
            NodeId nodeId = BuilderUtils.newNodeId(parts[0], Integer.parseInt(parts[1]));
            return nodeId;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid port: " + parts[1], e);
        }
    }

    public static ContainerId toContainerId(String containerIdStr) {
        Iterator<String> it = StringHelper._split(containerIdStr).iterator();
        if (!it.next().equals(CONTAINER_PREFIX)) {
            throw new IllegalArgumentException("Invalid ContainerId prefix: " + containerIdStr);
        }
        try {
            ApplicationAttemptId appAttemptID = ConverterUtils.toApplicationAttemptId(it);
            ContainerId containerId = Records.newRecord(ContainerId.class);
            containerId.setApplicationAttemptId(appAttemptID);
            containerId.setId(Integer.parseInt(it.next()));
            return containerId;
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Invalid ContainerId: " + containerIdStr, n);
        }
    }

    public static ApplicationAttemptId toApplicationAttemptId(String applicationAttmeptIdStr) {
        Iterator<String> it = StringHelper._split(applicationAttmeptIdStr).iterator();
        if (!it.next().equals(APPLICATION_ATTEMPT_PREFIX)) {
            throw new IllegalArgumentException("Invalid AppAttemptId prefix: " + applicationAttmeptIdStr);
        }
        try {
            return ConverterUtils.toApplicationAttemptId(it);
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Invalid AppAttemptId: " + applicationAttmeptIdStr, n);
        }
    }

    public static ApplicationId toApplicationId(String appIdStr) {
        Iterator<String> it = StringHelper._split(appIdStr).iterator();
        if (!it.next().equals(APPLICATION_PREFIX)) {
            throw new IllegalArgumentException("Invalid ApplicationId prefix: " + appIdStr);
        }
        try {
            return ConverterUtils.toApplicationId(it);
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Invalid AppAttemptId: " + appIdStr, n);
        }
    }
}

