/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class FSDownload
implements Callable<Path> {
    private static final Log LOG = LogFactory.getLog(FSDownload.class);
    private Random rand;
    private FileContext files;
    private final UserGroupInformation userUgi;
    private Configuration conf;
    private LocalResource resource;
    private Path destDirPath;
    private static final FsPermission cachePerms = new FsPermission(493);
    static final FsPermission PUBLIC_FILE_PERMS = new FsPermission(365);
    static final FsPermission PRIVATE_FILE_PERMS = new FsPermission(320);
    static final FsPermission PUBLIC_DIR_PERMS = new FsPermission(493);
    static final FsPermission PRIVATE_DIR_PERMS = new FsPermission(448);

    public FSDownload(FileContext files, UserGroupInformation ugi, Configuration conf, Path destDirPath, LocalResource resource, Random rand) {
        this.conf = conf;
        this.destDirPath = destDirPath;
        this.files = files;
        this.userUgi = ugi;
        this.resource = resource;
        this.rand = rand;
    }

    LocalResource getResource() {
        return this.resource;
    }

    private Path copy(Path sCopy, Path dstdir) throws IOException {
        FileSystem sourceFs = sCopy.getFileSystem(this.conf);
        Path dCopy = new Path(dstdir, sCopy.getName() + ".tmp");
        FileStatus sStat = sourceFs.getFileStatus(sCopy);
        if (sStat.getModificationTime() != this.resource.getTimestamp()) {
            throw new IOException("Resource " + sCopy + " changed on src filesystem (expected " + this.resource.getTimestamp() + ", was " + sStat.getModificationTime());
        }
        sourceFs.copyToLocalFile(sCopy, dCopy);
        return dCopy;
    }

    private long unpack(File localrsrc, File dst) throws IOException {
        switch (this.resource.getType()) {
            case ARCHIVE: {
                String lowerDst = dst.getName().toLowerCase();
                if (lowerDst.endsWith(".jar")) {
                    RunJar.unJar((File)localrsrc, (File)dst);
                    break;
                }
                if (lowerDst.endsWith(".zip")) {
                    FileUtil.unZip((File)localrsrc, (File)dst);
                    break;
                }
                if (lowerDst.endsWith(".tar.gz") || lowerDst.endsWith(".tgz") || lowerDst.endsWith(".tar")) {
                    FileUtil.unTar((File)localrsrc, (File)dst);
                    break;
                }
                LOG.warn((Object)("Cannot unpack " + localrsrc));
                if (localrsrc.renameTo(dst)) break;
                throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + dst + "]");
            }
            default: {
                if (localrsrc.renameTo(dst)) break;
                throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + dst + "]");
            }
        }
        return 0L;
    }

    @Override
    public Path call() throws Exception {
        Path tmp;
        Path sCopy;
        try {
            sCopy = ConverterUtils.getPathFromYarnURL(this.resource.getResource());
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid resource", e);
        }
        do {
            tmp = new Path(this.destDirPath, String.valueOf(this.rand.nextLong()));
        } while (this.files.util().exists(tmp));
        this.destDirPath = tmp;
        this.files.mkdir(this.destDirPath, cachePerms, false);
        final Path dst_work = new Path(this.destDirPath + "_tmp");
        this.files.mkdir(dst_work, cachePerms, false);
        Path dFinal = this.files.makeQualified(new Path(dst_work, sCopy.getName()));
        try {
            Path dTmp = null == this.userUgi ? this.files.makeQualified(this.copy(sCopy, dst_work)) : (Path)this.userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Path>(){

                @Override
                public Path run() throws Exception {
                    return FSDownload.this.files.makeQualified(FSDownload.this.copy(sCopy, dst_work));
                }
            });
            this.unpack(new File(dTmp.toUri()), new File(dFinal.toUri()));
            this.changePermissions(dFinal.getFileSystem(this.conf), dFinal);
            this.files.rename(dst_work, this.destDirPath, new Options.Rename[]{Options.Rename.OVERWRITE});
        }
        catch (Exception e) {
            try {
                this.files.delete(this.destDirPath, true);
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw e;
        }
        finally {
            try {
                this.files.delete(dst_work, true);
            }
            catch (FileNotFoundException ignore) {}
            this.rand = null;
            this.conf = null;
            this.resource = null;
        }
        return this.files.makeQualified(new Path(this.destDirPath, sCopy.getName()));
    }

    private void changePermissions(FileSystem fs, final Path path) throws IOException, InterruptedException {
        FileStatus fStatus = fs.getFileStatus(path);
        FsPermission perm = cachePerms;
        perm = this.resource.getVisibility() == LocalResourceVisibility.PUBLIC ? (fStatus.isDirectory() ? PUBLIC_DIR_PERMS : PUBLIC_FILE_PERMS) : (fStatus.isDirectory() ? PRIVATE_DIR_PERMS : PRIVATE_FILE_PERMS);
        LOG.debug((Object)("Changing permissions for path " + path + " to perm " + perm));
        final FsPermission fPerm = perm;
        if (null == this.userUgi) {
            this.files.setPermission(path, perm);
        } else {
            this.userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    FSDownload.this.files.setPermission(path, fPerm);
                    return null;
                }
            });
        }
        if (fStatus.isDirectory() && !fStatus.isSymlink()) {
            FileStatus[] statuses;
            for (FileStatus status : statuses = fs.listStatus(path)) {
                this.changePermissions(fs, status.getPath());
            }
        }
    }
}

