/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.ShutdownHookManager;

public class YarnUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Log LOG = LogFactory.getLog(YarnUncaughtExceptionHandler.class);

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (ShutdownHookManager.get().isShutdownInProgress()) {
            LOG.error((Object)("Thread " + t + " threw an Throwable, but we are shutting " + "down, so ignoring this"), e);
        } else if (e instanceof Error) {
            try {
                LOG.fatal((Object)("Thread " + t + " threw an Error.  Shutting down now..."), e);
            }
            catch (Throwable err) {
                // empty catch block
            }
            if (e instanceof OutOfMemoryError) {
                try {
                    System.err.println("Halting due to Out Of Memory Error...");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Runtime.getRuntime().halt(-1);
            } else {
                System.exit(-1);
            }
        } else {
            LOG.error((Object)("Thread " + t + " threw an Exception."), e);
        }
    }
}

