/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class AuxiliaryServiceHelper {
    public static final String NM_AUX_SERVICE = "NM_AUX_SERVICE_";

    public static ByteBuffer getServiceDataFromEnv(String serviceName, Map<String, String> env) {
        byte[] metaData = Base64.decodeBase64((String)env.get(AuxiliaryServiceHelper.getPrefixServiceName(serviceName)));
        return ByteBuffer.wrap(metaData);
    }

    public static void setServiceDataIntoEnv(String serviceName, ByteBuffer metaData, Map<String, String> env) {
        byte[] byteData = metaData.array();
        env.put(AuxiliaryServiceHelper.getPrefixServiceName(serviceName), Base64.encodeBase64String((byte[])byteData));
    }

    private static String getPrefixServiceName(String serviceName) {
        return NM_AUX_SERVICE + serviceName;
    }
}

