/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LogAggregationFileControllerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LogAggregationFileControllerFactory.class);
    private final Pattern p = Pattern.compile("^[A-Za-z_]+[A-Za-z0-9_]*$");
    private LinkedList<LogAggregationFileController> controllers = new LinkedList();
    private Configuration conf;

    /*
     * Enabled aggressive block sorting
     */
    public LogAggregationFileControllerFactory(Configuration conf) {
        this.conf = conf;
        Collection fileControllers = conf.getStringCollection("yarn.log-aggregation.file-formats");
        ArrayList<String> controllerClassName = new ArrayList<String>();
        HashMap<String, String> controllerChecker = new HashMap<String, String>();
        Iterator iterator = fileControllers.iterator();
        while (true) {
            String fileController;
            block10: {
                String dirSuffix;
                if (!iterator.hasNext()) {
                    return;
                }
                fileController = (String)iterator.next();
                Preconditions.checkArgument((boolean)this.validateAggregatedFileControllerName(fileController), (Object)("The FileControllerName: " + fileController + " set in " + "yarn.log-aggregation.file-formats" + " is invalid.The valid File Controller name should only contain a-zA-Z0-9_ and can not start with numbers"));
                String remoteDirStr = String.format("yarn.log-aggregation.%s.remote-app-log-dir", fileController);
                String remoteDir = conf.get(remoteDirStr);
                boolean defaultRemoteDir = false;
                if (remoteDir == null || remoteDir.isEmpty()) {
                    remoteDir = conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs");
                    defaultRemoteDir = true;
                }
                String suffixStr = String.format("yarn.log-aggregation.%s.remote-app-log-dir-suffix", fileController);
                String suffix = conf.get(suffixStr);
                boolean defaultSuffix = false;
                if (suffix == null || suffix.isEmpty()) {
                    suffix = conf.get("yarn.nodemanager.remote-app-log-dir-suffix", "logs");
                    defaultSuffix = true;
                }
                if (controllerChecker.containsKey(dirSuffix = remoteDir + "-" + suffix)) {
                    if (defaultRemoteDir && defaultSuffix) {
                        String fileControllerStr = (String)controllerChecker.get(dirSuffix);
                        ArrayList<String> controllersList = new ArrayList<String>();
                        controllersList.add(fileControllerStr);
                        controllersList.add(fileController);
                        fileControllerStr = StringUtils.join(controllersList, (String)",");
                        controllerChecker.put(dirSuffix, fileControllerStr);
                        break block10;
                    } else {
                        String conflictController = (String)controllerChecker.get(dirSuffix);
                        throw new RuntimeException("The combined value of " + remoteDirStr + " and " + suffixStr + " should not be the same as the value set for " + conflictController);
                    }
                }
                controllerChecker.put(dirSuffix, fileController);
            }
            String classKey = String.format("yarn.log-aggregation.file-controller.%s.class", fileController);
            String className = conf.get(classKey);
            if (className == null || className.isEmpty()) {
                throw new RuntimeException("No class configured for " + fileController);
            }
            controllerClassName.add(className);
            Class sClass = conf.getClass(classKey, null, LogAggregationFileController.class);
            if (sClass == null) {
                throw new RuntimeException("No class defined for " + fileController);
            }
            LogAggregationFileController s = (LogAggregationFileController)ReflectionUtils.newInstance((Class)sClass, (Configuration)conf);
            if (s == null) {
                throw new RuntimeException("No object created for " + controllerClassName);
            }
            s.initialize(conf, fileController);
            this.controllers.add(s);
        }
    }

    public LogAggregationFileController getFileControllerForWrite() {
        return this.controllers.getFirst();
    }

    public LogAggregationFileController getFileControllerForRead(ApplicationId appId, String appOwner) throws IOException {
        Path remoteAppLogDir;
        StringBuilder diagnosticsMsg = new StringBuilder();
        if (LogAggregationUtils.isOlderPathEnabled(this.conf)) {
            for (LogAggregationFileController fileController : this.controllers) {
                try {
                    remoteAppLogDir = fileController.getOlderRemoteAppLogDir(appId, appOwner);
                    if (!LogAggregationUtils.getNodeFiles(this.conf, remoteAppLogDir, appId, appOwner).hasNext()) continue;
                    return fileController;
                }
                catch (Exception ex) {
                    diagnosticsMsg.append(ex.getMessage() + "\n");
                }
            }
        }
        for (LogAggregationFileController fileController : this.controllers) {
            try {
                remoteAppLogDir = fileController.getRemoteAppLogDir(appId, appOwner);
                if (!LogAggregationUtils.getNodeFiles(this.conf, remoteAppLogDir, appId, appOwner).hasNext()) continue;
                return fileController;
            }
            catch (Exception ex) {
                diagnosticsMsg.append(ex.getMessage() + "\n");
            }
        }
        throw new IOException(diagnosticsMsg.toString());
    }

    private boolean validateAggregatedFileControllerName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        return this.p.matcher(name).matches();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public LinkedList<LogAggregationFileController> getConfiguredLogAggregationFileControllerList() {
        return this.controllers;
    }
}

