/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;

public class ContainerTokenSecretManager
extends SecretManager<ContainerTokenIdentifier> {
    private static Log LOG = LogFactory.getLog(ContainerTokenSecretManager.class);
    Map<String, SecretKey> secretkeys = new ConcurrentHashMap<String, SecretKey>();

    public SecretKey createAndGetSecretKey(CharSequence hostName) {
        String hostNameStr = ((Object)hostName).toString();
        if (!this.secretkeys.containsKey(hostNameStr)) {
            LOG.debug((Object)("Creating secretKey for NM " + hostNameStr));
            this.secretkeys.put(hostNameStr, ContainerTokenSecretManager.createSecretKey((byte[])"mySecretKey".getBytes()));
        }
        return this.secretkeys.get(hostNameStr);
    }

    public void setSecretKey(CharSequence hostName, byte[] secretKeyBytes) {
        this.secretkeys.put(((Object)hostName).toString(), ContainerTokenSecretManager.createSecretKey((byte[])secretKeyBytes));
    }

    public byte[] createPassword(ContainerTokenIdentifier identifier) {
        LOG.debug((Object)("Creating password for " + identifier.getContainerID() + " to be run on NM " + identifier.getNmHostAddress() + " " + this.secretkeys.get(identifier.getNmHostAddress())));
        return ContainerTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.secretkeys.get(identifier.getNmHostAddress()));
    }

    public byte[] retrievePassword(ContainerTokenIdentifier identifier) throws SecretManager.InvalidToken {
        LOG.debug((Object)("Retrieving password for " + identifier.getContainerID() + " to be run on NM " + identifier.getNmHostAddress()));
        return ContainerTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.secretkeys.get(identifier.getNmHostAddress()));
    }

    public ContainerTokenIdentifier createIdentifier() {
        return new ContainerTokenIdentifier();
    }
}

