/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerBlock
extends HtmlBlock {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerBlock.class);
    protected ApplicationBaseProtocol appBaseProt;

    @Inject
    public ContainerBlock(ApplicationBaseProtocol appBaseProt, View.ViewContext ctx) {
        super(ctx);
        this.appBaseProt = appBaseProt;
    }

    protected void render(HtmlBlock.Block html) {
        String containerid = this.$("container.id");
        if (containerid.isEmpty()) {
            this.puts(new Object[]{"Bad request: requires container ID"});
            return;
        }
        ContainerId containerId = null;
        try {
            containerId = ContainerId.fromString((String)containerid);
        }
        catch (IllegalArgumentException e) {
            this.puts(new Object[]{"Invalid container ID: " + containerid});
            return;
        }
        UserGroupInformation callerUGI = this.getCallerUGI();
        ContainerReport containerReport = null;
        try {
            final GetContainerReportRequest request = GetContainerReportRequest.newInstance((ContainerId)containerId);
            containerReport = callerUGI == null ? this.getContainerReport(request) : (ContainerReport)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ContainerReport>(){

                @Override
                public ContainerReport run() throws Exception {
                    return ContainerBlock.this.getContainerReport(request);
                }
            });
        }
        catch (Exception e) {
            String message = "Failed to read the container " + containerid + ".";
            LOG.error(message, (Throwable)e);
            html.p().__(new Object[]{message}).__();
            return;
        }
        if (containerReport == null) {
            this.puts(new Object[]{"Container not found: " + containerid});
            return;
        }
        ContainerInfo container = new ContainerInfo(containerReport);
        this.setTitle(StringHelper.join((Object[])new Object[]{"Container ", containerid}));
        this.info("Container Overview").__("Container State:", (Object)(container.getContainerState() == null ? "N/A" : container.getContainerState())).__("Exit Status:", (Object)container.getContainerExitStatus()).__("Node:", container.getNodeHttpAddress() == null ? "#" : container.getNodeHttpAddress(), (Object)(container.getNodeHttpAddress() == null ? "N/A" : container.getNodeHttpAddress())).__("Priority:", (Object)container.getPriority()).__("Started:", (Object)Times.format((long)container.getStartedTime())).__("Elapsed:", (Object)StringUtils.formatTime((long)Times.elapsed((long)container.getStartedTime(), (long)container.getFinishedTime()))).__("Resource:", (Object)this.getResources(container)).__("Logs:", container.getLogUrl() == null ? "#" : container.getLogUrl(), (Object)(container.getLogUrl() == null ? "N/A" : "Logs")).__("Diagnostics:", (Object)(container.getDiagnosticsInfo() == null ? "" : container.getDiagnosticsInfo()));
        html.__(InfoBlock.class);
    }

    @VisibleForTesting
    String getResources(ContainerInfo container) {
        Map<String, Long> allocatedResources = container.getAllocatedResources();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getResourceAsString("memory-mb", allocatedResources.get("memory-mb"))).append(", ");
        sb.append(this.getResourceAsString("vcores", allocatedResources.get("vcores")));
        if (container.hasCustomResources()) {
            container.getAllocatedResources().forEach((key, value) -> {
                if (!key.equals("memory-mb") && !key.equals("vcores")) {
                    sb.append(", ");
                    sb.append(this.getResourceAsString((String)key, (long)value));
                }
            });
        }
        return sb.toString();
    }

    private String getResourceAsString(String resourceName, long value) {
        String translatedResourceName;
        switch (resourceName) {
            case "memory-mb": {
                translatedResourceName = "Memory";
                break;
            }
            case "vcores": {
                translatedResourceName = "VCores";
                break;
            }
            default: {
                translatedResourceName = resourceName;
            }
        }
        return String.valueOf(value) + " " + translatedResourceName;
    }

    protected ContainerReport getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        return this.appBaseProt.getContainerReport(request).getContainerReport();
    }
}

