/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.webapp.AllApplicationsPage;
import org.apache.hadoop.yarn.server.nodemanager.webapp.AllContainersPage;
import org.apache.hadoop.yarn.server.nodemanager.webapp.ApplicationPage;
import org.apache.hadoop.yarn.server.nodemanager.webapp.ContainerLogsPage;
import org.apache.hadoop.yarn.server.nodemanager.webapp.ContainerPage;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NodePage;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.YarnWebParams;

public class NMController
extends Controller
implements YarnWebParams {
    private Context nmContext;
    private Configuration nmConf;

    @Inject
    public NMController(Configuration nmConf, Controller.RequestContext requestContext, Context nmContext) {
        super(requestContext);
        this.nmContext = nmContext;
        this.nmConf = nmConf;
    }

    public void index() {
        this.setTitle(StringHelper.join((Object[])new Object[]{"NodeManager - ", this.$("nm.id")}));
    }

    public void info() {
        this.render(NodePage.class);
    }

    public void node() {
        this.render(NodePage.class);
    }

    public void allApplications() {
        this.render(AllApplicationsPage.class);
    }

    public void allContainers() {
        this.render(AllContainersPage.class);
    }

    public void application() {
        this.render(ApplicationPage.class);
    }

    public void container() {
        this.render(ContainerPage.class);
    }

    public void logs() {
        String containerIdStr = this.$("container.id");
        ContainerId containerId = null;
        try {
            containerId = ConverterUtils.toContainerId((String)containerIdStr);
        }
        catch (IllegalArgumentException e) {
            this.render(ContainerLogsPage.class);
            return;
        }
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        Application app = (Application)this.nmContext.getApplications().get(appId);
        if (app == null && this.nmConf.getBoolean("yarn.nodemanager.log-aggregation-enable", false)) {
            String logServerUrl = this.nmConf.get("yarn.log.server.url");
            String redirectUrl = null;
            redirectUrl = logServerUrl == null || logServerUrl.isEmpty() ? "false" : this.url(new String[]{logServerUrl, this.nmContext.getNodeId().toString(), containerIdStr, containerIdStr, this.$("app.owner")});
            this.set("redirect.url", redirectUrl);
        }
        this.render(ContainerLogsPage.class);
    }
}

