/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.api.impl.pb.client;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.exceptions.impl.pb.YarnRemoteExceptionPBImpl;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerServiceProtos;
import org.apache.hadoop.yarn.server.nodemanager.api.LocalizationProtocol;
import org.apache.hadoop.yarn.server.nodemanager.api.LocalizationProtocolPB;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.LocalizerHeartbeatResponse;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.LocalizerStatus;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.impl.pb.LocalizerHeartbeatResponsePBImpl;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.impl.pb.LocalizerStatusPBImpl;

public class LocalizationProtocolPBClientImpl
implements LocalizationProtocol {
    private LocalizationProtocolPB proxy;

    public LocalizationProtocolPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, LocalizationProtocolPB.class, ProtobufRpcEngine.class);
        this.proxy = (LocalizationProtocolPB)RPC.getProxy(LocalizationProtocolPB.class, (long)clientVersion, (InetSocketAddress)addr, (Configuration)conf);
    }

    @Override
    public LocalizerHeartbeatResponse heartbeat(LocalizerStatus status) throws YarnRemoteException {
        YarnServerNodemanagerServiceProtos.LocalizerStatusProto statusProto = ((LocalizerStatusPBImpl)status).getProto();
        try {
            return new LocalizerHeartbeatResponsePBImpl(this.proxy.heartbeat(null, statusProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }
}

