/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;

public class DeletionService
extends AbstractService {
    static final Log LOG = LogFactory.getLog(DeletionService.class);
    private int debugDelay;
    private final ContainerExecutor exec;
    private ScheduledThreadPoolExecutor sched;
    private final FileContext lfs = DeletionService.getLfs();

    static final FileContext getLfs() {
        try {
            return FileContext.getLocalFSFileContext();
        }
        catch (UnsupportedFileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public DeletionService(ContainerExecutor exec) {
        super(DeletionService.class.getName());
        this.exec = exec;
        this.debugDelay = 0;
    }

    public void delete(String user, Path subDir, Path ... baseDirs) {
        if (this.debugDelay != -1) {
            this.sched.schedule(new FileDeletion(user, subDir, baseDirs), (long)this.debugDelay, TimeUnit.SECONDS);
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("DeletionService #%d").build();
        if (conf != null) {
            this.sched = new ScheduledThreadPoolExecutor(conf.getInt("yarn.nodemanager.delete.thread-count", 4), tf);
            this.debugDelay = conf.getInt("yarn.nodemanager.delete.debug-delay-sec", 0);
        } else {
            this.sched = new ScheduledThreadPoolExecutor(4, tf);
        }
        this.sched.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.sched.setKeepAliveTime(60L, TimeUnit.SECONDS);
        super.serviceInit(conf);
    }

    protected void serviceStop() throws Exception {
        if (this.sched != null) {
            this.sched.shutdown();
            boolean terminated = false;
            try {
                terminated = this.sched.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!terminated) {
                this.sched.shutdownNow();
            }
        }
        super.serviceStop();
    }

    @InterfaceAudience.Private
    public boolean isTerminated() {
        return this.getServiceState() == Service.STATE.STOPPED && this.sched.isTerminated();
    }

    private class FileDeletion
    implements Runnable {
        final String user;
        final Path subDir;
        final Path[] baseDirs;

        FileDeletion(String user, Path subDir, Path[] baseDirs) {
            this.user = user;
            this.subDir = subDir;
            this.baseDirs = baseDirs;
        }

        @Override
        public void run() {
            if (null == this.user) {
                if (this.baseDirs == null || this.baseDirs.length == 0) {
                    LOG.debug((Object)("NM deleting absolute path : " + this.subDir));
                    try {
                        DeletionService.this.lfs.delete(this.subDir, true);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Failed to delete " + this.subDir));
                    }
                    return;
                }
                for (Path baseDir : this.baseDirs) {
                    Path del = this.subDir == null ? baseDir : new Path(baseDir, this.subDir);
                    LOG.debug((Object)("NM deleting path : " + del));
                    try {
                        DeletionService.this.lfs.delete(del, true);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Failed to delete " + this.subDir));
                    }
                }
            } else {
                try {
                    LOG.debug((Object)("Deleting path: [" + this.subDir + "] as user: [" + this.user + "]"));
                    DeletionService.this.exec.deleteAsUser(this.user, this.subDir, this.baseDirs);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to delete as user " + this.user), (Throwable)e);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)("Failed to delete as user " + this.user), (Throwable)e);
                }
            }
        }
    }
}

