/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class ContainerPage
extends NMView
implements YarnWebParams {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        this.setTitle("Container " + this.$("container.id"));
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:0}");
    }

    protected Class<? extends SubView> content() {
        return ContainerBlock.class;
    }

    public static class ContainerBlock
    extends HtmlBlock
    implements YarnWebParams {
        private final Context nmContext;

        @Inject
        public ContainerBlock(Context nmContext) {
            this.nmContext = nmContext;
        }

        protected void render(HtmlBlock.Block html) {
            ContainerId containerID;
            try {
                containerID = ContainerId.fromString((String)this.$("container.id"));
            }
            catch (IllegalArgumentException e) {
                html.p()._(new Object[]{"Invalid containerId " + this.$("container.id")})._();
                return;
            }
            Hamlet.DIV div = html.div("#content");
            Container container = (Container)this.nmContext.getContainers().get(containerID);
            if (container == null) {
                div.h1("Unknown Container. Container might have completed, please go back to the previous page and retry.")._();
                return;
            }
            ContainerInfo info = new ContainerInfo(this.nmContext, container);
            this.info("Container information")._("ContainerID", (Object)info.getId())._("ContainerState", (Object)info.getState())._("ExitStatus", (Object)info.getExitStatus())._("Diagnostics", (Object)info.getDiagnostics())._("User", (Object)info.getUser())._("TotalMemoryNeeded", (Object)info.getMemoryNeeded())._("TotalVCoresNeeded", (Object)info.getVCoresNeeded())._("ExecutionType", (Object)info.getExecutionType())._("logs", info.getShortLogLink(), (Object)"Link to logs");
            html._(InfoBlock.class);
        }
    }
}

