/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.VersionUtil;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.ServerRMProxy;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.util.YarnVersionInfo;

public class NodeStatusUpdaterImpl
extends AbstractService
implements NodeStatusUpdater {
    public static final String YARN_NODEMANAGER_DURATION_TO_TRACK_STOPPED_CONTAINERS = "yarn.nodemanager.duration-to-track-stopped-containers";
    private static final Log LOG = LogFactory.getLog(NodeStatusUpdaterImpl.class);
    private final Object heartbeatMonitor = new Object();
    private final Context context;
    private final Dispatcher dispatcher;
    private NodeId nodeId;
    private long nextHeartBeatInterval;
    private ResourceTracker resourceTracker;
    private Resource totalResource;
    private int httpPort;
    private String nodeManagerVersionId;
    private String minimumResourceManagerVersion;
    private volatile boolean isStopped;
    private boolean tokenKeepAliveEnabled;
    private long tokenRemovalDelayMs;
    private Map<ApplicationId, Long> appTokenKeepAliveMap = new HashMap<ApplicationId, Long>();
    private Random keepAliveDelayRandom = new Random();
    private final Map<ContainerId, Long> recentlyStoppedContainers;
    private long durationToTrackStoppedContainers;
    private final Set<ContainerId> previousCompletedContainers;
    private final NodeHealthCheckerService healthChecker;
    private final NodeManagerMetrics metrics;
    private Runnable statusUpdaterRunnable;
    private Thread statusUpdater;
    private long rmIdentifier = -1L;

    public NodeStatusUpdaterImpl(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker, NodeManagerMetrics metrics) {
        super(NodeStatusUpdaterImpl.class.getName());
        this.healthChecker = healthChecker;
        this.context = context;
        this.dispatcher = dispatcher;
        this.metrics = metrics;
        this.recentlyStoppedContainers = new LinkedHashMap<ContainerId, Long>();
        this.previousCompletedContainers = new HashSet<ContainerId>();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        int memoryMb = conf.getInt("yarn.nodemanager.resource.memory-mb", 8192);
        float vMemToPMem = conf.getFloat("yarn.nodemanager.vmem-pmem-ratio", 2.1f);
        int virtualMemoryMb = (int)Math.ceil((float)memoryMb * vMemToPMem);
        int virtualCores = conf.getInt("yarn.nodemanager.resource.cpu-vcores", 8);
        this.totalResource = Resource.newInstance((int)memoryMb, (int)virtualCores);
        this.metrics.addResource(this.totalResource);
        this.tokenKeepAliveEnabled = this.isTokenKeepAliveEnabled(conf);
        this.tokenRemovalDelayMs = conf.getInt("yarn.nm.liveness-monitor.expiry-interval-ms", 600000);
        this.minimumResourceManagerVersion = conf.get("yarn.nodemanager.resourcemanager.minimum.version", "NONE");
        this.durationToTrackStoppedContainers = conf.getLong(YARN_NODEMANAGER_DURATION_TO_TRACK_STOPPED_CONTAINERS, 600000L);
        if (this.durationToTrackStoppedContainers < 0L) {
            String message = "Invalid configuration for yarn.nodemanager.duration-to-track-stopped-containers default value is 10Min(600000).";
            LOG.error((Object)message);
            throw new YarnException(message);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("yarn.nodemanager.duration-to-track-stopped-containers :" + this.durationToTrackStoppedContainers));
        }
        super.serviceInit(conf);
        LOG.info((Object)("Initialized nodemanager for " + this.nodeId + ":" + " physical-memory=" + memoryMb + " virtual-memory=" + virtualMemoryMb + " virtual-cores=" + virtualCores));
    }

    protected void serviceStart() throws Exception {
        this.nodeId = this.context.getNodeId();
        this.httpPort = this.context.getHttpPort();
        this.nodeManagerVersionId = YarnVersionInfo.getVersion();
        try {
            this.resourceTracker = this.getRMClient();
            this.registerWithRM();
            super.serviceStart();
            this.startStatusUpdater();
        }
        catch (Exception e) {
            String errorMessage = "Unexpected error starting NodeStatusUpdater";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    protected void serviceStop() throws Exception {
        this.isStopped = true;
        this.stopRMProxy();
        super.serviceStop();
    }

    protected void rebootNodeStatusUpdaterAndRegisterWithRM() {
        this.isStopped = true;
        try {
            this.statusUpdater.join();
            this.registerWithRM();
            this.statusUpdater = new Thread(this.statusUpdaterRunnable, "Node Status Updater");
            this.isStopped = false;
            this.statusUpdater.start();
            LOG.info((Object)"NodeStatusUpdater thread is reRegistered and restarted");
        }
        catch (Exception e) {
            String errorMessage = "Unexpected error rebooting NodeStatusUpdater";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    @VisibleForTesting
    protected void stopRMProxy() {
        if (this.resourceTracker != null) {
            RPC.stopProxy((Object)this.resourceTracker);
        }
    }

    @InterfaceAudience.Private
    protected boolean isTokenKeepAliveEnabled(Configuration conf) {
        return conf.getBoolean("yarn.log-aggregation-enable", false) && UserGroupInformation.isSecurityEnabled();
    }

    @VisibleForTesting
    protected ResourceTracker getRMClient() throws IOException {
        Configuration conf = this.getConfig();
        return (ResourceTracker)ServerRMProxy.createRMProxy((Configuration)conf, ResourceTracker.class);
    }

    @VisibleForTesting
    protected void registerWithRM() throws YarnException, IOException {
        MasterKey masterKey;
        List<NMContainerStatus> containerReports = this.getNMContainerStatuses();
        RegisterNodeManagerRequest request = RegisterNodeManagerRequest.newInstance((NodeId)this.nodeId, (int)this.httpPort, (Resource)this.totalResource, (String)this.nodeManagerVersionId, containerReports, this.getRunningApplications());
        if (containerReports != null) {
            LOG.info((Object)("Registering with RM using containers :" + containerReports));
        }
        RegisterNodeManagerResponse regNMResponse = this.resourceTracker.registerNodeManager(request);
        this.rmIdentifier = regNMResponse.getRMIdentifier();
        if (NodeAction.SHUTDOWN.equals((Object)regNMResponse.getNodeAction())) {
            String message = "Message from ResourceManager: " + regNMResponse.getDiagnosticsMessage();
            throw new YarnRuntimeException("Recieved SHUTDOWN signal from Resourcemanager ,Registration of NodeManager failed, " + message);
        }
        if (!this.minimumResourceManagerVersion.equals("NONE")) {
            String rmVersion;
            if (this.minimumResourceManagerVersion.equals("EqualToNM")) {
                this.minimumResourceManagerVersion = this.nodeManagerVersionId;
            }
            if ((rmVersion = regNMResponse.getRMVersion()) == null) {
                String message = "The Resource Manager's did not return a version. Valid version cannot be checked.";
                throw new YarnRuntimeException("Shutting down the Node Manager. " + message);
            }
            if (VersionUtil.compareVersions((String)rmVersion, (String)this.minimumResourceManagerVersion) < 0) {
                String message = "The Resource Manager's version (" + rmVersion + ") is less than the minimum " + "allowed version " + this.minimumResourceManagerVersion;
                throw new YarnRuntimeException("Shutting down the Node Manager on RM version error, " + message);
            }
        }
        if ((masterKey = regNMResponse.getContainerTokenMasterKey()) != null) {
            this.context.getContainerTokenSecretManager().setMasterKey(masterKey);
        }
        if ((masterKey = regNMResponse.getNMTokenMasterKey()) != null) {
            this.context.getNMTokenSecretManager().setMasterKey(masterKey);
        }
        LOG.info((Object)("Registered with ResourceManager as " + this.nodeId + " with total resource of " + this.totalResource));
        LOG.info((Object)"Notifying ContainerManager to unblock new container-requests");
        ((ContainerManagerImpl)this.context.getContainerManager()).setBlockNewContainerRequests(false);
    }

    private List<ApplicationId> createKeepAliveApplicationList() {
        if (!this.tokenKeepAliveEnabled) {
            return Collections.emptyList();
        }
        ArrayList<ApplicationId> appList = new ArrayList<ApplicationId>();
        Iterator<Map.Entry<ApplicationId, Long>> i = this.appTokenKeepAliveMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<ApplicationId, Long> e = i.next();
            ApplicationId appId = e.getKey();
            Long nextKeepAlive = e.getValue();
            if (!this.context.getApplications().containsKey(appId)) {
                i.remove();
                continue;
            }
            if (System.currentTimeMillis() <= nextKeepAlive) continue;
            appList.add(appId);
            this.trackAppForKeepAlive(appId);
        }
        return appList;
    }

    private NodeStatus getNodeStatus(int responseId) {
        NodeHealthStatus nodeHealthStatus = this.context.getNodeHealthStatus();
        nodeHealthStatus.setHealthReport(this.healthChecker.getHealthReport());
        nodeHealthStatus.setIsNodeHealthy(this.healthChecker.isHealthy());
        nodeHealthStatus.setLastHealthReportTime(this.healthChecker.getLastHealthReportTime());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node's health-status : " + nodeHealthStatus.getIsNodeHealthy() + ", " + nodeHealthStatus.getHealthReport()));
        }
        List<ContainerStatus> containersStatuses = this.getContainerStatuses();
        NodeStatus nodeStatus = NodeStatus.newInstance((NodeId)this.nodeId, (int)responseId, containersStatuses, this.createKeepAliveApplicationList(), (NodeHealthStatus)nodeHealthStatus);
        return nodeStatus;
    }

    @VisibleForTesting
    protected List<ContainerStatus> getContainerStatuses() {
        ArrayList<ContainerStatus> containerStatuses = new ArrayList<ContainerStatus>();
        for (Container container : this.context.getContainers().values()) {
            ContainerStatus containerStatus = container.cloneAndGetContainerStatus();
            containerStatuses.add(containerStatus);
            if (!containerStatus.getState().equals((Object)ContainerState.COMPLETE)) continue;
            this.updateStoppedContainersInCache(container.getContainerId());
            this.addCompletedContainer(container);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sending out " + containerStatuses.size() + " container statuses: " + containerStatuses));
        }
        return containerStatuses;
    }

    private List<ApplicationId> getRunningApplications() {
        ArrayList<ApplicationId> runningApplications = new ArrayList<ApplicationId>();
        runningApplications.addAll(this.context.getApplications().keySet());
        return runningApplications;
    }

    private List<NMContainerStatus> getNMContainerStatuses() {
        ArrayList<NMContainerStatus> containerStatuses = new ArrayList<NMContainerStatus>();
        for (Container container : this.context.getContainers().values()) {
            NMContainerStatus status = container.getNMContainerStatus();
            containerStatuses.add(status);
            if (!status.getContainerState().equals((Object)ContainerState.COMPLETE)) continue;
            this.updateStoppedContainersInCache(container.getContainerId());
            this.addCompletedContainer(container);
        }
        LOG.info((Object)("Sending out " + containerStatuses.size() + " NM container statuses: " + containerStatuses));
        return containerStatuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCompletedContainer(Container container) {
        Set<ContainerId> set = this.previousCompletedContainers;
        synchronized (set) {
            this.previousCompletedContainers.add(container.getContainerId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCompletedContainersFromContext() {
        Set<ContainerId> set = this.previousCompletedContainers;
        synchronized (set) {
            if (!this.previousCompletedContainers.isEmpty()) {
                for (ContainerId containerId : this.previousCompletedContainers) {
                    this.context.getContainers().remove(containerId);
                }
                LOG.info((Object)("Removed completed containers from NM context: " + this.previousCompletedContainers));
                this.previousCompletedContainers.clear();
            }
        }
    }

    private void trackAppsForKeepAlive(List<ApplicationId> appIds) {
        if (this.tokenKeepAliveEnabled && appIds != null && appIds.size() > 0) {
            for (ApplicationId appId : appIds) {
                this.trackAppForKeepAlive(appId);
            }
        }
    }

    private void trackAppForKeepAlive(ApplicationId appId) {
        long nextTime = System.currentTimeMillis() + (long)(0.7 * (double)this.tokenRemovalDelayMs + 0.2 * (double)this.tokenRemovalDelayMs * (double)this.keepAliveDelayRandom.nextInt(100) / 100.0);
        this.appTokenKeepAliveMap.put(appId, nextTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOutofBandHeartBeat() {
        Object object = this.heartbeatMonitor;
        synchronized (object) {
            this.heartbeatMonitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isContainerRecentlyStopped(ContainerId containerId) {
        Map<ContainerId, Long> map = this.recentlyStoppedContainers;
        synchronized (map) {
            return this.recentlyStoppedContainers.containsKey(containerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public void updateStoppedContainersInCache(ContainerId containerId) {
        Map<ContainerId, Long> map = this.recentlyStoppedContainers;
        synchronized (map) {
            this.removeVeryOldStoppedContainersFromCache();
            this.recentlyStoppedContainers.put(containerId, System.currentTimeMillis() + this.durationToTrackStoppedContainers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFinishedContainersFromCache() {
        Map<ContainerId, Long> map = this.recentlyStoppedContainers;
        synchronized (map) {
            this.recentlyStoppedContainers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public void removeVeryOldStoppedContainersFromCache() {
        Map<ContainerId, Long> map = this.recentlyStoppedContainers;
        synchronized (map) {
            long currentTime = System.currentTimeMillis();
            Iterator<ContainerId> i = this.recentlyStoppedContainers.keySet().iterator();
            while (i.hasNext() && this.recentlyStoppedContainers.get(i.next()) < currentTime) {
                i.remove();
            }
        }
    }

    @Override
    public long getRMIdentifier() {
        return this.rmIdentifier;
    }

    protected void startStatusUpdater() {
        this.statusUpdaterRunnable = new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private void updateMasterKeys(NodeHeartbeatResponse response) {
                MasterKey updatedMasterKey = response.getContainerTokenMasterKey();
                if (updatedMasterKey != null) {
                    NodeStatusUpdaterImpl.this.context.getContainerTokenSecretManager().setMasterKey(updatedMasterKey);
                }
                if ((updatedMasterKey = response.getNMTokenMasterKey()) != null) {
                    NodeStatusUpdaterImpl.this.context.getNMTokenSecretManager().setMasterKey(updatedMasterKey);
                }
            }
        };
        this.statusUpdater = new Thread(this.statusUpdaterRunnable, "Node Status Updater");
        this.statusUpdater.start();
    }

    static /* synthetic */ boolean access$000(NodeStatusUpdaterImpl x0) {
        return x0.isStopped;
    }

    static /* synthetic */ NodeStatus access$100(NodeStatusUpdaterImpl x0, int x1) {
        return x0.getNodeStatus(x1);
    }

    static /* synthetic */ ResourceTracker access$300(NodeStatusUpdaterImpl x0) {
        return x0.resourceTracker;
    }

    static /* synthetic */ long access$402(NodeStatusUpdaterImpl x0, long x1) {
        x0.nextHeartBeatInterval = x1;
        return x0.nextHeartBeatInterval;
    }

    static /* synthetic */ Log access$500() {
        return LOG;
    }

    static /* synthetic */ Dispatcher access$600(NodeStatusUpdaterImpl x0) {
        return x0.dispatcher;
    }

    static /* synthetic */ long access$702(NodeStatusUpdaterImpl x0, long x1) {
        x0.rmIdentifier = x1;
        return x0.rmIdentifier;
    }

    static /* synthetic */ void access$800(NodeStatusUpdaterImpl x0) {
        x0.removeCompletedContainersFromContext();
    }

    static /* synthetic */ void access$900(NodeStatusUpdaterImpl x0, List x1) {
        x0.trackAppsForKeepAlive(x1);
    }

    static /* synthetic */ Object access$1000(NodeStatusUpdaterImpl x0) {
        return x0.heartbeatMonitor;
    }

    static /* synthetic */ long access$400(NodeStatusUpdaterImpl x0) {
        return x0.nextHeartBeatInterval;
    }
}

