/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourcesTracker;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalizedResource;

public class ResourceRetentionSet {
    private long delSize;
    private long currentSize;
    private final long targetSize;
    private final DeletionService delService;
    private final SortedMap<LocalizedResource, LocalResourcesTracker> retain;

    ResourceRetentionSet(DeletionService delService, long targetSize) {
        this(delService, targetSize, new LRUComparator());
    }

    ResourceRetentionSet(DeletionService delService, long targetSize, Comparator<? super LocalizedResource> cmp) {
        this(delService, targetSize, new TreeMap<LocalizedResource, LocalResourcesTracker>(cmp));
    }

    ResourceRetentionSet(DeletionService delService, long targetSize, SortedMap<LocalizedResource, LocalResourcesTracker> retain) {
        this.retain = retain;
        this.delService = delService;
        this.targetSize = targetSize;
    }

    public void addResources(LocalResourcesTracker newTracker) {
        for (LocalizedResource resource : newTracker) {
            this.currentSize += resource.getSize();
            if (resource.getRefCount() > 0) continue;
            this.retain.put(resource, newTracker);
        }
        Iterator<Map.Entry<LocalizedResource, LocalResourcesTracker>> i = this.retain.entrySet().iterator();
        while (this.currentSize - this.delSize > this.targetSize && i.hasNext()) {
            Map.Entry<LocalizedResource, LocalResourcesTracker> rsrc = i.next();
            LocalizedResource resource = rsrc.getKey();
            LocalResourcesTracker tracker = rsrc.getValue();
            if (!tracker.remove(resource, this.delService)) continue;
            this.delSize += resource.getSize();
            i.remove();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cache: ").append(this.currentSize).append(", ");
        sb.append("Deleted: ").append(this.delSize);
        return sb.toString();
    }

    static class LRUComparator
    implements Comparator<LocalizedResource> {
        LRUComparator() {
        }

        @Override
        public int compare(LocalizedResource r1, LocalizedResource r2) {
            long ret = r1.getTimestamp() - r2.getTimestamp();
            if (0L == ret) {
                return System.identityHashCode(r1) - System.identityHashCode(r2);
            }
            return ret > 0L ? 1 : -1;
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }
    }
}

